/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.SignatureEncryptionAlgorithm;
import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4DataSource;
import de.pontonconsulting.xmlpipe.messenger.packaging.AttachmentCallbackHandler;
import de.pontonconsulting.xmlpipe.security.IWSSecurity;
import de.pontonconsulting.xmlpipe.security.SOAPUtil;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoBase;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.resolvers.PrivateKeyFromCryptoResolver;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.utils.resolver.ConcatKDFParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XpWSSecurity
implements IWSSecurity {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.XpWSSecurity");
    private static final String ENC_NS10 = "http://www.w3.org/2001/04/xmlenc#";
    private static final String ENC_NS11 = "http://www.w3.org/2009/xmlenc11#";
    private static final String DSIG_NS10 = "http://www.w3.org/2000/09/xmldsig#";
    private static final String DSIG_NS11 = "http://www.w3.org/2009/xmldsig11#";
    private static final Map<String, String> _digestAlgorithmToURI = new HashMap<String, String>();
    private static final Map<String, String> _signatureAlgorithmToURI;
    private static final Map<String, Integer> _keyInfoTypeToWSKeyInfo;
    private static final Map<String, Integer> signingKeyInfoTypeToWSKeyInfo;
    public static final Map<String, KeyEncryptionAlgorithm> keyEncAlgoToKeyEncAlgoObject;
    private static final Map<String, String> _uriToDigestAlgorithm;
    private static final Map<String, String> _uriToSignatureAlgorithm;
    private static final Map<STRParser.REFERENCE_TYPE, String> _wsKeyInfoToKeyInfoType;
    private static final Map<KeyEncryptionAlgorithm, String> keyEncAlgoObjectToKeyEncAlgo;
    private static final Map<String, String> _encryptionAlgorithmToURI;
    private static final Map<String, String> _uriToEncryptionAlgorithm;
    private static final ThreadLocal<Crypto> CRYPTO_THREAD_LOCAL;

    private static void initThreadCache(Crypto crypto) {
        CRYPTO_THREAD_LOCAL.set(crypto);
        _log.trace("Crypto thread cache initialized");
    }

    private static void clearThreadCache() {
        CRYPTO_THREAD_LOCAL.remove();
        _log.trace("Crypto thread cache cleared");
    }

    public XpWSSecurity() {
        KeyResolver.register((KeyResolverSpi)new PrivateKeyFromCryptoResolver((Crypto)new CryptoWrapper(), callbacks -> {}), (boolean)true);
    }

    private Node findChildNode(Node parentNode, String childLocalName) {
        if (parentNode.hasChildNodes()) {
            NodeList childNodes = parentNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!childLocalName.equals(childNode.getLocalName())) continue;
                return childNode;
            }
        }
        return null;
    }

    private Node findAttribute(Node element, String attributeLocalName) {
        if (element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (!attributeLocalName.equals(attribute.getLocalName())) continue;
                return attribute;
            }
        }
        return null;
    }

    @Override
    public SecurityResult processSecurityHeaders(Crypto crypto4Decryption, Crypto crypto4SignVerification, SOAPMessage soapMessage, List<InputStream> openedInputStreams) throws WSSecurityException, ParseException, IOException, SOAPException, TransformerException {
        WSHandlerResult wsHandlerResults;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        XpWSSecurity.initThreadCache(crypto4Decryption);
        try {
            Iterator iterator = soapMessage.getAttachments();
            while (iterator.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                Attachment attachment = new Attachment();
                ContentType contentType = new ContentType(attachmentPart.getContentType());
                attachment.setMimeType(contentType.getBaseType());
                Object contentId = attachmentPart.getContentId();
                if (((String)contentId).startsWith("<") && ((String)contentId).endsWith(">")) {
                    contentId = ((String)contentId).substring(1, ((String)contentId).length() - 1);
                }
                attachment.setId((String)contentId);
                InputStream inputStream = attachmentPart.getDataHandler().getInputStream();
                openedInputStreams.add(inputStream);
                attachment.setSourceStream(inputStream);
                attachments.add(attachment);
            }
            AttachmentCallbackHandler attachmentCallbackHandler = new AttachmentCallbackHandler(attachments);
            Document document = SOAPUtil.toDocument(soapMessage);
            WSSecurityEngine secEngine = new WSSecurityEngine();
            RequestData requestData = new RequestData();
            requestData.setSigVerCrypto(crypto4SignVerification);
            requestData.setDecCrypto(crypto4Decryption);
            requestData.setCallbackHandler(callbacks -> {});
            requestData.setIgnoredBSPRules(Arrays.asList(BSPRule.R5621, BSPRule.R5620, BSPRule.R5426));
            requestData.setAttachmentCallbackHandler((CallbackHandler)attachmentCallbackHandler);
            requestData.setSignatureProvider(Security.getProvider("BC"));
            wsHandlerResults = secEngine.processSecurityHeader(document, requestData);
            for (Attachment responseAttachment : attachmentCallbackHandler.getResponseAttachments()) {
                InputStream inputStream = responseAttachment.getSourceStream();
                MimeHeaders headers = new MimeHeaders();
                headers.addHeader("Content-ID", responseAttachment.getId());
                Iterator parts = soapMessage.getAttachments(headers);
                if (!parts.hasNext()) {
                    headers.removeAllHeaders();
                    headers.addHeader("Content-ID", "<" + responseAttachment.getId() + ">");
                    parts = soapMessage.getAttachments(headers);
                    if (!parts.hasNext()) continue;
                }
                AttachmentPart part = (AttachmentPart)parts.next();
                String contentType = part.getContentType();
                part.setDataHandler(new DataHandler((DataSource)new AS4DataSource(inputStream, contentType)));
            }
            soapMessage.getSOAPPart().setContent((Source)new DOMSource(document));
            soapMessage.saveChanges();
        }
        catch (ParseException | IOException | SOAPException | TransformerException | WSSecurityException e) {
            openedInputStreams.forEach(openedInputStream -> {
                try {
                    openedInputStream.close();
                }
                catch (IOException ioException) {
                    _log.error("Could not close opened input stream.", (Throwable)ioException);
                }
            });
            throw e;
        }
        finally {
            XpWSSecurity.clearThreadCache();
        }
        X509Certificate signCertificate = null;
        String signAlgorithm = null;
        String signKeyInfo = null;
        X509Certificate encCertificate = null;
        String encAlgorithm = null;
        String encKeyInfo = null;
        String keyEncAlgorithm = null;
        if (wsHandlerResults != null) {
            List signResults;
            STRParser.REFERENCE_TYPE keyRefType;
            List encResults = (List)wsHandlerResults.getActionResults().get(4);
            if (encResults != null && !encResults.isEmpty()) {
                WSSecurityEngineResult encActionResult = (WSSecurityEngineResult)encResults.get(0);
                encCertificate = (X509Certificate)encActionResult.get((Object)"x509-certificate");
                List dataRefs = (List)encActionResult.get((Object)"data-ref-uris");
                if (dataRefs != null && !dataRefs.isEmpty()) {
                    WSDataRef dataRef = (WSDataRef)dataRefs.get(0);
                    encAlgorithm = _uriToEncryptionAlgorithm.get(dataRef.getAlgorithm());
                }
                keyEncAlgorithm = this.getKeyEncryptionAlgorithm(encActionResult);
                keyRefType = (STRParser.REFERENCE_TYPE)encActionResult.get((Object)"x509-reference-type");
                if (keyRefType != null) {
                    encKeyInfo = _wsKeyInfoToKeyInfoType.get(keyRefType);
                }
            }
            if ((signResults = (List)wsHandlerResults.getActionResults().get(2)) != null && !signResults.isEmpty()) {
                WSSecurityEngineResult signActionResult = (WSSecurityEngineResult)signResults.get(0);
                signCertificate = (X509Certificate)signActionResult.get((Object)"x509-certificate");
                keyRefType = (STRParser.REFERENCE_TYPE)signActionResult.get((Object)"x509-reference-type");
                signKeyInfo = _wsKeyInfoToKeyInfoType.get(keyRefType);
                signAlgorithm = _uriToSignatureAlgorithm.get(signActionResult.get((Object)"signature-method"));
            }
        }
        SecurityResult securityResult = new SecurityResult(this);
        securityResult.setSoapMessage(soapMessage);
        securityResult.setSignAlgorithm(signAlgorithm);
        securityResult.setSignCertificate(signCertificate);
        securityResult.setSignKeyInfoType(signKeyInfo);
        securityResult.setEncAlgorithm(encAlgorithm);
        securityResult.setEncCertificate(encCertificate);
        securityResult.setEncKeyInfoType(encKeyInfo);
        securityResult.setKeyEncAlgorithm(keyEncAlgorithm);
        return securityResult;
    }

    @Override
    public SOAPMessage encrypt(SOAPMessage soapMessage, Crypto crypto4Encryption, X509Certificate certificate, String algorithm, String keyInfoType, String keyEncryptionAlgorithm) throws WSSecurityException {
        try {
            Document doc = SOAPUtil.toDocument(soapMessage, true);
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecEncrypt builder = new WSSecEncrypt(secHeader);
            Integer wsKeyInfo = _keyInfoTypeToWSKeyInfo.get(keyInfoType);
            if (wsKeyInfo == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Key Info type '" + keyInfoType + "' is unknown.");
            }
            builder.setKeyIdentifierType(wsKeyInfo.intValue());
            KeyEncryptionAlgorithm keyEncryptionAlgorithmObject = keyEncAlgoToKeyEncAlgoObject.get(keyEncryptionAlgorithm);
            if (keyEncryptionAlgorithmObject == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Key Encryption Algorithm '" + keyEncryptionAlgorithm + "' is unknown.");
            }
            if (keyEncryptionAlgorithmObject.concatKDFmode != null) {
                boolean generate = "generated".equals(keyEncryptionAlgorithmObject.concatKDFmode);
                String encryptionMethod = this.getConcatKDFKeyEncryption(algorithm);
                builder.setConcatKDFParameters(new ConcatKDFParameters(encryptionMethod, keyEncryptionAlgorithmObject.digest, generate));
            } else {
                builder.setKeyEncAlgo(keyEncryptionAlgorithmObject.keyEncAlgo);
                builder.setMGFAlgorithm(keyEncryptionAlgorithmObject.mgfAlgorithm);
                builder.setDigestAlgorithm(keyEncryptionAlgorithmObject.digest);
            }
            builder.setUserInfo(crypto4Encryption.getX509Identifier(certificate));
            String algorithmUri = _encryptionAlgorithmToURI.get(algorithm);
            if (algorithmUri == null) {
                _log.error("unknown encryption algorithm {}", (Object)algorithm);
                throw new WSSPolicyException("unknown encryption algorithm");
            }
            builder.setSymmetricEncAlgorithm(algorithmUri);
            builder.setEncryptSymmKey(true);
            ArrayList<WSEncryptionPart> wsEncryptionParts = new ArrayList<WSEncryptionPart>();
            AttachmentCallbackHandler attachmentCallbackHandler = null;
            Iterator iterator = soapMessage.getAttachments();
            if (iterator.hasNext()) {
                WSEncryptionPart attachmentEncPart = new WSEncryptionPart("cid:Attachments", "Content");
                wsEncryptionParts.add(attachmentEncPart);
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                while (iterator.hasNext()) {
                    AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                    Attachment attachment = new Attachment();
                    ContentType contentType = new ContentType(attachmentPart.getContentType());
                    attachment.setMimeType(contentType.getBaseType());
                    attachment.setId(attachmentPart.getContentId());
                    attachment.setSourceStream(attachmentPart.getDataHandler().getInputStream());
                    attachments.add(attachment);
                }
                attachmentCallbackHandler = new AttachmentCallbackHandler(attachments);
                builder.setAttachmentCallbackHandler((CallbackHandler)attachmentCallbackHandler);
            }
            builder.getParts().addAll(wsEncryptionParts);
            KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)builder.getSymmetricEncAlgorithm());
            SecretKey symmetricKey = keyGen.generateKey();
            Document encryptedDoc = builder.build(crypto4Encryption, symmetricKey);
            if (attachmentCallbackHandler != null) {
                for (Attachment encryptedAttachment : attachmentCallbackHandler.getResponseAttachments()) {
                    InputStream stream = encryptedAttachment.getSourceStream();
                    MimeHeaders headers = new MimeHeaders();
                    headers.addHeader("Content-ID", encryptedAttachment.getId());
                    Iterator parts = soapMessage.getAttachments(headers);
                    if (parts == null || !parts.hasNext()) {
                        _log.error("Can't find attachment with id '" + encryptedAttachment.getId() + "' to set encrypted content.");
                        break;
                    }
                    AttachmentPart part = (AttachmentPart)parts.next();
                    String contentType = encryptedAttachment.getMimeType();
                    part.setDataHandler(new DataHandler((DataSource)new AS4DataSource(stream, contentType)));
                }
            }
            soapMessage.getSOAPPart().setContent((Source)new DOMSource(encryptedDoc));
            soapMessage.saveChanges();
            return soapMessage;
        }
        catch (WSSecurityException wsse) {
            _log.error("could not encrypt message", (Throwable)wsse);
            throw wsse;
        }
        catch (Exception ex) {
            _log.error(ex.getMessage());
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOAPMessage sign(SOAPMessage soapMessage, Crypto crypto4Signing, SignCertInfo signCertInfo, String algorithm, String keyInfoType) throws TransformerException, SOAPException, IOException, WSSecurityException, ParseException {
        Document signedDoc;
        String tempKeyInfoType;
        Integer wsKeyInfo;
        String digestAlgo = _digestAlgorithmToURI.get(algorithm);
        String signatureAlgorithm = _signatureAlgorithmToURI.get(algorithm);
        if (digestAlgo == null || signatureAlgorithm == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Algorithm '" + algorithm + "' is not supported.");
        }
        Document plainDocument = SOAPUtil.toDocument(soapMessage, true);
        WSSecHeader secHeader = new WSSecHeader(plainDocument);
        secHeader.insertSecurityHeader();
        X509Certificate certificate = signCertInfo.getCertificateChain()[0];
        WSSecSignature wsSecSignature = new WSSecSignature(secHeader);
        wsSecSignature.setAddInclusivePrefixes(true);
        wsSecSignature.setUserInfo(crypto4Signing.getX509Identifier(certificate), null);
        wsSecSignature.setDigestAlgo(digestAlgo);
        wsSecSignature.setSignatureAlgorithm(signatureAlgorithm);
        if (certificate.getPublicKey() instanceof ECPublicKey && SignatureEncryptionAlgorithm.ECDSA.equals((Object)SignatureEncryptionAlgorithm.ofOptionValue(algorithm))) {
            wsSecSignature.setSignatureProvider(Security.getProvider("BC"));
        }
        if ((wsKeyInfo = signingKeyInfoTypeToWSKeyInfo.get(tempKeyInfoType = keyInfoType == null ? "IssuerAndSerialNumber" : keyInfoType)) == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Key Info type '" + tempKeyInfoType + "' is unknown.");
        }
        wsSecSignature.setKeyIdentifierType(wsKeyInfo.intValue());
        if ("BinarySecurityTokenPkiPath".equals(tempKeyInfoType)) {
            wsSecSignature.setUseSingleCertificate(false);
        }
        ArrayList<WSEncryptionPart> wsEncryptionParts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart bodyEncryptionPart = new WSEncryptionPart("Body", "http://www.w3.org/2003/05/soap-envelope", "Content");
        wsEncryptionParts.add(bodyEncryptionPart);
        WSEncryptionPart messagingEncryptionPart = new WSEncryptionPart("Messaging", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "Element");
        wsEncryptionParts.add(messagingEncryptionPart);
        Iterator iterator = soapMessage.getAttachments();
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        try {
            if (iterator.hasNext()) {
                WSEncryptionPart attachmentEncPart = new WSEncryptionPart("cid:Attachments", "Content");
                wsEncryptionParts.add(attachmentEncPart);
                while (iterator.hasNext()) {
                    AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                    Attachment attachment = new Attachment();
                    ContentType contentType = new ContentType(attachmentPart.getContentType());
                    attachment.setMimeType(contentType.getBaseType());
                    attachment.setId(attachmentPart.getContentId());
                    InputStream attachmentStream = attachmentPart.getDataHandler().getInputStream();
                    attachment.setSourceStream(attachmentStream);
                    attachments.add(attachment);
                }
                AttachmentCallbackHandler attachmentCallbackHandler = new AttachmentCallbackHandler(attachments);
                wsSecSignature.setAttachmentCallbackHandler((CallbackHandler)attachmentCallbackHandler);
            }
            wsSecSignature.getParts().addAll(wsEncryptionParts);
            signedDoc = wsSecSignature.build(crypto4Signing);
        }
        finally {
            this.closeAllAttachmentStreams(attachments);
        }
        soapMessage.getSOAPPart().setContent((Source)new DOMSource(signedDoc));
        soapMessage.saveChanges();
        return soapMessage;
    }

    private void closeAllAttachmentStreams(List<Attachment> attachments) {
        for (Attachment attachment : attachments) {
            try {
                attachment.getSourceStream().close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String resolveAlgorithmUri(String uri) {
        String result = _uriToSignatureAlgorithm.get(uri);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = _uriToEncryptionAlgorithm.get(uri);
        }
        return result;
    }

    public static String resolveAlgorithmVersion(String baseNamespace) {
        if (baseNamespace.startsWith(ENC_NS10) || baseNamespace.startsWith(DSIG_NS10)) {
            return "1.0";
        }
        if (baseNamespace.startsWith(ENC_NS11) || baseNamespace.startsWith(DSIG_NS11)) {
            return "1.1";
        }
        return null;
    }

    private String getConcatKDFKeyEncryption(String algorithm) {
        switch (algorithm) {
            case "aes128-cbc": 
            case "aes128-gcm": {
                return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            }
            case "aes192-cbc": 
            case "aes192-gcm": {
                return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            }
            case "aes256-cbc": 
            case "aes256-gcm": {
                return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            }
        }
        _log.warn("Unexpected algorithm {}. Will use KeyEntryptionAlgorithm {}", (Object)algorithm, (Object)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
        return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    }

    private String getKeyEncryptionAlgorithm(WSSecurityEngineResult encActionResult) {
        String keyEncAlgorithm = (String)encActionResult.get((Object)"encrypted-key-transport-method");
        if (!this.isWrappedKeyAlgorithm(keyEncAlgorithm)) {
            String mgfAlgorithm = null;
            String digestAlgorithm = null;
            Element encryptedKeyElement = (Element)encActionResult.get((Object)"token-element");
            Node encryptionMethodElement = this.findChildNode(encryptedKeyElement, "EncryptionMethod");
            if (encryptionMethodElement != null) {
                Node algorithmAttribute;
                Node digestElement;
                Node algorithmAttribute2;
                Node mgfElement = this.findChildNode(encryptionMethodElement, "MGF");
                if (mgfElement != null && (algorithmAttribute2 = this.findAttribute(mgfElement, "Algorithm")) != null) {
                    mgfAlgorithm = algorithmAttribute2.getNodeValue();
                }
                if ((digestElement = this.findChildNode(encryptionMethodElement, "DigestMethod")) != null && (algorithmAttribute = this.findAttribute(digestElement, "Algorithm")) != null) {
                    digestAlgorithm = algorithmAttribute.getNodeValue();
                }
            }
            if ((keyEncAlgorithm = keyEncAlgoObjectToKeyEncAlgo.get(new KeyEncryptionAlgorithm(keyEncAlgorithm, mgfAlgorithm, digestAlgorithm))) == null) {
                _log.warn("Could not determine used Key Encryption Algorithm: (keyEncAlgo: '{}', mgfAlgorithm: '{}, digestAlgorithm: '{}').", (Object)keyEncAlgorithm, (Object)mgfAlgorithm, digestAlgorithm);
            }
        }
        return keyEncAlgorithm;
    }

    private boolean isWrappedKeyAlgorithm(String algorithm) {
        return "http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(algorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(algorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(algorithm);
    }

    static {
        _digestAlgorithmToURI.put("rsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1");
        _digestAlgorithmToURI.put("rsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        _digestAlgorithmToURI.put("rsa-sha512", "http://www.w3.org/2001/04/xmlenc#sha512");
        _digestAlgorithmToURI.put("ecdsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1");
        _digestAlgorithmToURI.put("ecdsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        _digestAlgorithmToURI.put("ecdsa-sha512", "http://www.w3.org/2001/04/xmlenc#sha512");
        _signatureAlgorithmToURI = new HashMap<String, String>();
        _signatureAlgorithmToURI.put("rsa-sha1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        _signatureAlgorithmToURI.put("rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        _signatureAlgorithmToURI.put("rsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        _signatureAlgorithmToURI.put("ecdsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        _signatureAlgorithmToURI.put("ecdsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
        _signatureAlgorithmToURI.put("ecdsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
        _keyInfoTypeToWSKeyInfo = new HashMap<String, Integer>();
        _keyInfoTypeToWSKeyInfo.put("IssuerAndSerialNumber", 2);
        _keyInfoTypeToWSKeyInfo.put("BinarySecurityToken", 1);
        _keyInfoTypeToWSKeyInfo.put("SubjectKeyIdentifier", 4);
        signingKeyInfoTypeToWSKeyInfo = new HashMap<String, Integer>();
        signingKeyInfoTypeToWSKeyInfo.put("IssuerAndSerialNumber", 2);
        signingKeyInfoTypeToWSKeyInfo.put("BinarySecurityToken", 1);
        signingKeyInfoTypeToWSKeyInfo.put("BinarySecurityTokenPkiPath", 1);
        signingKeyInfoTypeToWSKeyInfo.put("SubjectKeyIdentifier", 4);
        _uriToDigestAlgorithm = new HashMap<String, String>();
        _uriToDigestAlgorithm.put("http://www.w3.org/2000/09/xmldsig#sha1", "rsa-sha1");
        _uriToDigestAlgorithm.put("http://www.w3.org/2001/04/xmlenc#sha256", "rsa-sha256");
        _uriToDigestAlgorithm.put("http://www.w3.org/2001/04/xmlenc#sha512", "rsa-sha512");
        _uriToDigestAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "ecdsa-sha1");
        _uriToDigestAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "ecdsa-sha256");
        _uriToDigestAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "ecdsa-sha512");
        _uriToSignatureAlgorithm = new HashMap<String, String>();
        _uriToSignatureAlgorithm.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "rsa-sha1");
        _uriToSignatureAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "rsa-sha256");
        _uriToSignatureAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "rsa-sha512");
        _uriToSignatureAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "ecdsa-sha1");
        _uriToSignatureAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "ecdsa-sha256");
        _uriToSignatureAlgorithm.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "ecdsa-sha512");
        _wsKeyInfoToKeyInfoType = new HashMap<STRParser.REFERENCE_TYPE, String>();
        _wsKeyInfoToKeyInfoType.put(STRParser.REFERENCE_TYPE.ISSUER_SERIAL, "IssuerAndSerialNumber");
        _wsKeyInfoToKeyInfoType.put(STRParser.REFERENCE_TYPE.DIRECT_REF, "BinarySecurityToken");
        _wsKeyInfoToKeyInfoType.put(STRParser.REFERENCE_TYPE.KEY_IDENTIFIER, "SubjectKeyIdentifier");
        keyEncAlgoObjectToKeyEncAlgo = new HashMap<KeyEncryptionAlgorithm, String>();
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", null, null), "rsa-oaep");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", null, "http://www.w3.org/2000/09/xmldsig#sha1"), "rsa-oaep_sha1");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", null, "http://www.w3.org/2001/04/xmlenc#sha256"), "rsa-oaep_sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", null, "http://www.w3.org/2001/04/xmldsig-more#sha384"), "rsa-oaep_sha384");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", null, "http://www.w3.org/2001/04/xmlenc#sha512"), "rsa-oaep_sha512");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha1", null), "rsa-oaep-11_mgf-sha1");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha224", null), "rsa-oaep-11_mgf-sha224");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha256", null), "rsa-oaep-11_mgf-sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha384", null), "rsa-oaep-11_mgf-sha384");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha512", null), "rsa-oaep-11_mgf-sha512");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "http://www.w3.org/2000/09/xmldsig#sha1"), "rsa-oaep-11_sha1_mgf-sha1");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha224", "http://www.w3.org/2000/09/xmldsig#sha1"), "rsa-oaep-11_sha1_mgf-sha224");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha256", "http://www.w3.org/2000/09/xmldsig#sha1"), "rsa-oaep-11_sha1_mgf-sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha384", "http://www.w3.org/2000/09/xmldsig#sha1"), "rsa-oaep-11_sha1_mgf-sha384");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha512", "http://www.w3.org/2000/09/xmldsig#sha1"), "rsa-oaep-11_sha1_mgf-sha512");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "http://www.w3.org/2001/04/xmlenc#sha256"), "rsa-oaep-11_sha256_mgf-sha1");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha224", "http://www.w3.org/2001/04/xmlenc#sha256"), "rsa-oaep-11_sha256_mgf-sha224");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha256", "http://www.w3.org/2001/04/xmlenc#sha256"), "rsa-oaep-11_sha256_mgf-sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha384", "http://www.w3.org/2001/04/xmlenc#sha256"), "rsa-oaep-11_sha256_mgf-sha384");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha512", "http://www.w3.org/2001/04/xmlenc#sha256"), "rsa-oaep-11_sha256_mgf-sha512");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "http://www.w3.org/2001/04/xmldsig-more#sha384"), "rsa-oaep-11_sha384_mgf-sha1");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha224", "http://www.w3.org/2001/04/xmldsig-more#sha384"), "rsa-oaep-11_sha384_mgf-sha224");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha256", "http://www.w3.org/2001/04/xmldsig-more#sha384"), "rsa-oaep-11_sha384_mgf-sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha384", "http://www.w3.org/2001/04/xmldsig-more#sha384"), "rsa-oaep-11_sha384_mgf-sha384");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha512", "http://www.w3.org/2001/04/xmldsig-more#sha384"), "rsa-oaep-11_sha384_mgf-sha512");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "http://www.w3.org/2001/04/xmlenc#sha512"), "rsa-oaep-11_sha512_mgf-sha1");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha224", "http://www.w3.org/2001/04/xmlenc#sha512"), "rsa-oaep-11_sha512_mgf-sha224");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha256", "http://www.w3.org/2001/04/xmlenc#sha512"), "rsa-oaep-11_sha512_mgf-sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha384", "http://www.w3.org/2001/04/xmlenc#sha512"), "rsa-oaep-11_sha512_mgf-sha384");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2009/xmlenc11#mgf1sha512", "http://www.w3.org/2001/04/xmlenc#sha512"), "rsa-oaep-11_sha512_mgf-sha512");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("empty", "http://www.w3.org/2001/04/xmlenc#sha256"), "ECDH-ES-ConcatKDF-empty-sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("empty", "http://www.w3.org/2001/04/xmlenc#sha512"), "ECDH-ES-ConcatKDF-empty-sha512");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("generated", "http://www.w3.org/2001/04/xmlenc#sha256"), "ECDH-ES-ConcatKDF-generated-sha256");
        keyEncAlgoObjectToKeyEncAlgo.put(new KeyEncryptionAlgorithm("generated", "http://www.w3.org/2001/04/xmlenc#sha512"), "ECDH-ES-ConcatKDF-generated-sha512");
        keyEncAlgoToKeyEncAlgoObject = new HashMap<String, KeyEncryptionAlgorithm>();
        keyEncAlgoObjectToKeyEncAlgo.forEach((key, value) -> keyEncAlgoToKeyEncAlgoObject.put((String)value, (KeyEncryptionAlgorithm)key));
        _encryptionAlgorithmToURI = new HashMap<String, String>();
        _encryptionAlgorithmToURI.put("tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        _encryptionAlgorithmToURI.put("aes128-cbc", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        _encryptionAlgorithmToURI.put("aes128-gcm", "http://www.w3.org/2009/xmlenc11#aes128-gcm");
        _encryptionAlgorithmToURI.put("aes192-cbc", "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        _encryptionAlgorithmToURI.put("aes192-gcm", "http://www.w3.org/2009/xmlenc11#aes192-gcm");
        _encryptionAlgorithmToURI.put("aes256-cbc", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        _encryptionAlgorithmToURI.put("aes256-gcm", "http://www.w3.org/2009/xmlenc11#aes256-gcm");
        _uriToEncryptionAlgorithm = new HashMap<String, String>();
        _uriToEncryptionAlgorithm.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "tripledes-cbc");
        _uriToEncryptionAlgorithm.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "aes128-cbc");
        _uriToEncryptionAlgorithm.put("http://www.w3.org/2009/xmlenc11#aes128-gcm", "aes128-gcm");
        _uriToEncryptionAlgorithm.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "aes256-cbc");
        _uriToEncryptionAlgorithm.put("http://www.w3.org/2009/xmlenc11#aes256-gcm", "aes256-gcm");
        CRYPTO_THREAD_LOCAL = new ThreadLocal();
    }

    private static class CryptoWrapper
    extends CryptoBase {
        private CryptoWrapper() {
        }

        public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
            return CRYPTO_THREAD_LOCAL.get().getX509Certificates(cryptoType);
        }

        public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
            return CRYPTO_THREAD_LOCAL.get().getX509Identifier(cert);
        }

        public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
            return CRYPTO_THREAD_LOCAL.get().getPrivateKey(certificate, callbackHandler);
        }

        public PrivateKey getPrivateKey(PublicKey publicKey, CallbackHandler callbackHandler) throws WSSecurityException {
            return CRYPTO_THREAD_LOCAL.get().getPrivateKey(publicKey, callbackHandler);
        }

        public PrivateKey getPrivateKey(String identifier, String password) throws WSSecurityException {
            return CRYPTO_THREAD_LOCAL.get().getPrivateKey(identifier, password);
        }

        public void verifyTrust(X509Certificate[] certs, boolean enableRevocation, Collection<Pattern> subjectCertConstraints, Collection<Pattern> issuerCertConstraints) throws WSSecurityException {
            CRYPTO_THREAD_LOCAL.get().verifyTrust(certs, enableRevocation, subjectCertConstraints, issuerCertConstraints);
        }

        public void verifyTrust(PublicKey publicKey) throws WSSecurityException {
            CRYPTO_THREAD_LOCAL.get().verifyTrust(publicKey);
        }
    }

    public class SecurityResult {
        private X509Certificate _signCertificate;
        private String _signAlgorithm;
        private String _signKeyInfoType;
        private X509Certificate _encCertificate;
        private String _encAlgorithm;
        private String _encKeyInfoType;
        private String keyEncAlgorithm;
        private SOAPMessage _soapMessage;

        public SecurityResult(XpWSSecurity this$0) {
        }

        public String getSignAlgorithm() {
            return this._signAlgorithm;
        }

        protected void setSignAlgorithm(String signAlgorithm) {
            this._signAlgorithm = signAlgorithm;
        }

        public X509Certificate getSignCertificate() {
            return this._signCertificate;
        }

        protected void setSignCertificate(X509Certificate signCertificate) {
            this._signCertificate = signCertificate;
        }

        public X509Certificate getEncCertificate() {
            return this._encCertificate;
        }

        protected void setEncCertificate(X509Certificate encCertificate) {
            this._encCertificate = encCertificate;
        }

        public String getEncAlgorithm() {
            return this._encAlgorithm;
        }

        protected void setEncAlgorithm(String encAlgorithm) {
            this._encAlgorithm = encAlgorithm;
        }

        public String getEncKeyInfoType() {
            return this._encKeyInfoType;
        }

        protected void setEncKeyInfoType(String encKeyInfoType) {
            this._encKeyInfoType = encKeyInfoType;
        }

        public String getKeyEncAlgorithm() {
            return this.keyEncAlgorithm;
        }

        public SecurityResult setKeyEncAlgorithm(String keyEncAlgorithm) {
            this.keyEncAlgorithm = keyEncAlgorithm;
            return this;
        }

        public String getSignKeyInfoType() {
            return this._signKeyInfoType;
        }

        protected void setSignKeyInfoType(String signKeyInfoType) {
            this._signKeyInfoType = signKeyInfoType;
        }

        public SOAPMessage getSoapMessage() {
            return this._soapMessage;
        }

        protected void setSoapMessage(SOAPMessage soapMessage) {
            this._soapMessage = soapMessage;
        }
    }

    static class KeyEncryptionAlgorithm {
        private final String keyEncAlgo;
        private final String mgfAlgorithm;
        private final String digest;
        private final String concatKDFmode;

        public KeyEncryptionAlgorithm(String keyEncAlgo, String mgfAlgorithm, String digest) {
            this.keyEncAlgo = keyEncAlgo;
            this.mgfAlgorithm = mgfAlgorithm;
            this.digest = digest;
            this.concatKDFmode = null;
        }

        public KeyEncryptionAlgorithm(String concatKDFmode, String digest) {
            this.keyEncAlgo = "http://www.w3.org/2009/xmlenc11#ECDH-ES";
            this.mgfAlgorithm = null;
            this.concatKDFmode = concatKDFmode;
            this.digest = digest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyEncryptionAlgorithm)) {
                return false;
            }
            KeyEncryptionAlgorithm that = (KeyEncryptionAlgorithm)o;
            return this.keyEncAlgo.equals(that.keyEncAlgo) && Objects.equals(this.mgfAlgorithm, that.mgfAlgorithm) && Objects.equals(this.digest, that.digest) && Objects.equals(this.concatKDFmode, that.concatKDFmode);
        }

        public int hashCode() {
            return Objects.hash(this.keyEncAlgo, this.mgfAlgorithm, this.digest, this.concatKDFmode);
        }
    }
}

