/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.messenger.IMaintenanceChangeListener;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.KnownServerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.tables.KnownServerCertificateDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.RevocationVerifier;
import de.pontonconsulting.xmlpipe.security.RevocationVerifierFactory;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationListener;

public class ServerCertificateRevocationService
implements ApplicationListener<ReloadConfiguration>,
IMaintenanceChangeListener {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + ServerCertificateRevocationService.class.getName()));
    private final RevocationVerifierFactory revocationVerifierFactory;
    private final MessengerConfig messengerConfig;
    private final CertificateUtility certificateUtility;
    private final ReferenceDateTask referenceDateTask;
    private final KnownServerCertificateDAO knownServerCertificateDAO;

    public ServerCertificateRevocationService(RevocationVerifierFactory revocationVerifierFactory, MessengerConfig messengerConfig, CertificateUtility certificateUtility, ReferenceDateTask referenceDateTask, KnownServerCertificateDAO knownServerCertificateDAO) {
        this.revocationVerifierFactory = revocationVerifierFactory;
        this.messengerConfig = messengerConfig;
        this.certificateUtility = certificateUtility;
        this.referenceDateTask = referenceDateTask;
        this.knownServerCertificateDAO = knownServerCertificateDAO;
    }

    public void onApplicationEvent(ReloadConfiguration event) {
        if (event.isMessengerConfigChanged()) {
            LOG.info("Server certificate check triggered by messenger config change");
            this.validateCertificates();
        }
    }

    @Override
    public void onMaintenanceChange(MaintenanceManager maintenanceManager) {
        if (maintenanceManager.isStarted()) {
            LOG.info("Server certificate check triggered by maintenance switch");
            this.validateCertificates();
        }
    }

    public synchronized void validateCertificates() {
        try {
            if (!this.messengerConfig.isSSLCertificateCheck()) {
                return;
            }
        }
        catch (JAXBException e) {
            LOG.warn("Could not read server certificate check flag. Skipping revocation checks.");
            return;
        }
        RevocationVerifier revocationVerifier = this.revocationVerifierFactory.createRevocationVerifier();
        for (KnownServerCertificate knownServerCertificate : this.knownServerCertificateDAO.loadAllKnownServerCertificates()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.validateCertificate(knownServerCertificate, revocationVerifier);
        }
    }

    private void validateCertificate(KnownServerCertificate knownServerCertificate, RevocationVerifier revocationVerifier) {
        X509Certificate certificate;
        String certificateId = knownServerCertificate.getId();
        try {
            certificate = this.certificateUtility.getX509Certificate(knownServerCertificate.getCertificate());
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            LOG.error("Could not read known base64 certificate {} for revocation check: {}", (Object)certificateId, (Object)e);
            return;
        }
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        knownServerCertificate.setLastCheck(now);
        try {
            revocationVerifier.verifyCertificateCRLs(certificate);
            knownServerCertificate.setStatus(1);
            knownServerCertificate.setCrlReason(null);
        }
        catch (IOException e) {
            LOG.warn("Could not verify certificate {} for revocation check: {}", (Object)certificateId, (Object)e);
            if (now.minusDays(3L).isAfter(knownServerCertificate.getLastSuccessfulCheck())) {
                LOG.warn("Server certificate {} was temporarily revoked because communication with CRL server did not work since {}.", (Object)certificateId, (Object)knownServerCertificate.getLastSuccessfulCheck());
                knownServerCertificate.setStatus(2);
                knownServerCertificate.setCrlReason(null);
            }
        }
        catch (CertificateRevokedException e) {
            LOG.warn("Server certificate {} was revoked with reason {}", (Object)certificateId, (Object)e.getRevocationReason());
            knownServerCertificate.setStatus(99);
            knownServerCertificate.setCrlReason(e.getRevocationReason());
        }
        this.knownServerCertificateDAO.save(knownServerCertificate);
    }
}

