/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEValidationException;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.jcajce.JcaAlgorithmParametersConverter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS8EncryptedPrivateKeyInfoBuilder;

public class CryptoUtil {
    private static final Log LOG = LogFactory.getFactory().getInstance("Messenger.CryptoUtil");
    private static final String SHA_512 = "SHA512";
    private static final String SHA_384 = "SHA384";
    private static final String SHA_256 = "SHA256";
    private static final String SHA_224 = "SHA224";
    private static final String SHA_1 = "SHA1";
    private static final String MD_5 = "MD5";
    private static final String RSA_SUFFIX = "withRSA";
    public static final String SIGN_SHA512WITHRSA = "SHA512withRSA";
    public static final String SIGN_SHA384WITHRSA = "SHA384withRSA";
    public static final String SIGN_SHA256WITHRSA = "SHA256withRSA";
    public static final String SIGN_SHA224WITHRSA = "SHA224withRSA";
    public static final String SIGN_SHA1WITHRSA = "SHA1withRSA";
    public static final String SIGN_MD5WITHRSA = "MD5withRSA";
    private static final String ECDSA_SUFFIX = "withECDSA";
    public static final String SIGN_SHA512WITHECDSA = "SHA512withECDSA";
    public static final String SIGN_SHA384WITHECDSA = "SHA384withECDSA";
    public static final String SIGN_SHA256WITHECDSA = "SHA256withECDSA";
    private static final String RSASSA_PSS_SUFFIX = "withRSAandMGF1";
    public static final String SIGN_SHA512WITHRSA_ANDMGF1 = "SHA512withRSAandMGF1";
    public static final String SIGN_SHA384WITHRSA_ANDMGF1 = "SHA384withRSAandMGF1";
    public static final String SIGN_SHA256WITHRSA_ANDMGF1 = "SHA256withRSAandMGF1";
    public static final String SIGN_SHA224WITHRSA_ANDMGF1 = "SHA224withRSAandMGF1";
    public static final String SIGN_SHA1WITHRSA_ANDMGF1 = "SHA1withRSAandMGF1";
    public static final String ENC_AES128_CBC = "AES128_CBC";
    public static final String ENC_AES192_CBC = "AES192_CBC";
    public static final String ENC_AES256_CBC = "AES256_CBC";
    public static final String ENC_DES_EDE3_CBC = "DES_EDE3_CBC";
    public static final String ENC_AES128_GCM = "AES128_GCM";
    public static final String ENC_AES192_GCM = "AES192_GCM";
    public static final String ENC_AES256_GCM = "AES256_GCM";
    public static final String OAEP_SUFFIX = "/OAEP";
    public static final String ECDH_SUFFIX = "/ECDH";
    public static final String SHA1 = "_SHA1";
    public static final String SHA224 = "_SHA224";
    public static final String SHA256 = "_SHA256";
    public static final String SHA512 = "_SHA512";
    public static final String ENC_DES_EDE3_CBC_OAEP = "DES_EDE3_CBC/OAEP_SHA1";
    public static final String ENC_AES128_CBC_OAEP = "AES128_CBC/OAEP_SHA1";
    public static final String ENC_AES192_CBC_OAEP = "AES192_CBC/OAEP_SHA1";
    public static final String ENC_AES256_CBC_OAEP = "AES256_CBC/OAEP_SHA1";
    public static final String ENC_AES128_CBC_OAEP_SHA256 = "AES128_CBC/OAEP_SHA256";
    public static final String ENC_AES192_CBC_OAEP_SHA256 = "AES192_CBC/OAEP_SHA256";
    public static final String ENC_AES256_CBC_OAEP_SHA256 = "AES256_CBC/OAEP_SHA256";
    public static final String ENC_AES128_CBC_OAEP_SHA512 = "AES128_CBC/OAEP_SHA512";
    public static final String ENC_AES192_CBC_OAEP_SHA512 = "AES192_CBC/OAEP_SHA512";
    public static final String ENC_AES256_CBC_OAEP_SHA512 = "AES256_CBC/OAEP_SHA512";
    public static final String ENC_AES128_GCM_OAEP_SHA256 = "AES128_GCM/OAEP_SHA256";
    public static final String ENC_AES192_GCM_OAEP_SHA256 = "AES192_GCM/OAEP_SHA256";
    public static final String ENC_AES256_GCM_OAEP_SHA256 = "AES256_GCM/OAEP_SHA256";
    public static final String ENC_AES128_GCM_OAEP_SHA512 = "AES128_GCM/OAEP_SHA512";
    public static final String ENC_AES192_GCM_OAEP_SHA512 = "AES192_GCM/OAEP_SHA512";
    public static final String ENC_AES256_GCM_OAEP_SHA512 = "AES256_GCM/OAEP_SHA512";
    public static final String ENC_AES128_GCM_ECDH = "AES128_GCM/ECDH_SHA224";
    public static final String ENC_AES192_GCM_ECDH = "AES192_GCM/ECDH_SHA224";
    public static final String ENC_AES256_GCM_ECDH = "AES256_GCM/ECDH_SHA224";
    public static final String ENC_AES128_GCM_ECDH_SHA256 = "AES128_GCM/ECDH_SHA256";
    public static final String ENC_AES192_GCM_ECDH_SHA256 = "AES192_GCM/ECDH_SHA256";
    public static final String ENC_AES256_GCM_ECDH_SHA256 = "AES256_GCM/ECDH_SHA256";
    public static final String ENC_AES128_GCM_ECDH_SHA512 = "AES128_GCM/ECDH_SHA512";
    public static final String ENC_AES192_GCM_ECDH_SHA512 = "AES192_GCM/ECDH_SHA512";
    public static final String ENC_AES256_GCM_ECDH_SHA512 = "AES256_GCM/ECDH_SHA512";
    public static final ASN1ObjectIdentifier ID_AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC;
    public static final ASN1ObjectIdentifier ID_AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC;
    public static final ASN1ObjectIdentifier ID_AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC;
    public static final ASN1ObjectIdentifier ID_AES128_GCM = NISTObjectIdentifiers.id_aes128_GCM;
    public static final ASN1ObjectIdentifier ID_AES192_GCM = NISTObjectIdentifiers.id_aes192_GCM;
    public static final ASN1ObjectIdentifier ID_AES256_GCM = NISTObjectIdentifiers.id_aes256_GCM;
    public static final ASN1ObjectIdentifier DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC;
    public static final ASN1ObjectIdentifier ID_DES_EDE3_WRAP = CMSAlgorithm.DES_EDE3_WRAP;
    public static final ASN1ObjectIdentifier ID_AES_128_WRAP = CMSAlgorithm.AES128_WRAP;
    public static final ASN1ObjectIdentifier ID_AES_192_WRAP = CMSAlgorithm.AES192_WRAP;
    public static final ASN1ObjectIdentifier ID_AES_256_WRAP = CMSAlgorithm.AES256_WRAP;
    private static final ASN1ObjectIdentifier ID_RSAES_OAEP = PKCSObjectIdentifiers.id_RSAES_OAEP;
    private static final ASN1ObjectIdentifier ID_RSASSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS;
    private static final ASN1ObjectIdentifier ID_RSA = PKCSObjectIdentifiers.rsaEncryption;
    public static final ASN1ObjectIdentifier SHA1_WITH_RSA = PKCSObjectIdentifiers.sha1WithRSAEncryption;
    public static final ASN1ObjectIdentifier SHA224_WITH_RSA = PKCSObjectIdentifiers.sha224WithRSAEncryption;
    public static final ASN1ObjectIdentifier SHA256_WITH_RSA = PKCSObjectIdentifiers.sha256WithRSAEncryption;
    public static final ASN1ObjectIdentifier SHA384_WITH_RSA = PKCSObjectIdentifiers.sha384WithRSAEncryption;
    public static final ASN1ObjectIdentifier SHA512_WITH_RSA = PKCSObjectIdentifiers.sha512WithRSAEncryption;
    public static final ASN1ObjectIdentifier SHA256_WITH_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA256;
    public static final ASN1ObjectIdentifier SHA384_WITH_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA384;
    public static final ASN1ObjectIdentifier SHA512_WITH_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA512;
    public static final ASN1ObjectIdentifier MD5_WITH_RSA = PKCSObjectIdentifiers.md5WithRSAEncryption;
    public static final ASN1ObjectIdentifier SHA224_WITH_ECDH = CMSAlgorithm.ECDH_SHA224KDF;
    public static final ASN1ObjectIdentifier SHA256_WITH_ECDH = CMSAlgorithm.ECDH_SHA256KDF;
    public static final ASN1ObjectIdentifier SHA512_WITH_ECDH = CMSAlgorithm.ECDH_SHA512KDF;
    public static final ASN1ObjectIdentifier SHA1_WITH_ECMQV = CMSAlgorithm.ECMQV_SHA1KDF;
    private static final ASN1ObjectIdentifier DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1;
    private static final ASN1ObjectIdentifier DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224;
    private static final ASN1ObjectIdentifier DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256;
    private static final ASN1ObjectIdentifier DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384;
    private static final ASN1ObjectIdentifier DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512;
    private static final ASN1ObjectIdentifier DIGEST_MD5 = PKCSObjectIdentifiers.md5;
    private static final OAEPParameterSpec OAEP_SHA1 = new OAEPParameterSpec("SHA-1", "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
    private static final OAEPParameterSpec OAEP_SHA256 = new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), PSource.PSpecified.DEFAULT);
    private static final OAEPParameterSpec OAEP_SHA512 = new OAEPParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec("SHA-512"), PSource.PSpecified.DEFAULT);
    private static final Map<String, ASN1ObjectIdentifier> encAlgorithmToIdentifier = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<ASN1ObjectIdentifier, String> identifierToEncAlgorithm = new HashMap<ASN1ObjectIdentifier, String>();
    private static final Map<ASN1ObjectIdentifier, String> signAlgorithms = new HashMap<ASN1ObjectIdentifier, String>();
    private static final Map<ASN1ObjectIdentifier, String> digestAlgorithms = new HashMap<ASN1ObjectIdentifier, String>();
    private static final Map<String, OAEPParameterSpec> identifierToOAEP = new HashMap<String, OAEPParameterSpec>();
    private static final Map<String, ASN1ObjectIdentifier> identifierToECDH = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<ASN1ObjectIdentifier, String> ecdhToIdentifier = new HashMap<ASN1ObjectIdentifier, String>();
    private static final Map<String, ASN1ObjectIdentifier> identifierToKeyWrap = new HashMap<String, ASN1ObjectIdentifier>();

    public static ASN1ObjectIdentifier getASN1ObjectIdentifier(String encAlgorithm) {
        return encAlgorithmToIdentifier.get(encAlgorithm);
    }

    private static String getEncryptionAlgorithm(ASN1ObjectIdentifier identifier) {
        return identifierToEncAlgorithm.get(identifier);
    }

    public static String getUsedEncryptionAlgorithm(AlgorithmIdentifier keyAlgorithmIdentifier, AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier identifier = algorithmIdentifier.getAlgorithm();
        String algorithm = CryptoUtil.getEncryptionAlgorithm(identifier);
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Not supported encryption algorithm: " + identifier.toString());
        }
        ASN1ObjectIdentifier keyAlgorithmIdentifierAlgorithm = keyAlgorithmIdentifier.getAlgorithm();
        if (ID_RSAES_OAEP.equals((ASN1Primitive)keyAlgorithmIdentifierAlgorithm)) {
            RSAESOAEPparams params = RSAESOAEPparams.getInstance((Object)keyAlgorithmIdentifier.getParameters());
            String hash = new DefaultAlgorithmNameFinder().getAlgorithmName(params.getHashAlgorithm());
            return algorithm + "/OAEP_" + hash;
        }
        if (SHA512_WITH_ECDH.equals((ASN1Primitive)keyAlgorithmIdentifierAlgorithm) || SHA256_WITH_ECDH.equals((ASN1Primitive)keyAlgorithmIdentifierAlgorithm) || SHA224_WITH_ECDH.equals((ASN1Primitive)keyAlgorithmIdentifierAlgorithm)) {
            String hash = ecdhToIdentifier.get(keyAlgorithmIdentifierAlgorithm);
            return algorithm + "/" + hash;
        }
        return algorithm;
    }

    private static String getSignatureAlgorithm(ASN1ObjectIdentifier identifier) {
        return signAlgorithms.get(identifier);
    }

    private static String getDigestAlgorithm(ASN1ObjectIdentifier identifier) {
        return digestAlgorithms.get(identifier);
    }

    public static String getSignatureAlgorithm(SignerInformation signerInformation) throws SecurityException {
        ASN1ObjectIdentifier encryptionAlgOID = new ASN1ObjectIdentifier(signerInformation.getEncryptionAlgOID());
        ASN1ObjectIdentifier digestAlgorithmOID = signerInformation.getDigestAlgorithmID().getAlgorithm();
        String signatureAlgorithm = CryptoUtil.getSignatureAlgorithm(encryptionAlgOID);
        if (Objects.nonNull(signatureAlgorithm)) {
            return signatureAlgorithm;
        }
        if (ID_RSA.equals((ASN1Primitive)encryptionAlgOID) || ID_RSASSA_PSS.equals((ASN1Primitive)encryptionAlgOID)) {
            String digestAlgorithm = CryptoUtil.getDigestAlgorithm(digestAlgorithmOID);
            String algorithmSuffix = CryptoUtil.getAlgorithmSuffix(encryptionAlgOID);
            if (Objects.nonNull(digestAlgorithm) && Objects.nonNull(algorithmSuffix)) {
                return digestAlgorithm + algorithmSuffix;
            }
        }
        throw new SecurityException(-1, "Unsupported signature algorithm: encryption algorithm '" + encryptionAlgOID.getId() + "', digest algorithm '" + digestAlgorithmOID.getId() + "'.");
    }

    private static String getAlgorithmSuffix(ASN1ObjectIdentifier encryptionAlgOID) {
        if (ID_RSA.equals((ASN1Primitive)encryptionAlgOID)) {
            return RSA_SUFFIX;
        }
        if (ID_RSASSA_PSS.equals((ASN1Primitive)encryptionAlgOID)) {
            return RSASSA_PSS_SUFFIX;
        }
        return "";
    }

    public static CMSSignedDataStreamGenerator createStreamGenerator(PrivateKey signerPrivateKey, X509Certificate signerCertificate, ASN1ObjectIdentifier signatureAlgorithm) throws OperatorCreationException, CertificateEncodingException {
        String signature = CryptoUtil.getSignatureAlgorithm(signatureAlgorithm);
        return CryptoUtil.createStreamGenerator(signerPrivateKey, signerCertificate, signature);
    }

    private static CMSSignedDataStreamGenerator createStreamGenerator(PrivateKey signerPrivateKey, X509Certificate signerCertificate, String signatureAlgorithm) throws OperatorCreationException, CertificateEncodingException {
        ContentSigner sha1Signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider("BC").build(signerPrivateKey);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, signerCertificate));
        return gen;
    }

    public static CMSEnvelopedGeneratorTupel createGenerator(X509Certificate receiverCertificate) throws CertificateEncodingException {
        CMSEnvelopedDataStreamGenerator edGen = new CMSEnvelopedDataStreamGenerator();
        JceKeyTransRecipientInfoGenerator recipientGenerator = new JceKeyTransRecipientInfoGenerator(receiverCertificate);
        recipientGenerator.setProvider("BC");
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)recipientGenerator);
        return new CMSEnvelopedGeneratorTupel(edGen);
    }

    public static CMSEnvelopedGeneratorTupel createGenerator(X509Certificate receiverCertificate, String asymmetricIdentifier, String symmetricIdentifier) throws GeneralSecurityException, CMSException {
        CMSEnvelopedDataStreamGenerator edGen = new CMSEnvelopedDataStreamGenerator();
        RecipientInfoGenerator recipientGenerator = CryptoUtil.getRecipientInfoGenerator(receiverCertificate, asymmetricIdentifier, symmetricIdentifier);
        edGen.addRecipientInfoGenerator(recipientGenerator);
        return new CMSEnvelopedGeneratorTupel(edGen);
    }

    public static SMIMEEnvelopedGeneratorTupel createSMIMEGenerator(X509Certificate receiverCertificate, String asymmetricIdentifier, String symmetricIdentifier) throws GeneralSecurityException, CMSException {
        SMIMEEnvelopedGenerator edGen = new SMIMEEnvelopedGenerator();
        RecipientInfoGenerator recipientGenerator = CryptoUtil.getRecipientInfoGenerator(receiverCertificate, asymmetricIdentifier, symmetricIdentifier);
        edGen.addRecipientInfoGenerator(recipientGenerator);
        return new SMIMEEnvelopedGeneratorTupel(edGen);
    }

    private static RecipientInfoGenerator getRecipientInfoGenerator(X509Certificate receiverCertificate, String asymmetricIdentifier, String symmetricIdentifier) throws GeneralSecurityException, CMSException {
        JceKeyTransRecipientInfoGenerator recipientGenerator;
        JcaAlgorithmParametersConverter paramsConverter = new JcaAlgorithmParametersConverter();
        PublicKey receiverPublicKey = receiverCertificate.getPublicKey();
        boolean isReceiverECPublicKey = receiverPublicKey instanceof ECPublicKey;
        ASN1ObjectIdentifier keyWrapIdentifier = identifierToKeyWrap.get(symmetricIdentifier);
        if (asymmetricIdentifier != null) {
            switch (asymmetricIdentifier) {
                case "OAEP_SHA1": 
                case "OAEP_SHA256": 
                case "OAEP_SHA512": {
                    try {
                        if (isReceiverECPublicKey) {
                            throw new GeneralSecurityException("Cannot perform RSA with EC key");
                        }
                        OAEPParameterSpec oaepSpec = identifierToOAEP.get(asymmetricIdentifier);
                        recipientGenerator = new JceKeyTransRecipientInfoGenerator(receiverCertificate, paramsConverter.getAlgorithmIdentifier(ID_RSAES_OAEP, (AlgorithmParameterSpec)oaepSpec)).setProvider("BC");
                        break;
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new CMSException("Could not create RecipientInfoGenerator.", (Exception)e);
                    }
                }
                case "ECDH_SHA224": 
                case "ECDH_SHA256": 
                case "ECDH_SHA512": {
                    if (!isReceiverECPublicKey) {
                        throw new GeneralSecurityException("ECDH requires EC key");
                    }
                    ASN1ObjectIdentifier keyExchangeIdentifier = identifierToECDH.get(asymmetricIdentifier);
                    KeyPair keyPair = CryptoUtil.generateOneTimeECKeyPair((ECPublicKey)receiverPublicKey);
                    recipientGenerator = new JceKeyAgreeRecipientInfoGenerator(keyExchangeIdentifier, keyPair.getPrivate(), keyPair.getPublic(), keyWrapIdentifier).setProvider("BC").addRecipient(receiverCertificate);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("Unknown asymmetric identifier: " + asymmetricIdentifier);
                }
            }
        } else if (isReceiverECPublicKey) {
            KeyPair keyPair = CryptoUtil.generateOneTimeECKeyPair((ECPublicKey)receiverPublicKey);
            recipientGenerator = new JceKeyAgreeRecipientInfoGenerator(SHA1_WITH_ECMQV, keyPair.getPrivate(), keyPair.getPublic(), keyWrapIdentifier).setProvider("BC").addRecipient(receiverCertificate);
        } else {
            recipientGenerator = new JceKeyTransRecipientInfoGenerator(receiverCertificate).setProvider("BC");
        }
        return recipientGenerator;
    }

    private static KeyPair generateOneTimeECKeyPair(ECPublicKey receiverPublicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ECParameterSpec ecSpec = ((BCECPublicKey)receiverPublicKey).getParameters();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public static SMIMESignedGenerator createSMIMESignedGenerator(PrivateKey signerPrivateKey, X509Certificate signerCertificate, ASN1ObjectIdentifier signatureAlgorithm, String contentTransferEncoding) throws CertificateEncodingException, OperatorCreationException, IOException, NoSuchAlgorithmException {
        String algorithm = signAlgorithms.get(signatureAlgorithm);
        if (StringUtils.isBlank((CharSequence)algorithm)) {
            throw new NoSuchAlgorithmException("Not supported signing algorithm: " + algorithm + "'.");
        }
        return CryptoUtil.createSMIMESignedGenerator(signerPrivateKey, signerCertificate, algorithm, contentTransferEncoding);
    }

    public static SMIMESignedGenerator createSMIMESignedGenerator(PrivateKey signerPrivateKey, X509Certificate signerCertificate, String signatureAlgorithm, String contentTransferEncoding) throws CertificateEncodingException, OperatorCreationException, IOException {
        SMIMESignedGenerator edGen;
        if (contentTransferEncoding == null) {
            edGen = new SMIMESignedGenerator(SMIMESignedGenerator.RFC3851_MICALGS);
        } else {
            edGen = new SMIMESignedGenerator(contentTransferEncoding, SMIMESignedGenerator.RFC3851_MICALGS);
            edGen.setContentTransferEncoding(contentTransferEncoding);
        }
        SignerInfoGeneratorBuilder sigInfoGenBuilder = new SignerInfoGeneratorBuilder(CryptoUtil.createDigestCalculator());
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(signatureAlgorithm);
        contentSignerBuilder.setProvider("BC");
        ContentSigner contentSigner = contentSignerBuilder.build(signerPrivateKey);
        X509CertificateHolder certHolder = CryptoUtil.createCertificateHolder(signerCertificate);
        SignerInfoGenerator sigInfoGen = sigInfoGenBuilder.build(contentSigner, certHolder);
        edGen.addSignerInfoGenerator(sigInfoGen);
        return edGen;
    }

    private static DigestCalculatorProvider createDigestCalculator() throws OperatorCreationException {
        JcaDigestCalculatorProviderBuilder builder = new JcaDigestCalculatorProviderBuilder();
        builder.setProvider("BC");
        return builder.build();
    }

    public static JceKeyTransEnvelopedRecipient createTransEnvelopedRecipient(PrivateKey privateKeyToBeUsed) {
        JceKeyTransEnvelopedRecipient privateKeyRecipient = new JceKeyTransEnvelopedRecipient(privateKeyToBeUsed);
        privateKeyRecipient.setProvider("BC");
        return privateKeyRecipient;
    }

    public static JceKeyAgreeEnvelopedRecipient createKeyAgreeEnvelopedRecipient(PrivateKey privateKeyToBeUsed) {
        JceKeyAgreeEnvelopedRecipient privateKeyRecipient = new JceKeyAgreeEnvelopedRecipient(privateKeyToBeUsed);
        privateKeyRecipient.setProvider("BC");
        return privateKeyRecipient;
    }

    public static SMIMESignedParser createSMIMESignedParser(MimePart message, File tempFile) throws OperatorCreationException, MessagingException, CMSException, IOException, SMIMEException, SMIMEValidationException {
        SMIMESignedParser result = null;
        if (message.isMimeType("multipart/signed")) {
            result = new SMIMESignedParser(CryptoUtil.createDigestCalculator(), (MimeMultipart)message.getContent(), "binary", tempFile);
        } else if (MimeMultipartUtils.isSMIMESigned((Part)message)) {
            result = new SMIMESignedParser(CryptoUtil.createDigestCalculator(), (Part)message, tempFile);
        } else {
            throw new SMIMEValidationException(26000, "Invalid S/MIME data. ContentType is neither multipart/signed, nor application/pkcs7-mime, nor application/x-pkcs7-mime.");
        }
        return result;
    }

    public static X509CertificateHolder createCertificateHolder(X509Certificate certificate) throws CertificateEncodingException, IOException {
        return new X509CertificateHolder(certificate.getEncoded());
    }

    public static X509Certificate createCertificate(X509CertificateHolder certificateHolder) throws CertificateException {
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
    }

    public static SignerInformationVerifier createVerifier(X509Certificate certificate) throws OperatorCreationException {
        if (certificate == null) {
            return null;
        }
        JcaSignerInfoVerifierBuilder signerInfoBuilder = new JcaSignerInfoVerifierBuilder(CryptoUtil.createDigestCalculator());
        signerInfoBuilder.setProvider("BC");
        signerInfoBuilder.setSignatureAlgorithmFinder((SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder());
        signerInfoBuilder.setSignatureAlgorithmNameGenerator((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator());
        return signerInfoBuilder.build(certificate);
    }

    public static boolean isPrincipalsEqual(X500Name certInfoIssuer, X500Principal issuerX500Principal) throws IOException {
        X500Principal newP = new X500Principal(certInfoIssuer.getEncoded());
        return issuerX500Principal.equals(newP);
    }

    public static PrivateKey findPrivateKey(X509Certificate cert, Collection<PrivateKey> privateKeys) {
        block3: {
            PublicKey publicKey;
            block2: {
                publicKey = cert.getPublicKey();
                if (!(publicKey instanceof RSAPublicKey)) break block2;
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                for (PrivateKey tempPK : privateKeys) {
                    if (!(tempPK instanceof RSAKey)) continue;
                    RSAKey privateKey = (RSAKey)((Object)tempPK);
                    if (!rsaPublicKey.getModulus().equals(privateKey.getModulus())) continue;
                    return tempPK;
                }
                break block3;
            }
            if (!(publicKey instanceof ECPublicKey)) break block3;
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            for (PrivateKey tempPK : privateKeys) {
                ECPrivateKey privateKey;
                if (!(tempPK instanceof ECPrivateKey) || !CryptoUtil.checkPublicPrivateKey(ecPublicKey, privateKey = (ECPrivateKey)tempPK)) continue;
                return privateKey;
            }
        }
        return null;
    }

    private static boolean checkPublicPrivateKey(ECPublicKey ecPublicKey, ECPrivateKey ecPrivateKey) {
        try {
            byte[] d = new byte[8];
            byte[] e = new byte[8];
            Random random = new Random();
            random.nextBytes(d);
            random.nextBytes(e);
            IESParameterSpec param = new IESParameterSpec(d, e, 256);
            Cipher iesCipher = Cipher.getInstance("ECIES", "BC");
            iesCipher.init(1, (Key)ecPublicKey, (AlgorithmParameterSpec)param);
            byte[] bytesToEncrypt = "MU5T4F4L1V35".getBytes();
            byte[] encryptedBytes = iesCipher.doFinal(bytesToEncrypt);
            iesCipher.init(2, (Key)ecPrivateKey, (AlgorithmParameterSpec)param);
            byte[] decryptedBytes = iesCipher.doFinal(encryptedBytes);
            if (Arrays.equals(bytesToEncrypt, decryptedBytes)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static PKCS8EncryptedPrivateKeyInfo createPkcs8PrivateKeyInfo(String password, PrivateKey privateKey) throws OperatorCreationException {
        JceOpenSSLPKCS8EncryptorBuilder pkcs8 = new JceOpenSSLPKCS8EncryptorBuilder(NISTObjectIdentifiers.id_aes256_CBC);
        pkcs8.setProvider("BC");
        pkcs8.setPasssword(password.toCharArray());
        OutputEncryptor encryptor = pkcs8.build();
        JcaPKCS8EncryptedPrivateKeyInfoBuilder encryptedPkcs8 = new JcaPKCS8EncryptedPrivateKeyInfoBuilder(privateKey);
        PKCS8EncryptedPrivateKeyInfo encrypted = encryptedPkcs8.build(encryptor);
        return encrypted;
    }

    public static PrivateKey createPrivateKey(String password, byte[] encryptedPrivateKey) throws OperatorCreationException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, PKCSException, NoSuchProviderException {
        JceOpenSSLPKCS8DecryptorProviderBuilder decryptor = new JceOpenSSLPKCS8DecryptorProviderBuilder();
        InputDecryptorProvider decryptorProvider = decryptor.build(password.toCharArray());
        PKCS8EncryptedPrivateKeyInfo encryptedKeyInfo = new PKCS8EncryptedPrivateKeyInfo(encryptedPrivateKey);
        PrivateKeyInfo pkInfo = encryptedKeyInfo.decryptPrivateKeyInfo(decryptorProvider);
        PKCS8EncodedKeySpec pkcs8 = new PKCS8EncodedKeySpec(pkInfo.getEncoded());
        String algOid = pkInfo.getPrivateKeyAlgorithm().getAlgorithm().getId();
        KeyFactory kf = KeyFactory.getInstance(algOid, "BC");
        PrivateKey privKey = kf.generatePrivate(pkcs8);
        return privKey;
    }

    public static void storePkcs12PrivateKey(String alias, String password, PrivateKey privateKey, Certificate[] chain, OutputStream output) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance("PKCS12", "BC");
        store.load(null, null);
        store.setKeyEntry(alias, privateKey, password.toCharArray(), chain);
        int storeChainLength = store.getCertificateChain(alias).length;
        if (storeChainLength != chain.length) {
            LOG.warn((Object)("Certificate chain length (" + storeChainLength + ") in KeyStore does not match the number of certificates in the given chain (" + chain.length + ")"));
            store = KeyStore.getInstance("PKCS12", "SUN");
            store.load(null, null);
            store.setKeyEntry(alias, privateKey, password.toCharArray(), chain);
        }
        store.store(output, password.toCharArray());
    }

    public static String extractSymmetricAlgorithm(String algorithm) {
        int oaepSuffixIndex = algorithm.indexOf(OAEP_SUFFIX);
        if (oaepSuffixIndex > 0) {
            return algorithm.substring(0, oaepSuffixIndex);
        }
        int ecdhSuffixIndex = algorithm.indexOf(ECDH_SUFFIX);
        if (ecdhSuffixIndex > 0) {
            return algorithm.substring(0, ecdhSuffixIndex);
        }
        return algorithm;
    }

    public static String extractAsymmetricAlgorithm(String algorithm) {
        int oaepSuffixIndex = algorithm.indexOf(OAEP_SUFFIX);
        if (oaepSuffixIndex > 0) {
            return algorithm.substring(oaepSuffixIndex + 1);
        }
        int ecdhSuffixIndex = algorithm.indexOf(ECDH_SUFFIX);
        if (ecdhSuffixIndex > 0) {
            return algorithm.substring(ecdhSuffixIndex + 1);
        }
        return null;
    }

    static {
        signAlgorithms.put(SHA1_WITH_RSA, SIGN_SHA1WITHRSA);
        signAlgorithms.put(SHA224_WITH_RSA, SIGN_SHA224WITHRSA);
        signAlgorithms.put(SHA256_WITH_RSA, SIGN_SHA256WITHRSA);
        signAlgorithms.put(SHA384_WITH_RSA, SIGN_SHA384WITHRSA);
        signAlgorithms.put(SHA512_WITH_RSA, SIGN_SHA512WITHRSA);
        signAlgorithms.put(SHA256_WITH_ECDSA, SIGN_SHA256WITHECDSA);
        signAlgorithms.put(SHA384_WITH_ECDSA, SIGN_SHA384WITHECDSA);
        signAlgorithms.put(SHA512_WITH_ECDSA, SIGN_SHA512WITHECDSA);
        signAlgorithms.put(MD5_WITH_RSA, SIGN_MD5WITHRSA);
        digestAlgorithms.put(DIGEST_MD5, MD_5);
        digestAlgorithms.put(DIGEST_SHA1, SHA_1);
        digestAlgorithms.put(DIGEST_SHA224, SHA_224);
        digestAlgorithms.put(DIGEST_SHA256, SHA_256);
        digestAlgorithms.put(DIGEST_SHA384, SHA_384);
        digestAlgorithms.put(DIGEST_SHA512, SHA_512);
        encAlgorithmToIdentifier.put(ENC_AES128_CBC, ID_AES128_CBC);
        encAlgorithmToIdentifier.put(ENC_AES192_CBC, ID_AES192_CBC);
        encAlgorithmToIdentifier.put(ENC_AES256_CBC, ID_AES256_CBC);
        encAlgorithmToIdentifier.put(ENC_DES_EDE3_CBC, DES_EDE3_CBC);
        encAlgorithmToIdentifier.put(ENC_AES128_GCM, ID_AES128_GCM);
        encAlgorithmToIdentifier.put(ENC_AES192_GCM, ID_AES192_GCM);
        encAlgorithmToIdentifier.put(ENC_AES256_GCM, ID_AES256_GCM);
        identifierToEncAlgorithm.put(ID_AES128_CBC, ENC_AES128_CBC);
        identifierToEncAlgorithm.put(ID_AES192_CBC, ENC_AES192_CBC);
        identifierToEncAlgorithm.put(ID_AES256_CBC, ENC_AES256_CBC);
        identifierToEncAlgorithm.put(DES_EDE3_CBC, ENC_DES_EDE3_CBC);
        identifierToEncAlgorithm.put(ID_AES128_GCM, ENC_AES128_GCM);
        identifierToEncAlgorithm.put(ID_AES192_GCM, ENC_AES192_GCM);
        identifierToEncAlgorithm.put(ID_AES256_GCM, ENC_AES256_GCM);
        identifierToOAEP.put("OAEP_SHA1", OAEP_SHA1);
        identifierToOAEP.put("OAEP_SHA256", OAEP_SHA256);
        identifierToOAEP.put("OAEP_SHA512", OAEP_SHA512);
        identifierToECDH.put("ECDH_SHA224", SHA224_WITH_ECDH);
        identifierToECDH.put("ECDH_SHA256", SHA256_WITH_ECDH);
        identifierToECDH.put("ECDH_SHA512", SHA512_WITH_ECDH);
        ecdhToIdentifier.put(SHA224_WITH_ECDH, "ECDH_SHA224");
        ecdhToIdentifier.put(SHA256_WITH_ECDH, "ECDH_SHA256");
        ecdhToIdentifier.put(SHA512_WITH_ECDH, "ECDH_SHA512");
        identifierToKeyWrap.put(ENC_DES_EDE3_CBC, ID_DES_EDE3_WRAP);
        identifierToKeyWrap.put(ENC_AES128_GCM, ID_AES_128_WRAP);
        identifierToKeyWrap.put(ENC_AES128_CBC, ID_AES_128_WRAP);
        identifierToKeyWrap.put(ENC_AES192_CBC, ID_AES_192_WRAP);
        identifierToKeyWrap.put(ENC_AES192_GCM, ID_AES_192_WRAP);
        identifierToKeyWrap.put(ENC_AES256_GCM, ID_AES_256_WRAP);
        identifierToKeyWrap.put(ENC_AES256_CBC, ID_AES_256_WRAP);
    }

    public static class CMSEnvelopedGeneratorTupel {
        private final CMSEnvelopedDataStreamGenerator generator;

        private CMSEnvelopedGeneratorTupel(CMSEnvelopedDataStreamGenerator generator) {
            this.generator = generator;
        }

        public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out) throws CMSException, IOException {
            JceCMSContentEncryptorBuilder builder = new JceCMSContentEncryptorBuilder(dataType);
            builder.setProvider("BC");
            OutputEncryptor encryptor = builder.build();
            return this.generator.open(dataType, out, encryptor);
        }
    }

    public static class SMIMEEnvelopedGeneratorTupel {
        private final SMIMEEnvelopedGenerator generator;

        private SMIMEEnvelopedGeneratorTupel(SMIMEEnvelopedGenerator generator) {
            this.generator = generator;
        }

        public MimeBodyPart generate(ASN1ObjectIdentifier dataType, MimeMessage mimeMessage) throws CMSException, SMIMEException {
            OutputEncryptor encryptor = this.builderEncryptor(dataType);
            return this.generator.generate(mimeMessage, encryptor);
        }

        public MimeBodyPart generate(ASN1ObjectIdentifier dataType, MimeBodyPart mimePart) throws CMSException, SMIMEException {
            OutputEncryptor encryptor = this.builderEncryptor(dataType);
            return this.generator.generate(mimePart, encryptor);
        }

        private OutputEncryptor builderEncryptor(ASN1ObjectIdentifier dataType) throws CMSException {
            JceCMSContentEncryptorBuilder builder = new JceCMSContentEncryptorBuilder(dataType);
            builder.setProvider("BC");
            OutputEncryptor encryptor = builder.build();
            return encryptor;
        }
    }
}

