/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.registry.client;

import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.transport.XpHttpClientManager;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.client.WebDAVResponse;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryHttpClient {
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.RegistryHttpClient");
    private static final String USER_AGENT = "User-Agent";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final int MAX_RESPONSE_SIZE = 1000000;
    private final MessengerConfig _messengerConfig;
    private final XpHttpClientManager xpHttpClientManager;

    public RegistryHttpClient(MessengerConfig messengerConfig, XpHttpClientManager xpHttpClientManager) {
        this._messengerConfig = messengerConfig;
        this.xpHttpClientManager = xpHttpClientManager;
    }

    public URL getRegistryURL() throws RegistryException {
        try {
            if (StringUtils.isBlank((CharSequence)this._messengerConfig.getRegistryURL())) {
                throw new RegistryException(33001, "Registry URL is not set.");
            }
            try {
                return new URL(this._messengerConfig.getRegistryURL());
            }
            catch (MalformedURLException e) {
                throw new RegistryException(33001, "Registry URL is not correct.", e);
            }
        }
        catch (JAXBException e) {
            throw new RegistryException(-1, "Could not read registry settings.", e);
        }
    }

    private String getRegistryUsername() throws RegistryException {
        try {
            String user = this._messengerConfig.getRegistryUsername();
            if (StringUtils.isBlank((CharSequence)user)) {
                throw new RegistryException(33001, "Registry username is not set.");
            }
            return user;
        }
        catch (JAXBException e) {
            throw new RegistryException(-1, "Could not read registry settings.", e);
        }
    }

    private String getRegistryPassword() throws RegistryException {
        try {
            String password = this._messengerConfig.getRegistryPassword();
            if (StringUtils.isBlank((CharSequence)password)) {
                throw new RegistryException(33001, "Registry password is not set.");
            }
            return password;
        }
        catch (JAXBException e) {
            throw new RegistryException(-1, "Could not read registry settings.", e);
        }
    }

    public void checkRegistrySettings() throws RegistryException {
        this.getRegistryURL();
        this.getRegistryUsername();
        this.getRegistryPassword();
    }

    private String getProxyDomain() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this._messengerConfig.getProxyDomain())) {
                return this._messengerConfig.getProxyDomain() + "\\";
            }
        }
        catch (JAXBException e) {
            _log.debug((Object)e.getMessage(), e.getCause());
        }
        return "";
    }

    public WebDAVResponse sendHttpRequest(HttpRequest.Builder httpRequestBuilder) throws RegistryException, IOException {
        try {
            WebDAVResponse response;
            block26: {
                httpRequestBuilder.setHeader(USER_AGENT, Constants.getHTTP_XP_NAME());
                try {
                    if (this._messengerConfig.getRegistryUsername() != null && this._messengerConfig.getRegistryPassword() != null) {
                        httpRequestBuilder.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((this._messengerConfig.getRegistryUsername() + ":" + this._messengerConfig.getRegistryPassword()).getBytes(StandardCharsets.UTF_8)));
                    }
                }
                catch (JAXBException e) {
                    _log.warn((Object)"Could not read partner registry credentials, so it will be ignored: {}", (Throwable)e);
                }
                try {
                    if (this._messengerConfig.getProxyUser() != null && this._messengerConfig.getProxyPassword() != null) {
                        httpRequestBuilder.setHeader("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((this.getProxyDomain() + this._messengerConfig.getProxyUser() + ":" + this._messengerConfig.getProxyPassword()).getBytes(StandardCharsets.UTF_8)));
                    }
                }
                catch (JAXBException e) {
                    _log.warn((Object)"Could not read proxy credentials, so it will be ignored: {}", (Throwable)e);
                }
                HttpClient httpClient = this.xpHttpClientManager.createXpTrustAllHttpClient();
                HttpRequest httpRequest = httpRequestBuilder.timeout(httpClient.connectTimeout().orElse(Duration.ofSeconds(60L))).build();
                HttpResponse<InputStream> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
                int responseCode = httpResponse.statusCode();
                response = new WebDAVResponse();
                response.setHttpResponseCode(responseCode);
                try (InputStream bodyInputStream = httpResponse.body();){
                    boolean isFailure;
                    if (responseCode / 100 == 5) {
                        isFailure = true;
                    } else if (responseCode == 403 || responseCode == 407 || responseCode == 401) {
                        isFailure = true;
                        response.setAuthorizationFailed(true);
                    } else if (responseCode / 100 == 4) {
                        isFailure = true;
                    } else {
                        if (responseCode / 100 != 2) {
                            throw new RegistryException(-1, "Bad response: (" + responseCode + " - " + new String(this.readBody(bodyInputStream, true), StandardCharsets.UTF_8) + ")");
                        }
                        isFailure = false;
                    }
                    if (isFailure) {
                        try {
                            HashMap<String, String> responseHeaderMap = this.readResponseHeaders(httpResponse);
                            byte[] body = this.readBody(bodyInputStream, true);
                            String bodyAsText = new String(body, StandardCharsets.UTF_8);
                            try {
                                response.setResponseText(responseCode + " " + URLDecoder.decode(bodyAsText, StandardCharsets.UTF_8));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            response.setResponseText(bodyAsText);
                            _log.debug((Object)("http error status: " + httpResponse.statusCode()));
                            _log.debug((Object)("http error response: " + bodyAsText));
                            response.setFailed(isFailure);
                            response.setResponseMessage(body);
                            response.setMimeHeaders(responseHeaderMap);
                            break block26;
                        }
                        catch (Exception ex) {
                            _log.fatal((Object)"Error: ", (Throwable)ex);
                            throw new IOException("Unable to read response: " + ex.getMessage());
                        }
                    }
                    byte[] responseData = this.readBody(bodyInputStream, false);
                    response.setResponseMessage(responseData);
                    response.setFailed(false);
                    response.setResponseText(new String(responseData, StandardCharsets.UTF_8));
                    response.setAuthorizationFailed(false);
                    response.setMimeHeaders(this.readResponseHeaders(httpResponse));
                }
            }
            return response;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private byte[] readBody(InputStream bodyInputStream, boolean withLimit) throws IOException {
        if (withLimit) {
            return bodyInputStream == null ? new byte[]{} : bodyInputStream.readNBytes(1000000);
        }
        return bodyInputStream == null ? new byte[]{} : bodyInputStream.readAllBytes();
    }

    private HashMap<String, String> readResponseHeaders(HttpResponse<InputStream> httpResponse) {
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        HttpHeaders responseHeaders = httpResponse.headers();
        responseHeaders.map().forEach((k, v) -> {
            for (int i = 0; i < v.size(); ++i) {
                responseHeaderMap.put((String)k, (String)v.get(i));
            }
        });
        return responseHeaderMap;
    }
}

