/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.registry;

import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ClientCertificateInstaller;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.update.AgreementUpdateUtility;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.integration.WebDavIntegration;
import de.pontonconsulting.xmlpipe.messenger.database.EventLogEntry;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.RemoteMaintenanceIntervalDAO;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.client.PartnerRegistryClient;
import de.pontonconsulting.xmlpipe.security.CertificateExpireCheckTask;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryProfileUpdater {
    private static final String EVENT_ID = "profileupdater;";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.RegistryProfileUpdater");
    private final EventLog eventLog;
    private final Profiles profiles;
    private final MessengerConfig messengerConfig;
    private final ClientCertificateInstaller clientCertificateInstaller;
    private final CertificateExpireCheckTask certificateExpireCheckTask;
    private final AgreementUpdateUtility agreementUpdateUtility;
    private final WebDavIntegration webDavIntegration;
    private final PartnerRegistryClient registryClient;
    private final TempFileCreator tempFileCreator;
    private final RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO;
    private final PartnerProfileDAO partnerProfileDAO;

    public RegistryProfileUpdater(EventLog eventLog, Profiles profiles, MessengerConfig messengerConfig, ClientCertificateInstaller clientCertificateInstaller, CertificateExpireCheckTask certificateExpireCheckTask, AgreementUpdateUtility agreementUpdateUtility, WebDavIntegration webDavIntegration, PartnerRegistryClient registryClient, TempFileCreator tempFileCreator, RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO, PartnerProfileDAO partnerProfileDAO) {
        this.eventLog = eventLog;
        this.profiles = profiles;
        this.messengerConfig = messengerConfig;
        this.clientCertificateInstaller = clientCertificateInstaller;
        this.certificateExpireCheckTask = certificateExpireCheckTask;
        this.agreementUpdateUtility = agreementUpdateUtility;
        this.webDavIntegration = webDavIntegration;
        this.registryClient = registryClient;
        this.tempFileCreator = tempFileCreator;
        this.remoteMaintenanceIntervalDAO = remoteMaintenanceIntervalDAO;
        this.partnerProfileDAO = partnerProfileDAO;
    }

    private void synchronizeRemotePartners(SynchronizeResult synchronizeResult, Map<String, IndexRecord> indexRecords) {
        for (PartnerProfile partnerProfile : this.partnerProfileDAO.getAllRemotePartnerProfilesFromRegistry()) {
            synchronizeResult.incRegistryRemotePartnerCount();
            IndexRecord indexRecord = indexRecords.get(partnerProfile.getRegistryPath());
            if (indexRecord == null) continue;
            long remoteLastModified = indexRecord.getLastModifiedLong();
            if (partnerProfile.getRegistryTimestamp() == null || partnerProfile.getRegistryTimestamp().toInstant().toEpochMilli() == remoteLastModified) continue;
            try {
                CppPartner cppPartner = this.profiles.getProfileForLocalId(partnerProfile.getPartnerId(), false);
                if (this.updateProfile(cppPartner, remoteLastModified, indexRecord.getFilePath()) == null) continue;
                synchronizeResult.incUpdatedRemoteRegistryPartnerCount();
            }
            catch (ProfileException e) {
                _log.warn("Could not update remote partner '{}' from registry: {}", (Object)partnerProfile.getPartnerId(), (Object)e.toString());
            }
        }
    }

    private void synchronizeLocalPartners(SynchronizeResult synchronizeResult, Map<String, IndexRecord> indexRecords) throws RegistryException {
        for (PartnerProfile partnerProfile : this.partnerProfileDAO.getAllLocalPartnerProfilesFromRegistry()) {
            synchronizeResult.incRegistryRemotePartnerCount();
            IndexRecord indexRecord = indexRecords.get(partnerProfile.getRegistryPath());
            if (indexRecord == null) continue;
            long remoteLastModified = indexRecord.getLastModifiedLong();
            if (partnerProfile.getRegistryTimestamp() == null || partnerProfile.getRegistryTimestamp().toInstant().toEpochMilli() == remoteLastModified) continue;
            try {
                try {
                    CppPartner cppPartner = this.profiles.getProfileForLocalId(partnerProfile.getPartnerId(), false);
                    this.uploadLocalPartner(cppPartner);
                    synchronizeResult.incUpdatedLocalRegistryPartnerCount();
                }
                catch (RegistryException e) {
                    _log.warn("Could not upload local partner '{}' to registry: {}", (Object)partnerProfile.getPartnerId(), (Object)e.toString());
                }
                catch (AgreementException | ProfileStoreAccessException e) {
                    _log.warn("Could not update partner profile '{}' with registry-timestamp", (Object)partnerProfile.getPartnerId());
                }
            }
            catch (ProfileException e) {
                throw new RegistryException(33000, e.getMessage(), e);
            }
        }
    }

    private void updateAgreements(CppPartner partner) throws AgreementException {
        boolean updateAgreements = false;
        try {
            updateAgreements = this.messengerConfig.isAutomaticAgreementUpdateEnabled();
        }
        catch (JAXBException e) {
            _log.error("Could not get value of 'Automatic Agreement Update' from the messenger config: {}", (Object)String.valueOf((Object)e));
            _log.warn("Using the default value (FLASE) of 'Automatic Agreement Update'.");
        }
        if (updateAgreements && partner.isAgreementAutoupdate()) {
            this.agreementUpdateUtility.updateAllAgreementsForRegistryPartner(partner);
        }
    }

    public SynchronizeResult updateProfiles(boolean forceDownload) throws RegistryException {
        SynchronizeResult synchronizeResult = new SynchronizeResult(this);
        try {
            if (this.webDavIntegration.isRegistryEnabled()) {
                _log.info("Going to synchronize profiles with registry.");
                Map<String, IndexRecord> indexRecords = this.webDavIntegration.getRegistryIndex(forceDownload);
                if (indexRecords == null) {
                    throw new RegistryException(-1, "Download of Partner-Registry IndexRecord failed.");
                }
                this.synchronizeRemotePartners(synchronizeResult, indexRecords);
                this.synchronizeLocalPartners(synchronizeResult, indexRecords);
                _log.info("Synchronized {} from {} remote profiles and {} from {} local profiles with registry.", (Object)synchronizeResult.getUpdatedRemoteRegistryPartnerCount(), (Object)synchronizeResult.getRegistryRemotePartnerCount(), (Object)synchronizeResult.getUpdatedLocalRegistryPartnerCount(), (Object)synchronizeResult.getRegistryLocalPartnerCount());
            }
            return synchronizeResult;
        }
        catch (RegistryException je) {
            _log.error("failed to update Profiles: {}", (Object)je.getMessage());
            throw je;
        }
    }

    public void uploadLocalPartner(CppPartner profile) throws RegistryException, ProfileStoreAccessException, AgreementException {
        this.registryClient.uploadLocalPartner(profile);
        this.webDavIntegration.getRegistryIndex(true);
        Optional<IndexRecord> record = this.webDavIntegration.getIndexRecordForFilePath(profile.getRemoteFile());
        if (record.isPresent()) {
            profile.setLastModified(record.get().getLastModifiedLong());
            profile.saveUpdatedProfile();
        } else {
            _log.error("Registry IndexRecord for {} not found", (Object)profile.getRemoteFile());
        }
    }

    public CppPartner updateProfile(CppPartner partner) {
        _log.info("Going to update profile '{}[{}]' from registry.", (Object)partner.getDisplayName(), (Object)partner.getLocalId());
        CppPartner result = null;
        try {
            Optional<IndexRecord> indexRecord;
            if (!this.webDavIntegration.isRegistryEnabled()) {
                _log.error("Automatic update of profiles is enabled, but registry configuration is incomplete.");
                throw new RegistryException(33001, "Registry configuration is incomplete.");
            }
            if (_log.isTraceEnabled()) {
                _log.trace("Checking for updates of partner: '{}' ({})", (Object)partner.getDisplayName(), (Object)partner.getLocalId());
            }
            if ((indexRecord = this.webDavIntegration.getIndexRecordForFilePath(partner.getRemoteFile())).isPresent() && (indexRecord.get().getLastModifiedLong() != partner.getLastModified() || partner.isDirty())) {
                _log.trace("Remote profile is newer than the local profile. Updating Profile ...");
                result = this.updateProfile(partner, indexRecord.get().getLastModifiedLong(), indexRecord.get().getFilePath());
            }
        }
        catch (RegistryException je) {
            _log.error("failed to update Profiles: {}", (Object)je.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CppPartner updateProfile(CppPartner partner, long remoteLastModified, String remoteFilePath) {
        CppPartner result = null;
        File file = null;
        try {
            file = this.tempFileCreator.createTempFile("tempFile", ".tmp");
            this.registryClient.downloadFile(file, remoteFilePath);
            result = this.importUpdatedProfile(partner.getLocalId(), remoteLastModified, file);
            this.pushCertificateToListener(partner);
            this.certificateExpireCheckTask.checkForExpiredPartnerCertificates(partner);
            this.profiles.partnerCertificateUpdated(partner);
            this.updateAgreements(partner);
        }
        catch (AgreementException | ProfileException | RegistryException | IOException re) {
            _log.error("could not update Profile from registry. {}", (Object)re.toString());
        }
        finally {
            if (file != null && file.exists() && !file.delete()) {
                _log.warn("could not delete temporary file " + String.valueOf(file));
            }
        }
        return result;
    }

    public void pushCertificateToListener(CppPartner partner) {
        try {
            this.clientCertificateInstaller.updatePartnerCertificate(partner.getLocalId());
        }
        catch (Exception e) {
            _log.warn("problem while sending certificate update to Listener server {}", (Object)e.toString());
        }
    }

    private CppPartner importUpdatedProfile(String partnerId, long remoteLastModified, File file) throws ProfileException, AgreementException {
        try {
            CppPartner importedPartner = this.profiles.getProfileForLocalId(partnerId, file, false);
            importedPartner.setLastModified(remoteLastModified);
            importedPartner.saveUpdatedProfile();
            this.remoteMaintenanceIntervalDAO.update(partnerId, importedPartner.getMaintenanceIntervals().stream().map(e -> new RemoteMaintenanceInterval().setPartnerId(partnerId).setStartTime(e.getStartTime()).setEndTime(e.getEndTime())).toList());
            String id = "profileupdater;ok;" + importedPartner.getLocalId();
            this.eventLog.delete(id);
            this.eventLog.add(new EventLogEntry(id, System.currentTimeMillis(), "profileupdater", "event.profile.ok.update", importedPartner.getDisplayName() + "[" + importedPartner.getLocalId() + "]", EventLog.STATUS_OK, ""));
            _log.info("Successfully downloaded and updated profile for partner '{}'", (Object)importedPartner.getLocalId());
            return importedPartner;
        }
        catch (ProfileException pe) {
            _log.error("Could not update profile for partner '{}' from file: {}", (Object)partnerId, (Object)pe.toString());
            String id = "profileupdater;error;" + partnerId;
            this.eventLog.delete(id);
            this.eventLog.add(new EventLogEntry(id, System.currentTimeMillis(), "profileupdater", "event.profile.error.reload", "[" + partnerId + "]", EventLog.STATUS_ERROR, ""));
            return null;
        }
    }

    public class SynchronizeResult {
        private int registryRemotePartnerCount = 0;
        private int updatedRemoteRegistryPartnerCount = 0;
        private int registryLocalPartnerCount = 0;
        private int updatedLocalRegistryPartnerCount = 0;

        public SynchronizeResult(RegistryProfileUpdater this$0) {
        }

        public int getRegistryRemotePartnerCount() {
            return this.registryRemotePartnerCount;
        }

        public void incRegistryRemotePartnerCount() {
            ++this.registryRemotePartnerCount;
        }

        public int getUpdatedRemoteRegistryPartnerCount() {
            return this.updatedRemoteRegistryPartnerCount;
        }

        public void incUpdatedRemoteRegistryPartnerCount() {
            ++this.updatedRemoteRegistryPartnerCount;
        }

        public int getRegistryLocalPartnerCount() {
            return this.registryLocalPartnerCount;
        }

        public void incRegistryLocalPartnerCount() {
            ++this.registryLocalPartnerCount;
        }

        public int getUpdatedLocalRegistryPartnerCount() {
            return this.updatedLocalRegistryPartnerCount;
        }

        public void incUpdatedLocalRegistryPartnerCount() {
            ++this.updatedLocalRegistryPartnerCount;
        }
    }
}

