/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.util;

import de.pontonconsulting.xmlpipe.adapter.util.UTF8BOMSkippingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final Logger LOGGER = LogManager.getLogger(XmlUtil.class);
    private static final DocumentBuilderFactory _documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory _transformerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(File xmlFile, Document document) throws IOException, TransformerException {
        OutputStream fileOutputStream = null;
        try {
            fileOutputStream = new BufferedOutputStream(Files.newOutputStream(xmlFile.toPath(), new OpenOption[0]));
            XmlUtil.writeDocument(fileOutputStream, document);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(OutputStream outputStream, Document document) throws FileNotFoundException, TransformerException {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputStream);
        Transformer transformer = null;
        TransformerFactory transformerFactory = _transformerFactory;
        synchronized (transformerFactory) {
            transformer = _transformerFactory.newTransformer();
        }
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "no");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = _documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                documentBuilder = _documentBuilderFactory.newDocumentBuilder();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        return documentBuilder;
    }

    public static Document getDocument(File file) throws Exception {
        try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            Document document = XmlUtil.getDocument(fileInputStream);
            return document;
        }
    }

    public static Document getDocument(InputStream inputStream) throws Exception {
        return XmlUtil.getDocumentBuilder().parse(inputStream);
    }

    public static boolean isXml(String inputFilePath) {
        boolean bl;
        UTF8BOMSkippingInputStream inputStream = new UTF8BOMSkippingInputStream((InputStream)new BufferedInputStream(Files.newInputStream(Path.of(inputFilePath, new String[0]), new OpenOption[0])));
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            factory.setXMLReporter(null);
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader((InputStream)inputStream);
            xmlStreamReader.next();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return false;
            }
        }
        inputStream.close();
        return bl;
    }

    static {
        _documentBuilderFactory.setNamespaceAware(true);
        _documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        _transformerFactory = TransformerFactory.newInstance();
    }
}

