/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.util;

import de.pontonconsulting.xmlpipe.messenger.util.XmlSignatureValidationResult;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.XpWSSecurity;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlSignatureUtil {
    private static final String RSA_SHA1 = "rsa-sha1";
    private static final String RSA_SHA1_TAG = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.XmlSignatureUtil");
    private final CertificateUtility certificateUtility;

    public XmlSignatureUtil(CertificateUtility certificateUtility) {
        this.certificateUtility = certificateUtility;
    }

    public void sign(Document document, X509Certificate x509Certificate, PrivateKey privateKey) throws Exception {
        if (this.isSigned(document)) {
            return;
        }
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        XMLSignature signature = new XMLSignature(document, "http://www.w3.org/2000/09/xmldsig#", RSA_SHA1_TAG);
        signature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        signature.addKeyInfo(x509Certificate);
        KeyInfo keyInfo = signature.getKeyInfo();
        keyInfo.itemX509Data(0).addSubjectName(x509Certificate.getSubjectX500Principal().getName());
        keyInfo.itemX509Data(0).addIssuerSerial(x509Certificate.getIssuerX500Principal().getName(), x509Certificate.getSerialNumber());
        document.getDocumentElement().appendChild(signature.getElement());
        signature.sign((Key)privateKey);
    }

    XmlSignatureValidationResult isSignatureValid(Document document, X509Certificate certificate) throws Exception {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(1);
        certificates.add(certificate);
        return this.isSignatureValid(document, certificates);
    }

    public XmlSignatureValidationResult isSignatureValid(Document document, Collection<X509Certificate> certificates) throws Exception {
        Object errorMsg;
        XmlSignatureValidationResult validationResult = new XmlSignatureValidationResult();
        if (!this.isSigned(document)) {
            validationResult.setValid(false);
            validationResult.setErrorMessage("The document is not signed.");
            return validationResult;
        }
        if (certificates == null || certificates.size() == 0) {
            validationResult.setValid(false);
            validationResult.setErrorMessage("No certificate found to verify the XML Signature.");
        }
        XMLSignature signature = new XMLSignature(this.getSignature(document), "http://www.w3.org/2000/09/xmldsig#");
        SignatureAlgorithm signatureAlgorthm = signature.getSignedInfo().getSignatureAlgorithm();
        validationResult.setAlgorithm(XpWSSecurity.resolveAlgorithmUri(signatureAlgorthm.getAlgorithmURI()));
        validationResult.setAlgorithmUri(signatureAlgorthm.getAlgorithmURI());
        validationResult.setJceAlgorithm(signatureAlgorthm.getJCEAlgorithmString());
        validationResult.setVersion(XpWSSecurity.resolveAlgorithmVersion(signatureAlgorthm.getBaseNamespace()));
        X500Principal issuerX500Principal = null;
        BigInteger serialNumber = null;
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo != null) {
            X509Certificate embeddedCertificate = keyInfo.getX509Certificate();
            if (embeddedCertificate != null) {
                issuerX500Principal = embeddedCertificate.getIssuerX500Principal();
                serialNumber = embeddedCertificate.getSerialNumber();
            } else {
                for (int i = 0; i < keyInfo.lengthX509Data(); ++i) {
                    try {
                        issuerX500Principal = null;
                        serialNumber = null;
                        X509Data x509Data = keyInfo.itemX509Data(i);
                        XMLX509IssuerSerial xmlX509IssuerSerial = x509Data.itemIssuerSerial(0);
                        if (xmlX509IssuerSerial == null) continue;
                        serialNumber = xmlX509IssuerSerial.getSerialNumber();
                        issuerX500Principal = new X500Principal(xmlX509IssuerSerial.getIssuerName());
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not get certificate information from the XML Signature Element: " + e.toString());
                    }
                }
            }
        }
        if (serialNumber != null && issuerX500Principal != null) {
            for (X509Certificate x509Certificate : certificates) {
                if (!x509Certificate.getSerialNumber().equals(serialNumber) || !x509Certificate.getIssuerX500Principal().equals(issuerX500Principal)) continue;
                validationResult.setCertificate(x509Certificate);
                validationResult.setValid(signature.checkSignatureValue(x509Certificate));
                return validationResult;
            }
            validationResult.setValid(false);
            errorMsg = "Message was signed with a wrong Certificate. Could not find certificate serial: " + this.certificateUtility.serialNr2String(serialNumber) + " (" + String.valueOf(serialNumber) + ") , Issuer: " + issuerX500Principal.toString();
            validationResult.setErrorMessage((String)errorMsg);
            return validationResult;
        }
        for (X509Certificate x509Certificate : certificates) {
            if (!signature.checkSignatureValue(x509Certificate)) continue;
            validationResult.setCertificate(x509Certificate);
            validationResult.setValid(signature.checkSignatureValue(x509Certificate));
            return validationResult;
        }
        validationResult.setValid(false);
        errorMsg = "Message was signed with a wrong Certificate or the signature is not vaild.";
        validationResult.setErrorMessage("Message was signed with a wrong Certificate or the signature is not vaild.");
        return validationResult;
    }

    private Element getSignature(Document document) {
        NodeList signatureElements = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureElements != null && signatureElements.getLength() > 0) {
            return (Element)signatureElements.item(0);
        }
        return null;
    }

    public boolean deleteSignatureTag(Document document) {
        Element signatureChild = this.getSignature(document);
        if (signatureChild != null) {
            signatureChild.getParentNode().removeChild(signatureChild);
            return true;
        }
        return false;
    }

    private boolean isSigned(Document doc) {
        Element sigElement = this.getSignature(doc);
        return sigElement != null;
    }
}

