/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.Map;

public class XpMessageInputStream
extends InputStream {
    private static final String COLON = ": ";
    private static final String US_ASCII = "US-ASCII";
    private static final String LF = "\n";
    private ByteArrayInputStream _messageHeader;
    private InputStream _messageBody;
    private byte[] _buffer;
    private int _bufferFilled;
    private int _bufferPosition;
    private boolean _readHeader;

    public XpMessageInputStream(File messageHeaderFile, File messageBodyFile) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(messageHeaderFile.toPath(), new OpenOption[0])));
        Map headers = (Map)ois.readObject();
        ois.close();
        this.init(headers, messageBodyFile);
    }

    public XpMessageInputStream(Map<String, String> headers, File messageBodyFile) throws IOException {
        this.init(headers, messageBodyFile);
    }

    private void init(Map<String, String> headers, File messageBodyFile) throws IOException {
        this._buffer = new byte[4096];
        this._messageBody = new BufferedInputStream(Files.newInputStream(messageBodyFile.toPath(), new OpenOption[0]));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder tempHeader = new StringBuilder();
        Iterator<String> iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            tempHeader.setLength(0);
            String headerName = iter.next();
            tempHeader.append(headerName);
            tempHeader.append(COLON);
            tempHeader.append(headers.get(headerName));
            tempHeader.append(LF);
            baos.write(tempHeader.toString().getBytes(StandardCharsets.US_ASCII));
        }
        if (headers.size() > 0) {
            baos.write(LF.getBytes());
        }
        baos.close();
        this._messageHeader = new ByteArrayInputStream(baos.toByteArray());
        this._readHeader = true;
    }

    @Override
    public int read() throws IOException {
        if (this._readHeader) {
            return this.readHeader();
        }
        return this.readBody();
    }

    private int readBody() throws IOException {
        if (this._bufferFilled - this._bufferPosition == 0) {
            this._bufferFilled = this._messageBody.read(this._buffer);
            this._bufferPosition = 0;
        }
        if (this._bufferFilled == -1) {
            return -1;
        }
        return this._buffer[this._bufferPosition++] & 0xFF;
    }

    private int readHeader() throws IOException {
        int result = this._messageHeader.read();
        if (result == -1) {
            this._readHeader = false;
            return this.readBody();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this._messageBody.close();
    }
}

