/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.config.IActivationProviderAware;
import de.pontonconsulting.xmlpipe.config.IMessengerConfigAware;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.transport.BaseTransportProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.FtpProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.IXpHttpClientManagerAware;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSenderFactory;
import de.pontonconsulting.xmlpipe.messenger.transport.XpHttpClientManager;
import de.pontonconsulting.xmlpipe.security.PontonAuthenticator;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;

public class TransportProviderFactory
implements ApplicationListener<ReloadConfiguration> {
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.TransportProvider");
    private final ArrayList<BaseTransportProvider> _transportProviders;
    private final MessengerConfig _messengerConfig;
    private final PontonAuthenticator _authenticator;
    private final Profiles _profiles;
    private final MessageDAO _messageDAO;
    private final MDNDataDAO _mdnDataDAO;
    private final SmtpSenderFactory _smtpSenderFactory;
    private final KeystoreBean keyStoreBean;
    private final MessengerActivation activationProvider;
    private final XpHttpClientManager xpHttpClientManager;

    public TransportProviderFactory(MessengerConfig messengerConfig, PontonAuthenticator authenticator, Profiles profiles, MessageDAO messageDAO, MDNDataDAO mdnDataDAO, SmtpSenderFactory smtpSenderFactory, KeystoreBean keyStoreBean, MessengerActivation activationProvider, XpHttpClientManager xpHttpClientManager) {
        this._messengerConfig = messengerConfig;
        this._authenticator = authenticator;
        this._profiles = profiles;
        this._messageDAO = messageDAO;
        this._mdnDataDAO = mdnDataDAO;
        this._smtpSenderFactory = smtpSenderFactory;
        this.keyStoreBean = keyStoreBean;
        this.xpHttpClientManager = xpHttpClientManager;
        this._transportProviders = new ArrayList();
        this.activationProvider = activationProvider;
    }

    @PostConstruct
    public void init() {
        ServiceLoader<BaseTransportProvider> serviceLoader = ServiceLoader.load(BaseTransportProvider.class, this.getClass().getClassLoader());
        for (BaseTransportProvider transport : serviceLoader) {
            this.initTransport(transport);
            this._transportProviders.add(transport);
        }
    }

    public void shutdown() {
        for (BaseTransportProvider transportProvider : this._transportProviders) {
            transportProvider.shutdown();
        }
    }

    private void initTransport(BaseTransportProvider transport) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Initializing transport provider: " + transport.getClass().getSimpleName()));
        }
        if (transport instanceof IMessengerConfigAware) {
            ((IMessengerConfigAware)((Object)transport)).setMessengerConfig(this._messengerConfig);
        }
        if (transport instanceof IActivationProviderAware) {
            ((IActivationProviderAware)((Object)transport)).setActivationProvider(this.activationProvider);
        }
        if (transport instanceof FtpProvider) {
            ((FtpProvider)transport).setAuthenticator(this._authenticator);
        }
        if (transport instanceof SmtpProvider) {
            ((SmtpProvider)transport).setSmtpSenderFactory(this._smtpSenderFactory);
        }
        if (transport instanceof FtpProvider) {
            ((FtpProvider)transport).setKeyStoreBean(this.keyStoreBean);
        }
        if (transport instanceof IXpHttpClientManagerAware) {
            ((IXpHttpClientManagerAware)((Object)transport)).setXpHttpClientManager(this.xpHttpClientManager);
        }
    }

    public BaseTransportProvider getTransportProvider(String uri) {
        for (BaseTransportProvider transportProvider : this._transportProviders) {
            if (!transportProvider.canHandleUri(uri)) continue;
            return transportProvider;
        }
        return null;
    }

    public void onApplicationEvent(ReloadConfiguration event) {
        for (BaseTransportProvider baseTransportProvider : this._transportProviders) {
            baseTransportProvider.onApplicationEvent(event);
        }
    }
}

