/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.config.IActivationProviderAware;
import de.pontonconsulting.xmlpipe.config.IMessengerConfigAware;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.transport.BaseTransportProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.IXpHttpClientManagerAware;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.messenger.transport.XpHttpClientManager;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpProvider
extends BaseTransportProvider
implements IMessengerConfigAware,
IActivationProviderAware,
IXpHttpClientManagerAware {
    private static final int MAX_RESPONSE_SIZE = 0x200000;
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String HTTP_SERVER = "Server";
    private static final String HEADER_TAB = "\t";
    private static final String HEADER_CR = "\r";
    private static final String HEADER_LF = "\n";
    private static final String HTTPS = "HTTPS";
    private static final String HTTP = "HTTP";
    private static final String[] NAMES = new String[]{"HTTP", "HTTPS"};
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.HttpProvider");
    private MessengerConfig _messengerConfig;
    private MessengerActivation messengerActivation;
    private XpHttpClientManager xpHttpClientManager;

    @Override
    public void shutdown() {
    }

    @Override
    public ProviderResponse sendMessage(File messageFile, File messageHeaderFile, URI uri, X509Certificate[] certificateChain, PrivateKey key, String user, String password, int retryInterval) throws TransportException, InterruptedException {
        try {
            HashMap outHeader;
            if (!messageHeaderFile.exists() || !messageFile.exists()) {
                throw new Exception("Packaged message data is missing. Transmission aborted.");
            }
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(messageHeaderFile.toPath(), new OpenOption[0])));){
                outHeader = (HashMap)ois.readObject();
            }
            outHeader.remove("X-allow-header-in-payload");
            return this.sendData(messageFile, messageFile.length(), null, outHeader, uri, certificateChain, key, user, password, retryInterval);
        }
        catch (TransportException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                LOG.error("Error: {}", (Object)ex.toString());
                throw new TransportException(25003, " HTTP(S) transmission failed: " + ex.getMessage());
            }
            LOG.error("Error: ", (Throwable)ex);
            throw new TransportException(25003, " HTTP(S) transmission failed: " + String.valueOf(ex));
        }
    }

    public ProviderResponse getData(File dataFile, HashMap<String, String> httpHeader, URI uri, X509Certificate[] certificateChain, PrivateKey key, String user, String password, int retryInterval) throws TransportException, InterruptedException {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
        this.setHeader(httpHeader, requestBuilder, user, password);
        this.setTimeout(retryInterval, requestBuilder);
        HttpRequest httpRequest = requestBuilder.GET().build();
        ProviderResponse providerResponse = this.sendRequest(okBodyInputStream -> {
            try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(dataFile.toPath(), new OpenOption[0]));){
                okBodyInputStream.transferTo(fileOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, httpRequest, uri, certificateChain, key);
        return providerResponse;
    }

    @Override
    public ProviderResponse sendData(File contentFile, long contentLength, String contentType, HashMap<String, String> httpHeader, URI uri, X509Certificate[] certificateChain, PrivateKey key, String user, String password, int retryInterval) throws TransportException, InterruptedException {
        HttpRequest httpRequest;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
        this.setHeader(httpHeader, requestBuilder, user, password);
        this.setTimeout(retryInterval, requestBuilder);
        try {
            httpRequest = requestBuilder.POST(HttpRequest.BodyPublishers.ofFile(contentFile.toPath())).build();
        }
        catch (FileNotFoundException e) {
            LOG.error("HTTP(S) transmission failed: Packaged message data is missing. Transmission aborted.");
            throw new TransportException(25003, " HTTP(S) transmission failed: Packaged message data is missing. Transmission aborted.");
        }
        ByteArrayOutputStream okBodyContent = new ByteArrayOutputStream();
        ProviderResponse providerResponse = this.sendRequest(bodyInputStream -> {
            try {
                okBodyContent.writeBytes(bodyInputStream.readNBytes(0x200000));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, httpRequest, uri, certificateChain, key);
        providerResponse.setResponseMessage(okBodyContent.toByteArray());
        return providerResponse;
    }

    private void setTimeout(int retryInterval, HttpRequest.Builder requestBuilder) {
        long abortTimeout = (long)retryInterval * 1000L;
        if (abortTimeout < 1L) {
            abortTimeout = 1000L;
        }
        LOG.debug("http timeout set to {} seconds", (Object)(abortTimeout / 1000L));
        requestBuilder.timeout(Duration.ofMillis(abortTimeout));
    }

    private ProviderResponse sendRequest(Consumer<InputStream> bodyInputStreamConsumer, HttpRequest httpRequest, URI uri, X509Certificate[] certificateChain, PrivateKey key) throws TransportException, InterruptedException {
        ProviderResponse providerResponse = new ProviderResponse(uri.getScheme());
        try {
            HttpClient httpClient = this.xpHttpClientManager.getHttpClient(key, certificateChain);
            HttpResponse<InputStream> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
            int responseCode = httpResponse.statusCode();
            try (InputStream bodyInputStream = httpResponse.body();){
                boolean isFailure;
                if (responseCode / 100 == 2) {
                    isFailure = false;
                } else {
                    isFailure = true;
                    if (responseCode == 401 || responseCode == 403 || responseCode == 407) {
                        providerResponse.setAuthorizationFailed(true);
                    }
                }
                providerResponse.setFailed(isFailure);
                HashMap<String, String> responseHeaderMap = this.readResponseHeaders(httpResponse.headers());
                providerResponse.setMimeHeaders(responseHeaderMap);
                if (isFailure) {
                    byte[] body = this.readBody(bodyInputStream, true);
                    String bodyAsText = new String(body, StandardCharsets.UTF_8);
                    responseHeaderMap.put("X-reply-text", String.valueOf(responseCode));
                    LOG.debug("http error status: {}", (Object)responseCode);
                    LOG.debug("http error response: {}", (Object)bodyAsText);
                    bodyInputStreamConsumer.accept(new ByteArrayInputStream(body));
                } else {
                    bodyInputStreamConsumer.accept(bodyInputStream);
                }
            }
            catch (Exception ex) {
                LOG.error("Error: ", (Throwable)ex);
                throw new TransportException(25002, "Unable to read response: " + ex.getMessage());
            }
            return providerResponse;
        }
        catch (HttpTimeoutException timeoutException) {
            LOG.error("No response for HTTP transmission within retry interval");
            throw new TransportException(25004, "No response within retry interval.");
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (SSLException e) {
            Throwable cause = e.getCause();
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            TransportException transportException = new TransportException(25003, " HTTP(S) transmission failed: " + String.valueOf(cause));
            transportException.initCause(e.getCause());
            throw transportException;
        }
        catch (Exception e) {
            TransportException transportException = new TransportException(25003, " HTTP(S) transmission failed: " + String.valueOf(e));
            transportException.initCause(e.getCause());
            throw transportException;
        }
    }

    void setHeader(HashMap<String, String> httpHeader, HttpRequest.Builder requestBuilder, String user, String password) {
        boolean useHttpMultiLine;
        requestBuilder.setHeader("User-Agent", Constants.getHTTP_XP_NAME() + " (" + this.messengerActivation.getInstanceId() + ")");
        if (user != null && password != null) {
            requestBuilder.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.UTF_8)));
        }
        try {
            if (this._messengerConfig.getProxyUser() != null && this._messengerConfig.getProxyPassword() != null) {
                requestBuilder.setHeader("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((this.getProxyDomain() + this._messengerConfig.getProxyUser() + ":" + this._messengerConfig.getProxyPassword()).getBytes(StandardCharsets.UTF_8)));
            }
        }
        catch (JAXBException e) {
            LOG.warn("Could not read proxy credentials, so it will be ignored: {}", (Throwable)e);
        }
        try {
            useHttpMultiLine = this._messengerConfig.isHttpMultiLineUse();
        }
        catch (JAXBException e) {
            LOG.warn("Could not get value for HttpMultiLineUse.", (Throwable)e);
            useHttpMultiLine = false;
        }
        if (httpHeader != null) {
            for (String headerName : httpHeader.keySet()) {
                if (CONTENT_LENGTH.equalsIgnoreCase(headerName)) continue;
                String headerValue = httpHeader.get(headerName);
                if (!useHttpMultiLine) {
                    StringBuilder header = new StringBuilder(headerValue);
                    int index = -1;
                    while ((index = header.indexOf(HEADER_CR)) != -1) {
                        header.deleteCharAt(index);
                    }
                    while ((index = header.indexOf(HEADER_LF)) != -1) {
                        header.deleteCharAt(index);
                    }
                    while ((index = header.indexOf(HEADER_TAB)) != -1) {
                        header.deleteCharAt(index);
                    }
                    headerValue = header.toString();
                }
                requestBuilder.setHeader(headerName, headerValue);
            }
        }
    }

    private byte[] readBody(InputStream bodyInputStream, boolean withLimit) throws IOException {
        if (withLimit) {
            return bodyInputStream == null ? new byte[]{} : bodyInputStream.readNBytes(0x200000);
        }
        return bodyInputStream == null ? new byte[]{} : bodyInputStream.readAllBytes();
    }

    private HashMap<String, String> readResponseHeaders(HttpHeaders headers) {
        String length;
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        headers.map().forEach((key, values) -> {
            LOG.debug("Received HTTP header: '{}: {}'", key, values.get(0));
            if (!key.startsWith(":")) {
                responseHeaderMap.put((String)key, (String)values.get(0));
            }
        });
        String serverType = (String)responseHeaderMap.get(HTTP_SERVER);
        if (serverType != null) {
            LOG.debug("Destination Server Type: {}", (Object)serverType);
        }
        if ((length = (String)responseHeaderMap.get(CONTENT_LENGTH)) != null) {
            LOG.debug("expected length of response: {}", (Object)length);
        }
        return responseHeaderMap;
    }

    private String getProxyDomain() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this._messengerConfig.getProxyDomain())) {
                return this._messengerConfig.getProxyDomain() + "\\";
            }
        }
        catch (JAXBException e) {
            LOG.debug(e.getMessage(), e.getCause());
        }
        return "";
    }

    @Override
    public String getDefaultTransferEncoding() {
        return "binary";
    }

    @Override
    public boolean canHandleUri(String uri) {
        if (uri != null) {
            String lower = uri.toLowerCase();
            return lower.startsWith("http:") || lower.startsWith("https:");
        }
        return false;
    }

    @Override
    public boolean isUsingSynchronousProtocol() {
        return true;
    }

    @Override
    public String[] getTransportNames() {
        return NAMES;
    }

    @Override
    public void setMessengerConfig(MessengerConfig messengerConfig) {
        this._messengerConfig = messengerConfig;
    }

    @Override
    public void setActivationProvider(MessengerActivation activationProvider) {
        this.messengerActivation = activationProvider;
    }

    @Override
    public void setXpHttpClientManager(XpHttpClientManager xpHttpClientManager) {
        this.xpHttpClientManager = xpHttpClientManager;
    }
}

