/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.messenger.transport.HttpConnectionPool;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.Destination;

public class HttpConnectionPoolFactory
implements ConnectionPool.Factory {
    private final int maxConnectionsPerDestination;
    private final int maxTotalConnections;
    private final Map<Destination, HttpConnectionPool> connectionPools = new HashMap<Destination, HttpConnectionPool>();

    public HttpConnectionPoolFactory(int maxConnectionsPerDestination, int maxTotalConnections) {
        this.maxConnectionsPerDestination = maxConnectionsPerDestination;
        this.maxTotalConnections = maxTotalConnections;
    }

    public synchronized ConnectionPool newConnectionPool(Destination destination) {
        if (!this.connectionPools.containsKey(destination)) {
            this.connectionPools.put(destination, new HttpConnectionPool(this, destination, this.maxConnectionsPerDestination));
        }
        return (ConnectionPool)this.connectionPools.get(destination);
    }

    public synchronized int getActiveConnectionCount() {
        return this.connectionPools.values().stream().filter(pool -> !pool.isStopped()).mapToInt(AbstractConnectionPool::getActiveConnectionCount).sum();
    }

    public synchronized int getIdleConnectionCount() {
        return this.connectionPools.values().stream().filter(pool -> !pool.isStopped()).mapToInt(AbstractConnectionPool::getIdleConnectionCount).sum();
    }

    boolean isMaxTotalConnectionsCountReached() {
        return this.getActiveConnectionCount() >= this.maxTotalConnections;
    }

    int getMaxTotalConnectionCount() {
        return this.maxTotalConnections;
    }

    public void resetConnections() throws Exception {
        for (HttpConnectionPool pool : this.connectionPools.values()) {
            pool.stop();
        }
        this.connectionPools.clear();
    }
}

