/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.xmlpipe.config.uiconfig.OptionType;
import de.pontonconsulting.xmlpipe.security.XpWSSecurity;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.util.List;

public class AS4UIOptions {
    public static final String PACKAGE_ID = "AS4";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String OPTION_VALUE_UNSIGNED = "unsigned";
    public static final String OPTION_VALUE_SHA1 = "rsa-sha1";
    public static final String OPTION_VALUE_SHA256 = "rsa-sha256";
    public static final String OPTION_VALUE_SHA512 = "rsa-sha512";
    public static final String OPTION_VALUE_ECDSA_SHA1 = "ecdsa-sha1";
    public static final String OPTION_VALUE_ECDSA_SHA256 = "ecdsa-sha256";
    public static final String OPTION_VALUE_ECDSA_SHA512 = "ecdsa-sha512";
    public static final String OPTION_ENC_TRIPLE_DES = "tripledes-cbc";
    public static final String OPTION_ENC_AES_128 = "aes128-cbc";
    public static final String OPTION_ENC_AES_128_GCM = "aes128-gcm";
    public static final String OPTION_ENC_AES_256 = "aes256-cbc";
    public static final String OPTION_ENC_AES_256_GCM = "aes256-gcm";
    public static final String OPTION_VALUE_ISSUER_AND_SERIAL_NUMBER = "IssuerAndSerialNumber";
    public static final String OPTION_VALUE_BINARY_SECURITY_TOKEN = "BinarySecurityToken";
    public static final String OPTION_VALUE_BINARY_SECURITY_TOKEN_PKIPATH = "BinarySecurityTokenPkiPath";
    public static final String OPTION_VALUE_KEY_IDENTIFIER = "SubjectKeyIdentifier";
    public static final String ROLE_FROM = "/RoleFrom";
    public static final String ROLE_TO = "/RoleTo";
    public static final String SERVICE = "/Service";
    public static final String SERVICE_TYPE = "/Service/Type";
    public static final String ACTION = "/Action";
    public static final String AGREEMENT_REF = "/AgreementRef";
    public static final String AGREEMENT_REF_TYPE = "/AgreementRef/Type";
    public static final String CID = "/CID";
    public static final String AGREEMENT_REF_PMODE = "/AgreementRef/PMode";
    public static final String INCLUDE_MESSAGE_PROPERTIES = "/IncludeMessageProperties";
    public static final String INCLUDE_CONTENT_PROPERTIES = "/IncludeContentProperties";
    public static final String CERTIFICATE_UPDATE = "/CertificateUpdate";
    public static final String SIGN_MESSAGE = "/SignMessage";
    public static final String SIGN_MESSAGE_KEY_INFO = "/SignMessage/KeyInfo";
    public static final String ENCRYPT_MESSAGE = "/EncryptMessage";
    public static final String ENCRYPT_MESSAGE_KEY_INFO = "/EncryptMessage/KeyInfo";
    public static final String ENCRYPT_MESSAGE_KEY_ENCRYPTION = "/EncryptMessage/KeyEncryption";
    public static final String COMPRESS_CONTENT = "/CompressContent";
    public static final String EXPECT_RECEIPT = "/ExpectReceipt";
    public static final String EXPECT_SIGNED_MESSAGE = "/ExpectSignedMessage";
    public static final String EXPECT_ENCRYPTED_MESSAGE = "/ExpectEncryptedMessage";
    public static final String EXPECT_COMPRESSED_CONTENT = "/ExpectCompressedContent";
    public static final String SEND_RECEIPT = "/SendReceipt";
    public static final String SEND_RECEIPT_KEY_INFO = "/SendReceipt/KeyInfo";
    public static final String SYNC_REPLY = "/SendReceipt/SyncReply";
    public static final String DUPLICATE_ELIMINATION = "/DuplicateElimination";
    public static final String EMPTY_CONVERSATION_ID = "/EmptyConversationId";
    private final UIConfig _uiConfig;
    private final UIOption[] _uiOptions;
    private final String _defaultAction;
    private final String _defaultService;
    public static final List<String> BIDIREKTIONAL_AS4_OPTIONS = List.of("/AgreementRef", "/AgreementRef/Type", "/CertificateUpdate");

    public AS4UIOptions(UIConfig uiConfig) {
        this._uiConfig = uiConfig;
        this._defaultAction = this.getDefaultOptionValue(PACKAGE_ID, ACTION);
        this._defaultService = this.getDefaultOptionValue(PACKAGE_ID, SERVICE);
        this._uiOptions = this.initUIOptions();
    }

    private String getDefaultOptionValue(String packageId, String optionPath) {
        OptionType optionType = this._uiConfig.getPackageOptionConfig(packageId, optionPath);
        if (optionType != null) {
            return optionType.getDefaultValue();
        }
        return null;
    }

    private UIOption[] initUIOptions() {
        UIOption roleFrom = new UIOption("packagingOption.as4.role_from", ROLE_FROM, "string", "", "hilfe_header_rolefrom", "packagingOption.as4.role_from", "packagingOption.agreement.help.as4.role_from", null, UIOption.NONE, false, false);
        roleFrom.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption roleTo = new UIOption("packagingOption.as4.role_to", ROLE_TO, "string", "", "hilfe_header_roleto", "packagingOption.as4.role_to", "packagingOption.agreement.help.as4.role_to", null, UIOption.NONE, false, false);
        roleTo.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption service = new UIOption("packagingOption.as4.service", SERVICE, "string", this._defaultService, "hilfe_header_service", "packagingOption.as4.service", "packagingOption.agreement.help.as4.service", "packagingOption.profile.help.as4.service", UIOption.NONE, false, false);
        service.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption serviceType = new UIOption("packagingOption.as4.service_type", SERVICE_TYPE, "string", "", "hilfe_header_servicetype", "packagingOption.as4.service_type", "packagingOption.agreement.help.as4.service_type", "packagingOption.profile.help.as4.service_type", UIOption.NONE, false, false);
        serviceType.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption action = new UIOption("packagingOption.as4.action", ACTION, "string", this._defaultAction, "hilfe_header_action", "packagingOption.as4.action", "packagingOption.agreement.help.as4.action", "packagingOption.profile.help.as4.action", UIOption.NONE, false, false);
        action.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption agreementRef = new UIOption("packagingOption.as4.agreement_ref", AGREEMENT_REF, "string", "", "hilfe_header_agreementref", "packagingOption.as4.agreement_ref", "packagingOption.agreement.help.as4.agreement_ref", "packagingOption.profile.help.as4.agreement_ref", UIOption.NONE, false, false);
        agreementRef.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption agreementRefType = new UIOption("packagingOption.as4.agreement_ref_type", AGREEMENT_REF_TYPE, "string", "", "hilfe_header_agreementreftype", "packagingOption.as4.agreement_ref_type", "packagingOption.agreement.help.as4.agreement_ref_type", "packagingOption.profile.help.as4.agreement_ref_type", UIOption.NONE, false, false);
        agreementRefType.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption cid = new UIOption("packagingOption.as4.cid", CID, "string", "", "hilfe_header_cid", "packagingOption.as4.cid", "packagingOption.agreement.help.as4.cid", "packagingOption.profile.help.as4.cid", UIOption.NONE, false, false);
        cid.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption includeMessageProperties = new UIOption("packagingOption.as4.include_message_properties", INCLUDE_MESSAGE_PROPERTIES, "boolean", TRUE, "hilfe_header_includemessageproperties", "packagingOption.as4.include_message_properties", "packagingOption.agreement.help.as4.include_message_properties", "packagingOption.profile.help.as4.include_message_properties", UIOption.NONE);
        includeMessageProperties.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption includeContentProperties = new UIOption("packagingOption.as4.include_content_properties", INCLUDE_CONTENT_PROPERTIES, "boolean", TRUE, "hilfe_header_includecontentproperties", "packagingOption.as4.include_content_properties", "packagingOption.agreement.help.as4.include_content_properties", "packagingOption.profile.help.as4.include_content_properties", UIOption.NONE);
        includeContentProperties.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption certificateUpdate = new UIOption("packagingOption.as4.certificate_update", CERTIFICATE_UPDATE, "boolean", FALSE, "hilfe_header_certificate_update", "packagingOption.as4.certificate_update", "packagingOption.agreement.help.as4.certificate_update", "packagingOption.profile.help.as4.certificate_update", UIOption.NONE);
        certificateUpdate.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        StringBuilder signOptions = new StringBuilder();
        signOptions.append(OPTION_VALUE_SHA1);
        signOptions.append(",");
        signOptions.append(OPTION_VALUE_SHA256);
        signOptions.append(",");
        signOptions.append(OPTION_VALUE_SHA512);
        signOptions.append(",");
        signOptions.append(OPTION_VALUE_ECDSA_SHA1);
        signOptions.append(",");
        signOptions.append(OPTION_VALUE_ECDSA_SHA256);
        signOptions.append(",");
        signOptions.append(OPTION_VALUE_ECDSA_SHA512);
        UIOption signMessage = new UIOption("packagingOption.as4.sign_message", SIGN_MESSAGE, "list", signOptions.toString(), "hilfe_header_signmessage", "packagingOption.as4.sign_message", "packagingOption.agreement.help.as4.sign_message", "packagingOption.profile.help.as4.sign_message", UIOption.NONE, OPTION_VALUE_SHA512, "senderCertificate");
        signMessage.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        StringBuilder keyInfoOptions = new StringBuilder();
        keyInfoOptions.append(OPTION_VALUE_ISSUER_AND_SERIAL_NUMBER);
        keyInfoOptions.append(",");
        keyInfoOptions.append(OPTION_VALUE_BINARY_SECURITY_TOKEN);
        keyInfoOptions.append(",");
        keyInfoOptions.append(OPTION_VALUE_BINARY_SECURITY_TOKEN_PKIPATH);
        keyInfoOptions.append(",");
        keyInfoOptions.append(OPTION_VALUE_KEY_IDENTIFIER);
        UIOption signMessageKeyInfo = new UIOption("packagingOption.as4.sign_message_key_info", SIGN_MESSAGE_KEY_INFO, "list", keyInfoOptions.toString(), "hilfe_header_signmessagekeyinfo", "packagingOption.as4.sign_message_key_info", "packagingOption.agreement.help.as4.sign_message_key_info", "packagingOption.profile.help.as4.sign_message_key_info", UIOption.NONE, OPTION_VALUE_ISSUER_AND_SERIAL_NUMBER);
        signMessageKeyInfo.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        StringBuilder encryptionOptions = new StringBuilder();
        encryptionOptions.append(OPTION_ENC_TRIPLE_DES);
        encryptionOptions.append(",");
        encryptionOptions.append(OPTION_ENC_AES_128);
        encryptionOptions.append(",");
        encryptionOptions.append(OPTION_ENC_AES_256);
        encryptionOptions.append(",");
        encryptionOptions.append(OPTION_ENC_AES_128_GCM);
        encryptionOptions.append(",");
        encryptionOptions.append(OPTION_ENC_AES_256_GCM);
        UIOption encryptMessage = new UIOption("packagingOption.as4.encrypt_message", ENCRYPT_MESSAGE, "list", encryptionOptions.toString(), "hilfe_header_encryptmessage", "packagingOption.as4.encrypt_message", "packagingOption.agreement.help.as4.encrypt_message", "packagingOption.profile.help.as4.encrypt_message", UIOption.NONE, OPTION_ENC_AES_256_GCM, "receiverCertificate");
        encryptMessage.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption encryptMessageKeyInfo = new UIOption("packagingOption.as4.encrypt_message_key_info", ENCRYPT_MESSAGE_KEY_INFO, "list", keyInfoOptions.toString(), "hilfe_header_encryptmessagekeyinfo", "packagingOption.as4.encrypt_message_key_info", "packagingOption.agreement.help.as4.encrypt_message_key_info", "packagingOption.profile.help.as4.encrypt_message_key_info", UIOption.NONE, OPTION_VALUE_ISSUER_AND_SERIAL_NUMBER);
        encryptMessageKeyInfo.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        StringBuilder keyEncAlgoOptions = new StringBuilder();
        XpWSSecurity.keyEncAlgoToKeyEncAlgoObject.keySet().forEach(key -> {
            keyEncAlgoOptions.append(",");
            keyEncAlgoOptions.append((String)key);
        });
        String keyEncAlgoOptionsAsList = keyEncAlgoOptions.toString().replaceFirst(",", "");
        UIOption encryptMessageEncryptKey = new UIOption("packagingOption.as4.encrypt_message_encrypt_key", ENCRYPT_MESSAGE_KEY_ENCRYPTION, "list", keyEncAlgoOptionsAsList, "hilfe_header_encryptmessageencryptkey", "packagingOption.as4.encrypt_message_encrypt_key", "packagingOption.agreement.help.as4.encrypt_message_encrypt_key", "packagingOption.profile.help.as4.encrypt_message_encrypt_key", UIOption.NONE, "rsa-oaep");
        encryptMessageEncryptKey.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption compressContent = new UIOption("packagingOption.as4.compress_content", COMPRESS_CONTENT, "boolean", TRUE, "hilfe_header_compresscontent", "packagingOption.as4.compress_content", "packagingOption.agreement.help.as4.compress_content", "packagingOption.profile.help.as4.compress_content", UIOption.NONE, TRUE);
        compressContent.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        StringBuilder ackSignOtion = new StringBuilder();
        ackSignOtion.append(OPTION_VALUE_UNSIGNED);
        ackSignOtion.append(",");
        ackSignOtion.append((CharSequence)signOptions);
        UIOption expectReceipt = new UIOption("packagingOption.as4.expect_receipt", EXPECT_RECEIPT, "list", ackSignOtion.toString(), "hilfe_header_expectreceipt", "packagingOption.as4.expect_receipt", "packagingOption.agreement.help.as4.expect_receipt", "packagingOption.profile.help.as4.expect_receipt", UIOption.NONE, OPTION_VALUE_SHA512, "none");
        expectReceipt.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        expectReceipt.setStandardActive(true);
        UIOption expectSignedMessage = new UIOption("packagingOption.as4.expect_signed_message", EXPECT_SIGNED_MESSAGE, "list", signOptions.toString(), "hilfe_header_expectsignedmessage", "packagingOption.as4.expect_signed_message", "packagingOption.agreement.help.as4.expect_signed_message", "packagingOption.profile.help.as4.expect_signed_message", UIOption.NONE, OPTION_VALUE_SHA512, "none");
        expectSignedMessage.setVisibility(UIOption.VISIBILITY.INBOUND);
        UIOption expectEncryptedMessage = new UIOption("packagingOption.as4.expect_encrypted_message", EXPECT_ENCRYPTED_MESSAGE, "list", encryptionOptions.toString(), "hilfe_header_expectencryptedmessage", "packagingOption.as4.expect_encrypted_message", "packagingOption.agreement.help.as4.expect_encrypted_message", "packagingOption.profile.help.as4.expect_encrypted_message", UIOption.NONE, OPTION_ENC_AES_256_GCM, "none");
        expectEncryptedMessage.setVisibility(UIOption.VISIBILITY.INBOUND);
        UIOption expectCompressedContent = new UIOption("packagingOption.as4.expect_compressed_content", EXPECT_COMPRESSED_CONTENT, "boolean", TRUE, "hilfe_header_expectcompressedcontent", "packagingOption.as4.expect_compressed_content", "packagingOption.agreement.help.as4.expect_compressed_content", "packagingOption.profile.help.as4.expect_compressed_content", UIOption.NONE, TRUE);
        expectCompressedContent.setVisibility(UIOption.VISIBILITY.INBOUND);
        UIOption sendReceipt = new UIOption("packagingOption.as4.send_receipt", SEND_RECEIPT, "list", ackSignOtion.toString(), "hilfe_header_sendreceipt", "packagingOption.as4.send_receipt", "packagingOption.agreement.help.as4.send_receipt", "packagingOption.profile.help.as4.send_receipt", UIOption.NONE, OPTION_VALUE_SHA512, "receiverCertificate");
        sendReceipt.setVisibility(UIOption.VISIBILITY.INBOUND);
        UIOption sendReceiptKeyInfo = new UIOption("packagingOption.as4.send_receipt_key_info", SEND_RECEIPT_KEY_INFO, "list", keyInfoOptions.toString(), "hilfe_header_sendreceiptkeyinfo", "packagingOption.as4.send_receipt_key_info", "packagingOption.agreement.help.as4.send_receipt_key_info", "packagingOption.profile.help.as4.send_receipt_key_info", UIOption.NONE, OPTION_VALUE_ISSUER_AND_SERIAL_NUMBER);
        sendReceiptKeyInfo.setVisibility(UIOption.VISIBILITY.INBOUND);
        UIOption syncReply = new UIOption("packagingOption.as4.sync_reply", SYNC_REPLY, "boolean", TRUE, "hilfe_header_syncreply", "packagingOption.as4.sync_reply", "packagingOption.agreement.help.as4.sync_reply", "packagingOption.profile.help.as4.syncreply", UIOption.NONE, true, true);
        syncReply.setVisibility(UIOption.VISIBILITY.INBOUND);
        UIOption duplicateElimination = new UIOption("packagingOption.as4.duplicate_elimination", DUPLICATE_ELIMINATION, "boolean", TRUE, "hilfe_header_duplicateelimination", "packagingOption.as4.duplicate_elimination", "packagingOption.agreement.help.as4.duplicate_elimination", "packagingOption.profile.help.as4.duplicate_elimination", UIOption.NONE, true);
        duplicateElimination.setVisibility(UIOption.VISIBILITY.INBOUND);
        return new UIOption[]{roleFrom, roleTo, service, serviceType, action, agreementRef, agreementRefType, cid, includeMessageProperties, includeContentProperties, certificateUpdate, signMessage, signMessageKeyInfo, encryptMessage, encryptMessageEncryptKey, encryptMessageKeyInfo, compressContent, expectReceipt, expectSignedMessage, expectEncryptedMessage, expectCompressedContent, sendReceipt, sendReceiptKeyInfo, syncReply, duplicateElimination};
    }

    public UIOption[] getUIOptions() {
        return this._uiOptions;
    }

    public String getDefaultAction() {
        return this._defaultAction;
    }

    public String getDefaultService() {
        return this._defaultService;
    }
}

