/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.schemaset.SchemaSet;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS4PingMessageConverter {
    private static final Logger LOGGER = LogManager.getLogger(AS4PingMessageConverter.class);
    static final String XP_MSG_VERSION_SCHEMA_LOCATION = "https://www.ponton.de/AS4PING";
    public static final String AS4_TEST_ACTION = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test";
    public static final String AS4_TEST_SERVICE = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service";

    public void convertInboundMessage(XpMessage xpMessage) {
        xpMessage.setSchemaSet("ponton");
        xpMessage.setMessageType("PING");
        xpMessage.setMessageVersion("2.1");
        xpMessage.setSchemaLocation(XP_MSG_VERSION_SCHEMA_LOCATION);
        if (this.isAS4UpdateTestMessage(xpMessage)) {
            xpMessage.setAdapterId("AS4CertificateUpdateAdapter");
        } else {
            xpMessage.setStoreMessageInQueue(false);
        }
    }

    public boolean isAS4UpdateTestMessage(XpMessage xpMessage) {
        String as4UpdatedAgreementRef = xpMessage.getAgreement().getAS4UpdatedAgreementRef();
        String agreementRef = xpMessage.getProcessingDirective("agreementRef");
        return agreementRef != null && agreementRef.equals(as4UpdatedAgreementRef);
    }

    public void convertOutboundMessage(XpMessage xpMessage) {
        xpMessage.setSchemaSet("ponton");
        xpMessage.setMessageType("PING");
        xpMessage.setMessageVersion("2.1");
        xpMessage.setSchemaLocation(XP_MSG_VERSION_SCHEMA_LOCATION);
        if (xpMessage.getCurrentContentReference() == null) {
            xpMessage.setCurrentContentType("text/xml");
            try {
                File file = new File(xpMessage.getCurrentContentReferenceFolder(), "as4ping.xml");
                Files.write(file.toPath(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><AS4PingMessage/>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                xpMessage.setCurrentContentReference(file);
            }
            catch (IOException e) {
                LOGGER.error("Cannot write to temp file for as4 ping", (Throwable)e);
            }
        }
    }

    SchemaData generateAS4PingSchema() {
        SchemaSet.Schema.PackagingParameters packagingParameters = new SchemaSet.Schema.PackagingParameters();
        packagingParameters.setAction(AS4_TEST_ACTION);
        packagingParameters.setService(AS4_TEST_SERVICE);
        SchemaData as4PingSchemaData = new SchemaData();
        as4PingSchemaData.setName("PING");
        as4PingSchemaData.setMessageType("PING");
        as4PingSchemaData.setMessageVersion("2.1");
        as4PingSchemaData.setDisplayName("PING");
        as4PingSchemaData.setSchemaSetName("ponton");
        as4PingSchemaData.setPackagingParameters(packagingParameters);
        as4PingSchemaData.setNamespace("");
        return as4PingSchemaData;
    }
}

