/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import java.util.HashMap;
import java.util.Map;

public class AS4Error {
    public static final AS4Error EBMS_0001 = new AS4Error("EBMS:0001", "ValueNotRecognized", ErrorCategory.Content, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0002 = new AS4Error("EBMS:0002", "FeatureNotSupported", ErrorCategory.Content, ErrorSeverity.warning, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0003 = new AS4Error("EBMS:0003", "ValueInconsistent", ErrorCategory.Content, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0004 = new AS4Error("EBMS:0004", "Other", ErrorCategory.Content, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0005 = new AS4Error("EBMS:0005", "ConnectionFailure", ErrorCategory.Communication, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0006 = new AS4Error("EBMS:0006", "EmptyMessagePartitionChannel", ErrorCategory.Communication, ErrorSeverity.warning, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0007 = new AS4Error("EBMS:0007", "MimeInconsistency", ErrorCategory.Unpackaging, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0008 = new AS4Error("EBMS:0008", "FeatureNotSupported", ErrorCategory.Unpackaging, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0009 = new AS4Error("EBMS:0009", "InvalidHeader", ErrorCategory.Unpackaging, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0010 = new AS4Error("EBMS:0010", "ProcessingModeMismatch", ErrorCategory.Processing, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0011 = new AS4Error("EBMS:0011", "ExternalPayloadError", ErrorCategory.Content, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0101 = new AS4Error("EBMS:0101", "FailedAuthentication", ErrorCategory.Processing, ErrorSeverity.failure, ErrorOrigin.security);
    public static final AS4Error EBMS_0102 = new AS4Error("EBMS:0102", "FailedDecryption", ErrorCategory.Processing, ErrorSeverity.failure, ErrorOrigin.security);
    public static final AS4Error EBMS_0103 = new AS4Error("EBMS:0103", "PolicyNoncompliance", ErrorCategory.Processing, ErrorSeverity.failure, ErrorOrigin.security);
    public static final AS4Error EBMS_0201 = new AS4Error("EBMS:0201", "DysfunctionalReliability", ErrorCategory.Processing, ErrorSeverity.failure, ErrorOrigin.reliability);
    public static final AS4Error EBMS_0202 = new AS4Error("EBMS:0202", "DeliveryFailure", ErrorCategory.Communication, ErrorSeverity.failure, ErrorOrigin.reliability);
    public static final AS4Error EBMS_0301 = new AS4Error("EBMS:0301", "MissingReceipt", ErrorCategory.Communication, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0302 = new AS4Error("EBMS:0302", "InvalidReceipt", ErrorCategory.Communication, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error EBMS_0303 = new AS4Error("EBMS:0303", "DecompressionFailure", ErrorCategory.Communication, ErrorSeverity.failure, ErrorOrigin.ebMS);
    public static final AS4Error UNDEFINED = new AS4Error("EBMS:9999", "Undefined", ErrorCategory.Communication, ErrorSeverity.failure, ErrorOrigin.ebMS);
    private static final Map<String, AS4Error> ERROR_CODE_MAP = new HashMap<String, AS4Error>();
    private final String errorCode;
    private final String shortDescription;
    private final ErrorCategory category;
    private final ErrorSeverity severity;
    private final ErrorOrigin origin;

    public static AS4Error getAS4Error(String errorCode) {
        return ERROR_CODE_MAP.get(errorCode);
    }

    private AS4Error(String errorCode, String shortDescription, ErrorCategory category, ErrorSeverity severity, ErrorOrigin origin) {
        this.errorCode = errorCode;
        this.shortDescription = shortDescription;
        this.category = category;
        this.severity = severity;
        this.origin = origin;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public ErrorCategory getCategory() {
        return this.category;
    }

    public ErrorSeverity getSeverity() {
        return this.severity;
    }

    public ErrorOrigin getOrigin() {
        return this.origin;
    }

    public String toString() {
        return "AS4Error{errorCode='" + this.errorCode + "', origin=" + String.valueOf((Object)this.origin) + ", category=" + String.valueOf((Object)this.category) + ", severity=" + String.valueOf((Object)this.severity) + ", shortDescription='" + this.shortDescription + "'}";
    }

    static {
        ERROR_CODE_MAP.put(EBMS_0001.getErrorCode(), EBMS_0001);
        ERROR_CODE_MAP.put(EBMS_0002.getErrorCode(), EBMS_0002);
        ERROR_CODE_MAP.put(EBMS_0003.getErrorCode(), EBMS_0003);
        ERROR_CODE_MAP.put(EBMS_0004.getErrorCode(), EBMS_0004);
        ERROR_CODE_MAP.put(EBMS_0005.getErrorCode(), EBMS_0005);
        ERROR_CODE_MAP.put(EBMS_0006.getErrorCode(), EBMS_0006);
        ERROR_CODE_MAP.put(EBMS_0007.getErrorCode(), EBMS_0007);
        ERROR_CODE_MAP.put(EBMS_0008.getErrorCode(), EBMS_0008);
        ERROR_CODE_MAP.put(EBMS_0009.getErrorCode(), EBMS_0009);
        ERROR_CODE_MAP.put(EBMS_0010.getErrorCode(), EBMS_0010);
        ERROR_CODE_MAP.put(EBMS_0011.getErrorCode(), EBMS_0011);
        ERROR_CODE_MAP.put(EBMS_0101.getErrorCode(), EBMS_0101);
        ERROR_CODE_MAP.put(EBMS_0102.getErrorCode(), EBMS_0102);
        ERROR_CODE_MAP.put(EBMS_0103.getErrorCode(), EBMS_0103);
        ERROR_CODE_MAP.put(EBMS_0201.getErrorCode(), EBMS_0201);
        ERROR_CODE_MAP.put(EBMS_0202.getErrorCode(), EBMS_0202);
        ERROR_CODE_MAP.put(EBMS_0303.getErrorCode(), EBMS_0303);
    }

    public static enum ErrorCategory {
        Content,
        Communication,
        Unpackaging,
        Processing;

    }

    public static enum ErrorSeverity {
        warning,
        failure;

    }

    public static enum ErrorOrigin {
        ebMS,
        reliability,
        security;

    }
}

