/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.validate;

import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import de.pontonconsulting.xmlpipe.message.StAXXPath;
import de.pontonconsulting.xmlpipe.message.XmlParser;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.SchemaResolver;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationErrorHandler;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationException;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlValidator
extends BaseFilterPlugin
implements IFilterPlugin {
    private static final String NAMESPACE_GROWTH = "http://apache.org/xml/features/namespace-growth";
    private static final String[] ACCEPTED_CONTENT_TYPES = new String[]{"application/xml", "text/xml"};
    private final HashMap<String, Schema> _grammarPool;
    private final SAXParserFactory _saxParserFactory;
    private final SchemataConfig _schemataConfig;
    private final ConfigResourceService _configResourceService;

    public XmlValidator(SchemataConfig schemataConfig, MessengerLog messengerLog, ConfigResourceService configResourceService) throws BaseFilterException {
        super("XmlValidationFilter", messengerLog);
        this._schemataConfig = schemataConfig;
        this._configResourceService = configResourceService;
        this._grammarPool = new HashMap();
        this._saxParserFactory = SAXParserFactory.newInstance();
        this._saxParserFactory.setNamespaceAware(true);
    }

    @Override
    public void doFilter(XpMessage message) throws ValidationException {
        boolean errorLogged = false;
        SchemaData schema = null;
        ValidationErrorHandler errorHandler = null;
        XMLReader xmlReader = null;
        try {
            errorHandler = new ValidationErrorHandler();
            xmlReader = this._saxParserFactory.newSAXParser().getXMLReader();
            if ("BINARY".equals(message.getMessageType()) && "1".equals(message.getMessageVersion()) && "BINARY".equals(message.getSchemaSet())) {
                this._log.debug("BINARY messages could not be validated.");
                this.messageLog(9, message.getDatabaseId(), message.getMessageId(), "BINARY messages could not be validated.");
                return;
            }
            schema = this._schemataConfig.getSchemaBySetTypeVersion(message.getSchemaSet(), message.getMessageType(), message.getMessageVersion());
            if (schema == null) {
                throw new ValidationException(20001, new String[]{message.getSchemaLocation()}, "No active SchemaSet includes Schema for: " + message.getSchemaLocation());
            }
            if (!schema.isValidateable()) {
                this._log.debug("Schema information found - validation disabled for this schemaset.");
                StringBuilder output = new StringBuilder();
                output.append('(');
                output.append(schema.getDisplayName());
                output.append('/');
                output.append(schema.getSchemaSetName());
                if (message.getXpEnvelopeName() != null && message.getXpEnvelopeName().trim().length() > 0) {
                    output.append("; Envelope:");
                    output.append(message.getXpEnvelopeName());
                }
                output.append(')');
                this.messageLog(9, message.getDatabaseId(), message.getMessageId(), output.toString());
                return;
            }
            File schemaLocation = schema.getSchemaFile();
            if (message.getXpEnvelopeSchemaFile() != null) {
                this._log.debug("Will use Envelope for validation: {}", (Object)message.getXpEnvelopeSchemaFile());
            }
            this._log.debug("Will use Schema for validation: {}", (Object)schemaLocation);
            for (AdditionalSchema additionalSchema : schema.getAdditionalSchemata()) {
                if (additionalSchema.getNamespace() != null && additionalSchema.getNamespace().length() > 0) {
                    this._log.debug("Will use additional Schema for validation of namespace '{}': {}", (Object)additionalSchema.getNamespace(), (Object)additionalSchema.getFile());
                    continue;
                }
                this._log.debug("Will use additional Schema for validation: {}", (Object)additionalSchema.getFile());
            }
            this.checkRootElement(message, schema);
            this.checkMarkerElement(message, schema);
            Schema xmlSchema = this.getSchema(message, schema);
            ValidatorHandler validatorHandler = xmlSchema.newValidatorHandler();
            validatorHandler.setErrorHandler(errorHandler);
            errorHandler.reset();
            xmlReader.setContentHandler(validatorHandler);
            xmlReader.setEntityResolver(new PontonEntityResolver());
            long start = System.currentTimeMillis();
            try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0]));){
                xmlReader.parse(new InputSource(stream));
            }
            long end = System.currentTimeMillis();
            if (this._log.isTraceEnabled()) {
                this._log.trace("time for xml validation {} ms", (Object)(end - start));
            }
            ValidationResult[] errors = errorHandler.getResult();
            StringBuilder output = new StringBuilder();
            if (errors.length != 0) {
                StringBuilder logValue = new StringBuilder();
                logValue.append('(');
                logValue.append(schema.getDisplayName());
                logValue.append('/');
                logValue.append(schema.getSchemaSetName());
                if (message.getXpEnvelopeName() != null && message.getXpEnvelopeName().trim().length() > 0) {
                    logValue.append("; Envelope:");
                    logValue.append(message.getXpEnvelopeName());
                }
                logValue.append(')');
                this.messageLog(508, message.getDatabaseId(), message.getMessageId(), logValue.toString());
                errorLogged = true;
                for (int i = 0; i < errors.length && i < errorHandler.getDefaultMaxErrorCount(); ++i) {
                    output.append(errors[i].getLevelText());
                    output.append(" (Line: ");
                    output.append(errors[i].getLine());
                    output.append(" / Column:");
                    output.append(errors[i].getColumn());
                    output.append(" ) ");
                    output.append(errors[i].getDescription());
                    this._log.warn(output.toString());
                    this.messageLog(523, message.getDatabaseId(), message.getMessageId(), output.toString());
                    output.setLength(0);
                }
                if (errorHandler.getErrorCount() > errorHandler.getDefaultMaxErrorCount()) {
                    String overflow = "There were " + errors.length + " errors in the XML. Only the first " + errorHandler.getDefaultMaxErrorCount() + " are shown";
                    this._log.warn(overflow);
                    this.messageLog(523, message.getDatabaseId(), message.getMessageId(), overflow);
                }
                throw new ValidationException(20000, errors, errors.length + " XML errors found while validating with " + String.valueOf(logValue));
            }
            output.append('(');
            output.append(schema.getDisplayName());
            output.append('/');
            output.append(schema.getSchemaSetName());
            if (message.getXpEnvelopeName() != null && message.getXpEnvelopeName().trim().length() > 0) {
                output.append("; Envelope:");
                output.append(message.getXpEnvelopeName());
            }
            output.append(')');
            message.setCurrentContentType("text/xml");
            this.messageLog(61, message.getDatabaseId(), message.getMessageId(), output.toString());
            if (this._log.isInfoEnabled()) {
                this._log.info("Message successfully validated");
            }
        }
        catch (ValidationException e) {
            if (!errorLogged) {
                this.messageLog(508, message.getDatabaseId(), message.getMessageId(), e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            String schemaLogText = "unknown message type";
            if (schema != null) {
                schemaLogText = schema.getDisplayName();
            }
            this.messageLog(508, message.getDatabaseId(), message.getMessageId(), " error while validating " + schemaLogText);
            this._log.fatal("Undefined Error while validating XML: {}", (Object)e.getMessage());
            throw new ValidationException(20004, e.toString());
        }
    }

    private void checkMarkerElement(XpMessage xpMessage, SchemaData schema) throws IOException, ValidationException, XmlParser.XmlParserException {
        if (schema.getMessageTypeMarkerXPath() != null && schema.getMessageTypeMarkerValue() != null) {
            try (InputStream inputStream = Files.newInputStream(xpMessage.getCurrentContentReference().toPath(), new OpenOption[0]);){
                StAXXPath xpath = new StAXXPath(xpMessage.getPayloadXPath() + schema.getMessageTypeMarkerXPath());
                Map<StAXXPath, String> xpathLookup = new XmlParser().parse(inputStream, List.of(xpath));
                String foundValue = xpathLookup.get(xpath);
                if (!schema.getMessageTypeMarkerValue().equals(foundValue)) {
                    throw new ValidationException(-1, "The payload has unexpected message type marker (" + foundValue + ") as defined in the schemaset (" + schema.getMessageTypeMarkerValue() + ").");
                }
            }
        }
    }

    private void checkRootElement(XpMessage message, SchemaData schema) throws ValidationException {
        if (Objects.isNull(message.getPayloadRootElement())) {
            message.recognizePayload(true);
        }
        Object schemaRootElement = schema.getRootElement();
        if (StringUtils.isNotEmpty((CharSequence)schema.getNamespace())) {
            schemaRootElement = schema.getNamespace() + ":" + (String)schemaRootElement;
        }
        Object payloadRootElement = message.getPayloadRootElement();
        if (StringUtils.isNotEmpty((CharSequence)message.getPayloadNamespaceUri())) {
            payloadRootElement = message.getPayloadNamespaceUri() + ":" + (String)payloadRootElement;
        }
        if (!((String)schemaRootElement).equals(payloadRootElement)) {
            throw new ValidationException(-1, "The payload has unexpected root element (" + (String)payloadRootElement + ") as defined in the schemaset (" + (String)schemaRootElement + ").");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getSchema(XpMessage message, SchemaData schemaData) throws SAXException {
        if (this._schemataConfig.getReinitGrammarPool()) {
            HashMap<String, Schema> hashMap = this._grammarPool;
            synchronized (hashMap) {
                this._grammarPool.clear();
            }
            this._schemataConfig.setReinitGrammarPool(false);
        }
        String grammarKey = message.getSchemaSet() + "_" + message.getMessageType() + "_" + message.getMessageVersion();
        if (message.getXpEnvelopeName() != null) {
            grammarKey = grammarKey + "_" + message.getXpEnvelopeName();
        }
        Schema schema = null;
        HashMap<String, Schema> hashMap = this._grammarPool;
        synchronized (hashMap) {
            schema = this._grammarPool.get(grammarKey);
            if (schema == null) {
                List<Source> schemas = this.lookupSchemaFiles(message, schemaData);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                try {
                    SchemaResolver resolver = new SchemaResolver(this._configResourceService, schemaData.getSchemaFile().getParent());
                    schemaFactory.setResourceResolver(resolver);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    this._log.error("could not create SchemaResolver: {}", (Object)e.getMessage());
                    throw new SAXException(e);
                }
                schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                schemaFactory.setFeature(NAMESPACE_GROWTH, true);
                schema = schemaFactory.newSchema(schemas.toArray(new Source[0]));
                this._grammarPool.put(grammarKey, schema);
                if (this._log.isDebugEnabled()) {
                    this._log.debug("new grammar pool for {}", (Object)grammarKey);
                    this._log.debug("grammars count in cache {}", (Object)this._grammarPool.size());
                }
            } else if (this._log.isTraceEnabled()) {
                this._log.trace("fetched grammar {}", (Object)grammarKey);
            }
        }
        return schema;
    }

    private List<Source> lookupSchemaFiles(XpMessage message, SchemaData schemaData) {
        ArrayList<Source> schemas = new ArrayList<Source>();
        try {
            if (message.getXpEnvelopeSchemaFile() != null) {
                schemas.add(this.getSource(message.getXpEnvelopeSchemaFile().getPath()));
            }
            schemas.add(this.getSource(schemaData.getSchemaFile().getPath()));
            for (AdditionalSchema additionalSchema : schemaData.getAdditionalSchemata()) {
                schemas.add(this.getSource(additionalSchema.getFile().getPath()));
            }
        }
        catch (IOException e) {
            this._log.error("could not load required schema files: {}", (Object)e.toString());
        }
        return schemas;
    }

    private Source getSource(String path) throws IOException {
        return new StreamSource(this._configResourceService.getResource(path).getValue());
    }

    @Override
    public String getOptionValue() {
        return "";
    }

    public String[] getAcceptedContentTypes() {
        return ACCEPTED_CONTENT_TYPES;
    }

    static class PontonEntityResolver
    implements EntityResolver {
        PontonEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

