/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.common.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEUnknownSignCertificateExeption;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEValidationException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifier;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifyResult;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.util.SharedFileInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Set;

public abstract class SMIMEVerify
extends BaseFilterPlugin {
    protected final CertificateUtility _certificateUtility;
    private final SMIMEVerifier _smimeVerifier;
    private final RegistryProfileUpdater registryProfileUpdater;

    public SMIMEVerify(String pluginName, CertificateUtility certificateUtility, SMIMEVerifier smimeVerifier, RegistryProfileUpdater registryProfileUpdater, MessengerLog messengerLog) {
        super(pluginName, messengerLog);
        this._certificateUtility = certificateUtility;
        this._smimeVerifier = smimeVerifier;
        this.registryProfileUpdater = registryProfileUpdater;
    }

    protected void handleSMIME(XpMessage message) throws SignatureException {
        CppPartner sender;
        String payloadFilename;
        try {
            payloadFilename = this.updateCurrentPayloadFilename(message, true);
        }
        catch (IOException e) {
            throw new SignatureException(19008, new String[0], e);
        }
        try {
            sender = message.getSender();
        }
        catch (ProfileException pe) {
            throw new SignatureException(23002, new String[]{message.getSenderLocalId()}, pe);
        }
        try {
            this.verifySmimeSignatureWithGivenProfile(message, payloadFilename, sender);
        }
        catch (SMIMEUnknownSignCertificateExeption e) {
            this._log.warn(e.getMessage());
            try {
                this.tryToUpdateProfileFromRegistryAndRevalidate(message, payloadFilename, sender, e);
            }
            catch (SMIMEUnknownSignCertificateExeption e1) {
                this._log.error("Error while verifing S/MIME signature: {}", (Object)e.toString());
                this.messageLog(504, message.getDatabaseId(), message.getMessageId(), e1.toString());
                throw new SignatureException(19008, "Error while verifing S/MIME signature: " + e1.toString());
            }
        }
    }

    private void tryToUpdateProfileFromRegistryAndRevalidate(XpMessage message, String payloadFilename, CppPartner sender, SMIMEUnknownSignCertificateExeption e) throws SignatureException, SMIMEUnknownSignCertificateExeption {
        CppPartner updated;
        if (sender.isFromRegistry() && sender.isAutoupdate() && (updated = this.registryProfileUpdater.updateProfile(sender)) != null) {
            this._log.debug("verifying signature with new certificates of updated profile");
            this.verifySmimeSignatureWithGivenProfile(message, payloadFilename, updated);
            return;
        }
        throw e;
    }

    private void verifySmimeSignatureWithGivenProfile(XpMessage message, String payloadFilename, CppPartner sender) throws SignatureException, SMIMEUnknownSignCertificateExeption {
        File mimeFile = message.getCurrentContentReference();
        File payloadFile = new File(message.getCurrentContentReferenceFolder(), payloadFilename);
        File signatureFile = new File(message.getCurrentContentReferenceFolder(), sender.getLocalId() + ".cer");
        try (SharedFileInputStream in = new SharedFileInputStream(mimeFile);){
            Set<X509Certificate> senderCerts = sender.getAllCertificates();
            if (senderCerts.isEmpty()) {
                throw new SignatureException(19013, new String[]{sender.getLocalId()}, "No certificates installed for: " + sender.getLocalId());
            }
            MimeMessage msg = new MimeMessage((Session)null, (InputStream)in);
            SMIMEVerifyResult result = this._smimeVerifier.verifySignature((MimePart)msg, senderCerts);
            this.storePayloadAndSignature(message, payloadFile, signatureFile, result);
        }
        catch (SMIMEUnknownSignCertificateExeption e) {
            throw e;
        }
        catch (SMIMEValidationException | MessagingException | IOException e) {
            this._log.error("Error while verifying S/MIME signature: {}", (Object)e.toString());
            this.messageLog(504, message.getDatabaseId(), message.getMessageId(), e.toString());
            throw new SignatureException(19008, "Error while verifying S/MIME signature: " + e.toString());
        }
    }

    private void storePayloadAndSignature(XpMessage message, File payloadFile, File signatureFile, SMIMEVerifyResult result) throws SignatureException, MessagingException, IOException {
        MimeBodyPart bp = result.getBodyPart();
        X509Certificate senderCertificate = result.getSenderCertificate();
        if (bp == null) {
            throw new SignatureException(19007, "no MIME Body-Part exists in content.");
        }
        ContentType contentType = null;
        if (bp.getContentType() != null && bp.getContentType().length() > 0) {
            contentType = new ContentType(bp.getContentType());
        }
        byte[] buffer = new byte[16384];
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(payloadFile.toPath(), new OpenOption[0]));
             InputStream verifiedIn = bp.getInputStream();){
            int count = -1;
            while ((count = verifiedIn.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, count);
            }
        }
        String usingInfoText = this._certificateUtility.toUsingInfoText(senderCertificate, "SMIME signature verified using certificate");
        this.messageLog(71, message.getDatabaseId(), message.getMessageId(), usingInfoText);
        this._log.info(usingInfoText);
        message.setCurrentContentReference(payloadFile);
        message.setCurrentContentType(contentType != null ? contentType.getBaseType() : MimeTypeMapper.getMimeType(payloadFile.getName()));
        this.updateProcessedOriginalFilename(message, true);
        try (BufferedOutputStream out2 = new BufferedOutputStream(Files.newOutputStream(signatureFile.toPath(), new OpenOption[0]));){
            ((OutputStream)out2).write(senderCertificate.getEncoded());
            ((OutputStream)out2).flush();
        }
        catch (IOException | CertificateEncodingException ioe) {
            this._log.warn("sender certificate cannot be written:{}", (Throwable)ioe);
        }
    }

    @Override
    public String getDefaultExtension() {
        return ".p7smime";
    }
}

