/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.common.activation.StreamingDataHandler;
import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.ISigner;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.activation.DataHandler;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.SharedFileInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SMIMESigner
extends BaseFilterPlugin
implements ISigner {
    private static final String[] UNWANTED_MIME_HEADERS = new String[]{"Message-Id", "MIME-Version"};
    public static final String PROCESSING_VALUE = "SMIME-SHA1";
    public static final String OPTION_VALUE_SMIME = "SMIME-SHA1";
    private final CertificateUtility _certificateUtility;
    private final de.pontonconsulting.xmlpipe.security.smime.SMIMESigner _smimeSigner;

    public SMIMESigner(CertificateUtility certificateUtility, de.pontonconsulting.xmlpipe.security.smime.SMIMESigner smimeSigner, MessengerLog messengerLog) throws BaseFilterException {
        super("SMIMESigner", messengerLog);
        this._certificateUtility = certificateUtility;
        this._smimeSigner = smimeSigner;
    }

    @Override
    public void doFilter(XpMessage message) throws BaseFilterException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("S/MIME signature will be created.");
        }
        String localId = message.getCommunication().getSenderLocalId();
        PrivateKey privateKey = null;
        Certificate[] certificateChain = null;
        SignCertInfo signCertInfo = new SignCertInfo(null, null, null);
        try {
            signCertInfo = message.getCommunication().getProcessingSignKey();
        }
        catch (ProfileException | CertificateException e) {
            this._log.error("Error while creating S/MIME signature: {}", (Object)e.getMessage());
            this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.getMessage());
            throw new SignatureException(19004, "Error while creating S/MIME signature: " + e.getMessage());
        }
        privateKey = signCertInfo.getPrivateKey();
        certificateChain = signCertInfo.getCertificateChain();
        SharedFileInputStream masterStream = null;
        try {
            if (certificateChain == null) {
                this._log.fatal("Certificate for localid: {} is not installed", (Object)localId);
                throw new SignatureException(19003, new String[]{localId}, "Certificate for localid: " + localId + " is not installed");
            }
            if (privateKey == null) {
                throw new SignatureException(19002, new String[]{localId}, "Private Key for local Id: '" + localId + "' is missing");
            }
            this.updateProcessedOriginalFilename(message, false);
            File fileOut = new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + this.getDefaultExtension());
            try (SimpleFileDataSource payloadSource = new SimpleFileDataSource(message.getCurrentContentType(), message.getCurrentContentReference());
                 BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(fileOut.toPath(), new OpenOption[0]));){
                MimeBodyPart bp = new MimeBodyPart();
                masterStream = (SharedFileInputStream)payloadSource.getInputStream();
                StreamingDataHandler handler = new StreamingDataHandler(payloadSource);
                bp.setDataHandler((DataHandler)handler);
                ContentDisposition disposition = new ContentDisposition("inline");
                disposition.setParameter("filename", message.getCurrentContentReference().getName());
                bp.setDisposition(disposition.toString());
                MimeMultipart signedMultiPart = this._smimeSigner.createSignedMimeMessage(bp, null, privateKey, certificateChain, "SHA1withRSA");
                MimeMessage mime = new MimeMessage((Session)null);
                mime.setContent((Multipart)signedMultiPart);
                mime.writeTo((OutputStream)fos, UNWANTED_MIME_HEADERS);
                String usingInfoText = this._certificateUtility.toUsingInfoText((X509Certificate)certificateChain[0], "SMIME signed object built using certificate");
                this.messageLog(63, message.getDatabaseId(), message.getMessageId(), usingInfoText);
                this._log.info(usingInfoText);
                message.setCurrentContentReference(fileOut);
                message.setCurrentContentType(signedMultiPart.getContentType());
            }
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(new File(message.getCurrentContentReferenceFolder(), localId + ".cer").toPath(), new OpenOption[0]));){
                out.write(certificateChain[0].getEncoded());
                out.flush();
            }
            catch (IOException ioe) {
                this._log.warn("could not store certficate for archiving.");
            }
        }
        catch (Exception e) {
            if (e instanceof LocalizedException) {
                this._log.fatal("Error while creating S/MIME signature: {}", (Object)e.getMessage());
                this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw new SignatureException(19004, "Error while creating S/MIME signature: " + e.getMessage());
            }
            this._log.fatal("Error while creating S/MIME signature: {}", (Object)e.toString());
            this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.toString());
            throw new SignatureException(19004, "Error while creating S/MIME signature: " + e.toString());
        }
        finally {
            if (masterStream != null) {
                try {
                    masterStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected String getDefaultExtension() {
        return ".p7smime";
    }

    @Override
    public String getOptionValue() {
        return "SMIME-SHA1";
    }

    @Override
    public String getProcessingValueHashAlgorithm() {
        return "SMIME-SHA1";
    }
}

