/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.common.activation.StreamingDataHandler;
import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.activation.DataHandler;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.SharedFileInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public abstract class SMIMECDSASigner
extends BaseFilterPlugin {
    private static final String[] UNWANTED_MIME_HEADERS = new String[]{"Message-Id", "MIME-Version"};

    public SMIMECDSASigner(String pluginName, MessengerLog messengerLog) {
        super(pluginName, messengerLog);
    }

    protected void filterSMIME(XpMessage message, String ecdsa, CertificateUtility certificateUtility, SMIMESigner smimeSigner) throws SignatureException {
        String localId = message.getCommunication().getSenderLocalId();
        PrivateKey privateKey = null;
        Certificate[] certificateChain = null;
        try {
            SignCertInfo signCertInfo = message.getCommunication().getProcessingSignKey();
            privateKey = signCertInfo.getPrivateKey();
            certificateChain = signCertInfo.getCertificateChain();
        }
        catch (ProfileException | CertificateException e) {
            this._log.error("Error while creating S/MIME signature: {}", (Object)e.getMessage());
            this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.getMessage());
            throw new SignatureException(19004, "Error while creating S/MIME signature: " + e.getMessage());
        }
        try (SimpleFileDataSource payloadSource = new SimpleFileDataSource(message.getCurrentContentType(), message.getCurrentContentReference());){
            try (SharedFileInputStream masterStream = (SharedFileInputStream)payloadSource.getInputStream();){
                if (certificateChain == null) {
                    this._log.fatal("Certificate for localid: {} is not installed", (Object)localId);
                    throw new SignatureException(19003, new String[]{localId}, "Certificate for localid: " + localId + " is not installed");
                }
                if (privateKey == null) {
                    throw new SignatureException(19002, new String[]{localId}, "Private Key for local Id: '" + localId + "' is missing");
                }
                this.updateProcessedOriginalFilename(message, false);
                File fileOut = new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + this.getDefaultExtension());
                try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(fileOut.toPath(), new OpenOption[0]));){
                    MimeBodyPart bp = new MimeBodyPart();
                    StreamingDataHandler handler = new StreamingDataHandler(payloadSource);
                    bp.setDataHandler((DataHandler)handler);
                    ContentDisposition disposition = new ContentDisposition("inline");
                    disposition.setParameter("filename", message.getCurrentContentReference().getName());
                    bp.setDisposition(disposition.toString());
                    MimeMultipart signedMultiPart = smimeSigner.createSignedMimeMessage(bp, null, privateKey, certificateChain, ecdsa);
                    MimeMessage mime = new MimeMessage((Session)null);
                    mime.setContent((Multipart)signedMultiPart);
                    mime.writeTo((OutputStream)fos, UNWANTED_MIME_HEADERS);
                    String usingInfoText = certificateUtility.toUsingInfoText((X509Certificate)certificateChain[0], "SMIME signed object built using certificate");
                    this.messageLog(63, message.getDatabaseId(), message.getMessageId(), usingInfoText);
                    this._log.info(usingInfoText);
                    message.setCurrentContentReference(fileOut);
                    message.setCurrentContentType(signedMultiPart.getContentType());
                }
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(new File(message.getCurrentContentReferenceFolder(), localId + ".cer").toPath(), new OpenOption[0]));){
                    out.write(certificateChain[0].getEncoded());
                    out.flush();
                }
                catch (IOException ioe) {
                    this._log.warn("could not store certficate for archiving.");
                }
            }
            catch (Exception e) {
                if (e instanceof LocalizedException) {
                    this._log.fatal("Error while creating S/MIME signature: {}", (Object)e.getMessage());
                    this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                    throw new SignatureException(19004, "Error while creating S/MIME signature: " + e.getMessage());
                }
                throw e;
            }
        }
        catch (Exception e) {
            this._log.fatal("Error while creating S/MIME signature: {}", (Object)e.toString());
            this.messageLog(505, message.getDatabaseId(), message.getMessageId(), e.toString());
            throw new SignatureException(19004, "Error while creating S/MIME signature: " + e.toString());
        }
    }
}

