/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ISignatureVerifier;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SMIMEVerify;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifier;

public class SMIME512Verifier
extends SMIMEVerify
implements ISignatureVerifier {
    public SMIME512Verifier(CertificateUtility certificateUtility, SMIMEVerifier smimeVerifier, RegistryProfileUpdater registryProfileUpdater, MessengerLog messengerLog) {
        super("SMIME512Verifier", certificateUtility, smimeVerifier, registryProfileUpdater, messengerLog);
    }

    @Override
    public void doFilter(XpMessage message) throws BaseFilterException {
        this._log.debug("S/MIME sha512 signature will be verified.");
        this.handleSMIME(message);
    }

    @Override
    public String getOptionValue() {
        return "SMIME-SHA512";
    }

    @Override
    public String getProcessingValueHashAlgorithm() {
        return "SMIME-SHA512";
    }
}

