/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ISigner;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SMIMECDSASigner;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;

public class SMIME512ECDSASigner
extends SMIMECDSASigner
implements ISigner {
    public static final String PROCESSING_VALUE = "SMIME-SHA512-ECDSA";
    public static final String OPTION_VALUE_SMIME = "SMIME-SHA512-ECDSA";
    private CertificateUtility certificateUtility;
    private SMIMESigner smimeSigner;

    public SMIME512ECDSASigner(CertificateUtility certificateUtility, SMIMESigner smimeSigner, MessengerLog messengerLog) {
        super("SMIME512ECDSASigner", messengerLog);
        this.certificateUtility = certificateUtility;
        this.smimeSigner = smimeSigner;
    }

    @Override
    public void doFilter(XpMessage message) throws BaseFilterException {
        this._log.debug("S/MIME sha512 ecdsa signature will be created.");
        this.filterSMIME(message, "SHA512withECDSA", this.certificateUtility, this.smimeSigner);
    }

    @Override
    protected String getDefaultExtension() {
        return ".p7smime";
    }

    @Override
    public String getOptionValue() {
        return "SMIME-SHA512-ECDSA";
    }

    @Override
    public String getProcessingValueHashAlgorithm() {
        return "SMIME-SHA512-ECDSA";
    }
}

