/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ISigner;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.Signer;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;

public class SHA256ECDSASigner
extends Signer
implements ISigner {
    public static final String OPTION_VALUE_SHA256 = "SHA256WithECDSA";
    public static final String PROCESSING_VALUE_HASH_ALGORITHM_SHA256 = "sha256";

    public SHA256ECDSASigner(CertificateUtility certificateUtility, MessengerLog messengerLog) throws BaseFilterException {
        super("SHA256ECDSASigner", certificateUtility, messengerLog);
        this.setSignatureAlgorithm(OPTION_VALUE_SHA256, PROCESSING_VALUE_HASH_ALGORITHM_SHA256, CryptoUtil.SHA256_WITH_ECDSA);
    }

    @Override
    public String getOptionValue() {
        return OPTION_VALUE_SHA256;
    }

    @Override
    public String getProcessingValueHashAlgorithm() {
        return PROCESSING_VALUE_HASH_ALGORITHM_SHA256;
    }
}

