/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ISignatureVerifier;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.util.Iterator;
import org.springframework.context.ApplicationContext;

public class SignatureVerificationFilter
extends BaseFilter<ISignatureVerifier> {
    public SignatureVerificationFilter(MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("SignatureVerificationFilter", messengerLog, uiConfig, applicationContext);
    }

    @Override
    protected Class<ISignatureVerifier> getFilterPluginClass() {
        return ISignatureVerifier.class;
    }

    @Override
    public void doFilter(XpMessage message) throws SignatureException, BaseFilterException {
        String signAlgorithm = message.getProcessingDirective("SignatureAlgorithm");
        String hashAlgorithm = message.getProcessingDirective("HashAlgorithm");
        this.getLogger().debug("SignatureAlgorithm in processing directives is: '{}' HashAlgorithm in processing directives is: '{}'", (Object)signAlgorithm, (Object)hashAlgorithm);
        String signOption = null;
        try {
            signOption = message.getCommunication().getPipelineOptionValueForMessage("/sign", message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (signAlgorithm != null && hashAlgorithm != null) {
            boolean pluginFound = false;
            if ("rsa".equals(signAlgorithm)) {
                Iterator it = this._plugins.iterator();
                while (it.hasNext()) {
                    if (!((ISignatureVerifier)it.next()).getProcessingValueHashAlgorithm().equals(hashAlgorithm)) continue;
                    pluginFound = true;
                    break;
                }
            }
            if ("ecdsa".equals(signAlgorithm)) {
                for (ISignatureVerifier plugin : this._plugins) {
                    if (!plugin.getProcessingValueHashAlgorithm().equals(hashAlgorithm)) continue;
                    pluginFound = true;
                    break;
                }
            }
            if (!pluginFound) {
                String errorMessage = "Different signature and hash algorithm used, than defined in agreement";
                this.messageLog(504, message.getDatabaseId(), message.getMessageId(), "Different signature and hash algorithm used, than defined in agreement");
                throw new SignatureException(19012, "Different signature and hash algorithm used, than defined in agreement");
            }
        }
        this.getLogger().debug("Trying to verifing signature...");
        for (ISignatureVerifier plugin : this._plugins) {
            if (!plugin.getOptionValue().equals(signOption)) continue;
            plugin.doFilter(message);
            break;
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        UIOption[] options = new UIOption[]{};
        return options;
    }
}

