/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.customvalidation.CustomValidationResult;
import de.pontonconsulting.xmlpipe.messenger.filter.customvalidation.ICustomValidator;
import de.pontonconsulting.xmlpipe.messenger.filter.customvalidation.ValidateableMessageType;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationException;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class CustomValidationFilter
extends BaseFilter<IFilterPlugin> {
    public static final String OPTION_PATH = "/customValidation";
    private static final UIOption[] OPTIONS = new UIOption[]{new UIOption("pipelineOption.filter.customValidation", "/customValidation", "boolean", Boolean.TRUE.toString(), "help_header_customValidation", "pipelineOption.filter.customValidation", "pipelineOption.agreement.help.filter.customValidation", "pipelineOption.profile.help.filter.customValidation", UIOption.NONE)};
    private ICustomValidator _customValidator;
    private List<ValidateableMessageType> _validatableMessages;

    public CustomValidationFilter(MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("ValidationFilter", messengerLog, uiConfig, applicationContext);
    }

    @Override
    protected Class<IFilterPlugin> getFilterPluginClass() {
        return null;
    }

    @Override
    public void initFilter() throws BaseFilterException {
        super.initFilter();
        String validatorName = System.getProperty("pontonxp.custom.validationclass");
        if (validatorName != null) {
            try {
                Class<?> validatorClass = Class.forName(validatorName);
                this._customValidator = (ICustomValidator)validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this._validatableMessages = this._customValidator.getValidateableMessageTypes();
                this.getLogger().info("custom validator filter {} is activated.", (Object)validatorName);
            }
            catch (Exception e) {
                this.getLogger().error("could not initialize custom validator filter '{}' :{}", (Object)validatorName, (Object)e.toString());
            }
        } else {
            this.getLogger().debug("custom validator filter name is not set as system property 'pontonxp.custom.validationclass'");
        }
    }

    @Override
    public void doFilter(XpMessage message) throws BaseFilterException {
        if (this._customValidator == null) {
            return;
        }
        boolean validationEnabled = false;
        try {
            validationEnabled = Boolean.valueOf(message.getCommunication().getPipelineOptionValueForMessage(OPTION_PATH, message.getSchemaLocation()));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (validationEnabled) {
            this.validate(message);
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Custom validation is not activated in the agreement.");
        }
    }

    private void validate(XpMessage message) throws ValidationException {
        if ("ponton".equals(message.getSchemaSet()) && ("ACK".equals(message.getMessageType()) || "PING".equals(message.getMessageType()) || "PONG".equals(message.getMessageType()) || "CertUpdateRequest".equals(message.getMessageType()) || "CertUpdateResponse".equals(message.getMessageType()) || "StatusRequest".equals(message.getMessageType()) || "StatusResponse".equals(message.getMessageType()))) {
            return;
        }
        if (message.getCurrentContentReference() == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("There is no payload, so we can not validate");
            }
            return;
        }
        boolean validateable = false;
        for (ValidateableMessageType type : this._validatableMessages) {
            if (!type.isSchemaSet(message.getSchemaSet()) || !type.isMessageType(message.getMessageType()) || !type.isMessageVersion(message.getMessageVersion())) continue;
            validateable = true;
            break;
        }
        if (validateable) {
            ValidateableMessageType messageType = new ValidateableMessageType(message.getSchemaSet(), message.getMessageType(), message.getMessageVersion());
            try {
                CustomValidationResult result = this._customValidator.doValidate(message.getCurrentContentReference(), messageType, message.isInbound());
                if (!result.isSuccessful()) {
                    this.messageLog(508, message.getDatabaseId(), message.getMessageId(), this._customValidator.getName());
                    StringBuilder sb = new StringBuilder();
                    for (String resultMessage : result.getMessages()) {
                        this.getLogger().warn(resultMessage);
                        sb.append(resultMessage);
                        sb.append('\n');
                        this.messageLog(523, message.getDatabaseId(), message.getMessageId(), resultMessage);
                    }
                    throw new ValidationException(20000, sb.toString());
                }
                this.messageLog(61, message.getDatabaseId(), message.getMessageId(), this._customValidator.getName());
            }
            catch (ValidationException v) {
                throw v;
            }
            catch (Exception e) {
                this.getLogger().error("unexpected error in custom validation filter: {}", (Object)e.toString());
            }
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        return OPTIONS;
    }
}

