/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.common.xml.DtdFilterStream;
import de.pontonconsulting.xmlpipe.adapter.TransportURLType;
import de.pontonconsulting.xmlpipe.cpa.RuleData;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMailNotification;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.context.ApplicationContext;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ContentRuleFilter
extends BaseFilter<IFilterPlugin> {
    private static final String TRIGGER_MARK = "!";
    public static final String LOG_INFO = "!LogInfo";
    public static final String MESSAGE_ID = "!MessageId";
    public static final String CONVERSATION_ID = "!ConversationId";
    public static final String MESSAGE_VERSION = "!MessageVersion";
    public static final String MESSAGE_TYPE = "!MessageType";
    public static final String SCHEMA_SET = "!SchemaSet";
    public static final String TEST_FLAG = "!TestFlag";
    public static final String SERVICE = "!Service";
    public static final String ACTION = "!Action";
    public static final String ORIGINAL_FILE_NAME = "!OriginalFileName";
    public static final String PROCESSED_FILE_NAME = "!ProcessedFileName";
    private static final String FEATURE_ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    private static final String FEATURE_CONTINUE_AFTER_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    private static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String FEATURE_LOAD_DTD = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    private static final String FEATURE_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String FEATURE_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String FEATURE_XML_VALIDATION = "http://xml.org/sax/features/validation";
    private final EMailNotification _emailNotification;
    private SAXParserFactory saxParserFactory;
    private final MessageDAO messageDAO;

    public ContentRuleFilter(MessengerLog messengerLog, UIConfig uiConfig, EMailNotification emailNotification, MessageDAO messageDAO, ApplicationContext applicationContext) {
        super("ContentRuleFilter", messengerLog, uiConfig, applicationContext);
        this._emailNotification = emailNotification;
        this.messageDAO = messageDAO;
    }

    @Override
    protected Class<IFilterPlugin> getFilterPluginClass() {
        return null;
    }

    @Override
    public void initFilter() throws BaseFilterException {
        super.initFilter();
        try {
            this.createSAXReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new BaseFilterException(15010, "Could not initiate ContentRuleFilter: " + e.getMessage());
        }
    }

    private SAXReader createSAXReader() throws SAXException, ParserConfigurationException {
        SAXParser saxParser = this.getSAXParserFactory().newSAXParser();
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        SAXReader reader = new SAXReader(saxParser.getXMLReader());
        return reader;
    }

    @Override
    public void doFilter(XpMessage message) throws BaseFilterException {
        if (message.getCurrentContentReference() == null) {
            this.getLogger().debug("There is no XML payload, so we cannot apply any XPATH to it");
        } else if (message.isAck()) {
            this.getLogger().debug("Acknowledgments content is not considered for rules.");
        } else {
            try {
                RuleData[] rules = message.getCommunication().getContentRules();
                if (rules != null && rules.length != 0) {
                    this.checkRules(message, rules);
                } else {
                    this.getLogger().debug("no content rules defined");
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Problem while checking content rule:{}", (Object)e.toString());
            }
        }
    }

    private void checkRules(XpMessage message, RuleData[] rules) throws DocumentException, SAXException, ParserConfigurationException, IOException {
        Document document = null;
        try (DtdFilterStream dfs = new DtdFilterStream(new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0])));){
            int i;
            for (i = 0; i < rules.length; ++i) {
                if (rules[i].getXpath().startsWith(TRIGGER_MARK)) continue;
                document = this.createSAXReader().read((InputStream)dfs);
                break;
            }
            for (i = 0; i < rules.length; ++i) {
                try {
                    RuleData ruleData = rules[i];
                    this.checkRule(message, document, ruleData);
                    continue;
                }
                catch (Exception e) {
                    this.getLogger().warn("Problem while checking content rule [{}]:{}", (Object)i, (Object)e.toString());
                    this.messageLog(544, message.getDatabaseId(), message.getMessageId(), "Problem while checking content rule [" + i + "]:" + e.getMessage() + ". The content rule is ignored.");
                }
            }
        }
    }

    private void checkRule(XpMessage message, Document document, RuleData ruleData) {
        Object xpathResult;
        boolean result = false;
        String foundValue = null;
        String value = null;
        String op = null;
        if (ruleData.getXpath().startsWith(TRIGGER_MARK)) {
            String query = ruleData.getXpath();
            if (query.equalsIgnoreCase(TEST_FLAG)) {
                foundValue = Boolean.toString(message.isTestMessage());
            } else if (query.equalsIgnoreCase(MESSAGE_ID)) {
                foundValue = message.getMessageId();
            } else if (query.equalsIgnoreCase(CONVERSATION_ID)) {
                foundValue = message.getConversationId();
            } else if (query.equalsIgnoreCase(MESSAGE_TYPE)) {
                foundValue = message.getMessageType();
            } else if (query.equalsIgnoreCase(MESSAGE_VERSION)) {
                foundValue = message.getMessageVersion();
            } else if (query.equalsIgnoreCase(SCHEMA_SET)) {
                foundValue = message.getSchemaSet();
            } else if (query.equalsIgnoreCase(LOG_INFO)) {
                foundValue = message.getProcessingDirective("LogInfo");
            } else if (query.equalsIgnoreCase(SERVICE)) {
                foundValue = message.getProcessingDirective("service");
            } else if (query.equalsIgnoreCase(ACTION)) {
                foundValue = message.getProcessingDirective("action");
            } else if (query.equalsIgnoreCase(ORIGINAL_FILE_NAME)) {
                foundValue = message.getProcessingDirective("OriginalFilename");
            } else if (query.equalsIgnoreCase(PROCESSED_FILE_NAME)) {
                foundValue = message.getProcessingDirective("ProcessedOriginalFilename");
            }
        } else if (ruleData.getXpath() != null && ruleData.getXpath().length() > 0 && (xpathResult = document.selectObject(ruleData.getXpath())) != null) {
            if (xpathResult instanceof Node) {
                foundValue = ((Node)xpathResult).getText();
            } else if (xpathResult instanceof String) {
                foundValue = (String)xpathResult;
            } else if (xpathResult instanceof Number) {
                foundValue = ((Number)xpathResult).toString();
            } else if (xpathResult instanceof Boolean) {
                foundValue = ((Boolean)xpathResult).toString();
            } else if (xpathResult instanceof List) {
                if (((List)xpathResult).size() > 1) {
                    this.getLogger().warn("{} produces multiple results. The content rule [{}] is ignored.", (Object)ruleData.getXpath(), (Object)ruleData.getId());
                    this.messageLog(544, message.getDatabaseId(), message.getMessageId(), ruleData.getXpath() + " produces multiple results. The content rule is ignored.");
                }
            } else {
                this.getLogger().warn("{} produces unsupported value type {}. content rule[{}]", (Object)ruleData.getXpath(), xpathResult.getClass(), (Object)ruleData.getId());
                this.messageLog(544, message.getDatabaseId(), message.getMessageId(), ruleData.getXpath() + " produces unsupported value type " + xpathResult.getClass().getName() + ". The content rule is ignored.");
            }
        }
        if (foundValue != null) {
            value = ruleData.getXpathValue();
            op = ruleData.getOperator();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("content rule [{}]: XPath '{}'; found value '{}'; compared value '{}'.", (Object)ruleData.getId(), (Object)ruleData.getXpath(), (Object)foundValue, (Object)value);
            }
            if ("Equal".equalsIgnoreCase(op)) {
                result = foundValue.equals(value);
            } else if ("NotEqual".equalsIgnoreCase(op)) {
                result = !foundValue.equals(value);
            } else if ("Contains".equalsIgnoreCase(op)) {
                result = foundValue.contains(value);
            } else if ("ContainsNot".equalsIgnoreCase(op)) {
                result = !foundValue.contains(value);
            } else if ("StartsWith".equalsIgnoreCase(op)) {
                result = foundValue.startsWith(value);
            } else if ("EndsWith".equalsIgnoreCase(op)) {
                result = foundValue.endsWith(value);
            } else if ("LessThan".equalsIgnoreCase(op)) {
                result = Integer.parseInt(foundValue) < Integer.parseInt(value);
            } else if ("GreaterThan".equalsIgnoreCase(op)) {
                result = Integer.parseInt(foundValue) > Integer.parseInt(value);
            } else {
                this.getLogger().debug("content rule [{}] has unknown operator:{}", (Object)ruleData.getId(), (Object)ruleData.getOperator());
            }
        }
        if (result) {
            if ("ChangeDestinationAdapter".equals(ruleData.getActionType())) {
                message.setAdapterId(ruleData.getActionValue());
                this.getLogger().info("Content rule [{}]: Changed destination adapter to:{}", (Object)ruleData.getId(), (Object)ruleData.getActionValue());
                this.messageLog(204, message.getDatabaseId(), message.getMessageId(), ruleData.getXpath() + " (" + foundValue + ") " + op + " " + value + " -> Destination Adapter changed to:" + ruleData.getActionValue());
            } else if ("ChangeDestinationURL".equals(ruleData.getActionType())) {
                message.setTransportURLType(TransportURLType.FIXED);
                message.setDestinationUrl(ruleData.getActionValue());
                this.getLogger().info("Content rule [{}]: Changed destination URL to: {}", (Object)ruleData.getId(), (Object)ruleData.getActionValue());
                this.messageLog(204, message.getDatabaseId(), message.getMessageId(), ruleData.getXpath() + " (" + foundValue + ") " + op + " " + value + " -> Destination URL changed to: " + ruleData.getActionValue());
            } else if ("EMailNotification".equals(ruleData.getActionType())) {
                if (ruleData.getEmail() != null && ruleData.getEmail().length() > 0) {
                    this.getLogger().info("Content rule [{}]: sending email notification to: {}", (Object)ruleData.getId(), (Object)ruleData.getEmail());
                    try {
                        MessageInfo info = this.messageDAO.getMessageInfo(message.getDatabaseId());
                        this._emailNotification.sendNotification(info, ruleData.getEmail(), ruleData.getWithAttachment(), ruleData.getSubjectElements(), 204);
                        this.messageLog(204, message.getDatabaseId(), message.getMessageId(), ruleData.getXpath() + " (" + foundValue + ") " + op + " " + value + " -> EMail Notification sent to: " + ruleData.getEmail());
                    }
                    catch (Exception e) {
                        this.getLogger().warn("unable to send email notification: {}", (Object)e.toString());
                    }
                } else {
                    this.getLogger().info("Content rule [{}]: email notification triggered, but no email address specified", (Object)ruleData.getId());
                }
            } else {
                this.getLogger().info("Content rule [{}] matched", (Object)ruleData.getId());
                this.messageLog(204, message.getDatabaseId(), message.getMessageId(), ruleData.getXpath() + " (" + foundValue + ") " + op + " " + value);
            }
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        return new UIOption[0];
    }

    private SAXParserFactory getSAXParserFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        if (this.saxParserFactory == null) {
            this.saxParserFactory = SAXParserFactory.newInstance();
            this.saxParserFactory.setFeature(FEATURE_XML_VALIDATION, false);
            this.saxParserFactory.setFeature(FEATURE_SCHEMA, false);
            this.saxParserFactory.setFeature(FEATURE_SCHEMA_FULL_CHECKING, false);
            this.saxParserFactory.setFeature(FEATURE_LOAD_DTD, false);
            this.saxParserFactory.setFeature(FEATURE_LOAD_EXTERNAL_DTD, false);
            this.saxParserFactory.setFeature(FEATURE_CONTINUE_AFTER_ERROR, false);
            this.saxParserFactory.setFeature(FEATURE_ALLOW_JAVA_ENCODINGS, true);
            this.saxParserFactory.setNamespaceAware(true);
            this.saxParserFactory.setValidating(false);
        }
        return this.saxParserFactory;
    }
}

