/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.emailnotification;

import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMail;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.INotificationService;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.SystemEmailNotificationModel;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSender;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSenderFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemEmailNotification
implements INotificationService {
    private static Log LOG = LogFactory.getFactory().getInstance("Messenger.SystemEmailNotification");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("d.MM.yyyy HH:mm:ss");
    private static final String EMAIL_SEPARATOR = "----------------------------------------------------------------------";
    public static final String BEAN_NAME = "systemEmailNotification";
    private final SmtpSenderFactory smtpSenderFactory;
    private final Object _sync = new Object();
    private Map<String, List<SystemEmailNotificationModel>> emailNotifications;

    public SystemEmailNotification(SmtpSenderFactory smtpSenderFactory) {
        this.smtpSenderFactory = smtpSenderFactory;
        this.emailNotifications = new ConcurrentHashMap<String, List<SystemEmailNotificationModel>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEmails(Integer emailMaxCount) {
        Map<String, List<SystemEmailNotificationModel>> tempEmailNotifications;
        Object object = this._sync;
        synchronized (object) {
            tempEmailNotifications = this.emailNotifications;
            this.emailNotifications = new HashMap<String, List<SystemEmailNotificationModel>>();
        }
        ArrayList<EMail> eMails = new ArrayList<EMail>();
        Set<String> receivers = tempEmailNotifications.keySet();
        for (String receiver : receivers) {
            List<SystemEmailNotificationModel> emailNotificationModels = tempEmailNotifications.get(receiver);
            if (emailNotificationModels.size() <= 0) continue;
            if (emailMaxCount < 2) {
                this.createSimpleEMails(receiver, emailNotificationModels, eMails);
            } else {
                this.createGroupEMails(receiver, emailNotificationModels, emailMaxCount, eMails);
            }
            for (EMail eMail : eMails) {
                try {
                    SmtpSender smtpSender = this.smtpSenderFactory.getSmtpSender();
                    smtpSender.sendMessage(eMail.getReceiver(), eMail.getSubject(), eMail.getContent(), eMail.getAttachments());
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not send system email notification: " + e.toString()));
                }
            }
        }
    }

    private void createGroupEMails(String receiver, List<SystemEmailNotificationModel> emailNotificationModels, Integer emailMaxCount, List<EMail> eMails) {
        String subject = "Ponton XP eMail Notification";
        int tempCount = 0;
        Object tempEmailContent = "";
        for (SystemEmailNotificationModel emailNotificationModel : emailNotificationModels) {
            if (tempCount < emailMaxCount) {
                tempEmailContent = (String)tempEmailContent + "Notification Time: " + DATE_FORMAT.format(emailNotificationModel.getTime()) + "\n";
                if (emailNotificationModel.getSubject() != null && emailNotificationModel.getSubject().trim().length() > 0) {
                    tempEmailContent = (String)tempEmailContent + "Notification Subject: " + emailNotificationModel.getSubject().trim() + "\n";
                }
                tempEmailContent = (String)tempEmailContent + "Text:\n" + emailNotificationModel.getContent().trim() + "\n";
                tempEmailContent = (String)tempEmailContent + "----------------------------------------------------------------------\n\n";
            }
            if (++tempCount != emailMaxCount) continue;
            eMails.add(this.createEMail(receiver, "Ponton XP eMail Notification", (String)tempEmailContent));
            tempCount = 0;
            tempEmailContent = "";
        }
        if (tempCount > 0) {
            eMails.add(this.createEMail(receiver, "Ponton XP eMail Notification", (String)tempEmailContent));
        }
    }

    private EMail createEMail(String receiver, String subject, String content) {
        EMail eMail = new EMail();
        eMail.setReceiver(receiver);
        eMail.setSubject(subject);
        eMail.setContent(content);
        return eMail;
    }

    private void createSimpleEMails(String receiver, List<SystemEmailNotificationModel> emailNotificationModels, List<EMail> eMails) {
        for (SystemEmailNotificationModel emailNotificationModel : emailNotificationModels) {
            String content = "Notification Time: " + DATE_FORMAT.format(emailNotificationModel.getTime()) + "\n";
            content = content + "\n" + emailNotificationModel.getContent().trim();
            eMails.add(this.createEMail(receiver, emailNotificationModel.getSubject(), content));
        }
    }

    public void sendNotification(String to, String subject, String description) {
        StringBuilder msg = new StringBuilder(subject + "\n\n");
        if (StringUtils.isNotBlank((CharSequence)description)) {
            msg.append(description + "\n");
        }
        SystemEmailNotificationModel eMailNotificationModel = new SystemEmailNotificationModel();
        eMailNotificationModel.setContent(msg.toString());
        eMailNotificationModel.setTime(new Date());
        eMailNotificationModel.setSubject(subject);
        this.addEmailNotification(to, eMailNotificationModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEmailNotification(String receiver, SystemEmailNotificationModel eMailNotificationModel) {
        Object object = this._sync;
        synchronized (object) {
            List<SystemEmailNotificationModel> eMailNotifications = this.emailNotifications.get(receiver);
            if (eMailNotifications == null) {
                eMailNotifications = new ArrayList<SystemEmailNotificationModel>();
                this.emailNotifications.put(receiver, eMailNotifications);
            }
            if (!eMailNotifications.contains(eMailNotificationModel)) {
                eMailNotifications.add(eMailNotificationModel);
            }
        }
    }
}

