/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.emailnotification;

import de.pontonconsulting.common.io.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.SubjectElement;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.message.StAXContainer;
import de.pontonconsulting.xmlpipe.message.ZipXslTransformer;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.database.LogException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMail;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMailNotificationModel;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.INotificationService;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSender;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSenderFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;

public class EMailNotification
implements INotificationService,
IServiceProvider {
    public static final String BEAN_NAME = "eMailNotification";
    private static final String XPATH_SEPARATOR = "/";
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.EMailNotification");
    private final SimpleDateFormat _dateFormatter;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("d.MM.yyyy HH:mm:ss");
    private static final String EMAIL_SEPARATOR = "----------------------------------------------------------------------";
    private final Object _sync = new Object();
    private Map<String, List<EMailNotificationModel>> _emailNotifications;
    private final SmtpSenderFactory _smtpSenderFactory;
    private final SchemataConfig _schemataConfig;
    private final Profiles _profiles;
    private final ZipXslTransformer _xslTransformer;
    private final Map<String, List<EMailNotificationModel>> _attachmentFiles = new HashMap<String, List<EMailNotificationModel>>();

    public EMailNotification(SmtpSenderFactory smtpSenderFactory, SchemataConfig schemataConfig, Profiles profiles, ZipXslTransformer zipXslTransformer) {
        Objects.requireNonNull(smtpSenderFactory, "SmtpSenderFactory reference not set");
        Objects.requireNonNull(profiles, "Profiles reference not set");
        Objects.requireNonNull(schemataConfig, "SchemataConfig reference not set");
        Objects.requireNonNull(zipXslTransformer, "ZipXslTransformer reference not set");
        this._dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'z");
        this._emailNotifications = new HashMap<String, List<EMailNotificationModel>>();
        this._smtpSenderFactory = smtpSenderFactory;
        this._schemataConfig = schemataConfig;
        this._profiles = profiles;
        this._xslTransformer = zipXslTransformer;
    }

    public void shutdown() {
        this.sendEMails(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reserveAttachmentFile(File file, EMailNotificationModel mailNotificationModel) {
        boolean result = false;
        Map<String, List<EMailNotificationModel>> map = this._attachmentFiles;
        synchronized (map) {
            List<EMailNotificationModel> models = this._attachmentFiles.get(file.getAbsolutePath());
            if (models == null) {
                models = new ArrayList<EMailNotificationModel>();
                this._attachmentFiles.put(file.getAbsolutePath(), models);
                result = true;
            }
            models.add(mailNotificationModel);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEMailNotification(String receiver, EMailNotificationModel eMailNotificationModel) {
        Object object = this._sync;
        synchronized (object) {
            List eMailNotifications = this._emailNotifications.computeIfAbsent(receiver, k -> new ArrayList());
            if (!eMailNotifications.contains(eMailNotificationModel)) {
                eMailNotifications.add(eMailNotificationModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSimpleEMails(String receiver, List<EMailNotificationModel> emailNotificationModels, List<EMail> eMails, Set<File> deletableAttachments) {
        for (EMailNotificationModel emailNotificationModel : emailNotificationModels) {
            HashSet<File> attachments = new HashSet<File>(1);
            File attachment = emailNotificationModel.getAttachment();
            if (attachment != null) {
                deletableAttachments.add(attachment);
                Map<String, List<EMailNotificationModel>> map = this._attachmentFiles;
                synchronized (map) {
                    List<EMailNotificationModel> models = this._attachmentFiles.get(attachment.getAbsolutePath());
                    if (models != null) {
                        models.remove(emailNotificationModel);
                    }
                }
                attachments.add(attachment);
            }
            String content = "Notification Time: " + DATE_FORMAT.format(emailNotificationModel.getTime()) + "\n";
            content = content + "\n" + emailNotificationModel.getContent().trim();
            eMails.add(this.createEMail(receiver, emailNotificationModel.getSubject(), content, attachments));
        }
    }

    private EMail createEMail(String receiver, String subject, String content, Set<File> attachments) {
        EMail eMail = new EMail();
        eMail.setReceiver(receiver);
        eMail.setSubject(subject);
        eMail.setContent(content);
        ArrayList<File> sortAttachments = new ArrayList<File>(attachments);
        sortAttachments.sort(new Comparator<File>(this){

            @Override
            public int compare(File file1, File file2) {
                String name1 = file1.getName();
                String name2 = file2.getName();
                if (name1.length() > name2.length()) {
                    return 1;
                }
                if (name1.length() == name2.length()) {
                    return name1.compareTo(name2);
                }
                return -1;
            }
        });
        eMail.setAttachments(sortAttachments);
        return eMail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGroupEMails(String receiver, List<EMailNotificationModel> emailNotificationModels, int emailMaxCount, List<EMail> eMails, Set<File> deletablAttachments) {
        String subject = "Ponton XP eMail Notification";
        int tempCount = 0;
        StringBuilder tempEmailContent = new StringBuilder();
        HashSet<File> tempEmailAttachments = new HashSet<File>();
        for (int i = 0; i < emailNotificationModels.size(); ++i) {
            EMailNotificationModel emailNotificationModel = emailNotificationModels.get(i);
            if (tempCount < emailMaxCount) {
                tempEmailContent.append("Notification Time: ").append(DATE_FORMAT.format(emailNotificationModel.getTime())).append("\n");
                if (emailNotificationModel.getSubject() != null && emailNotificationModel.getSubject().trim().length() > 0) {
                    tempEmailContent.append("Notification Subject: ").append(emailNotificationModel.getSubject().trim()).append("\n");
                }
                tempEmailContent.append("Text:\n").append(emailNotificationModel.getContent().trim()).append("\n");
                File attachment = emailNotificationModel.getAttachment();
                if (attachment != null) {
                    deletablAttachments.add(attachment);
                    Map<String, List<EMailNotificationModel>> map = this._attachmentFiles;
                    synchronized (map) {
                        List<EMailNotificationModel> models = this._attachmentFiles.get(attachment.getAbsolutePath());
                        if (models != null) {
                            models.remove(emailNotificationModel);
                        }
                    }
                    tempEmailAttachments.add(attachment);
                    tempEmailContent.append("\n*** see attachment '").append(attachment.getName()).append("'\n");
                }
                tempEmailContent.append("----------------------------------------------------------------------\n\n");
            }
            if (++tempCount != emailMaxCount) continue;
            eMails.add(this.createEMail(receiver, "Ponton XP eMail Notification", tempEmailContent.toString(), tempEmailAttachments));
            tempCount = 0;
            tempEmailContent = new StringBuilder();
            tempEmailAttachments = new HashSet();
        }
        if (tempCount > 0) {
            eMails.add(this.createEMail(receiver, "Ponton XP eMail Notification", tempEmailContent.toString(), tempEmailAttachments));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEMails(int emailMaxCount) {
        Map<String, List<EMailNotificationModel>> tempEmailNotifications;
        Object object = this._sync;
        synchronized (object) {
            tempEmailNotifications = this._emailNotifications;
            this._emailNotifications = new HashMap<String, List<EMailNotificationModel>>();
        }
        HashSet<File> deletableAttachments = new HashSet<File>();
        ArrayList<EMail> eMails = new ArrayList<EMail>();
        Set<String> receivers = tempEmailNotifications.keySet();
        for (String receiver : receivers) {
            List<EMailNotificationModel> emailNotificationModels = tempEmailNotifications.get(receiver);
            if (emailNotificationModels.size() <= 0) continue;
            if (emailMaxCount < 2) {
                this.createSimpleEMails(receiver, emailNotificationModels, eMails, deletableAttachments);
            } else {
                this.createGroupEMails(receiver, emailNotificationModels, emailMaxCount, eMails, deletableAttachments);
            }
            for (EMail eMail : eMails) {
                try {
                    SmtpSender smtpSender = this._smtpSenderFactory.getSmtpSender();
                    smtpSender.sendMessage(eMail.getReceiver(), eMail.getSubject(), eMail.getContent(), eMail.getAttachments());
                }
                catch (Exception e) {
                    _log.error((Object)("Could not send email notification: " + e.toString()));
                }
            }
        }
        Map<String, List<EMailNotificationModel>> map = this._attachmentFiles;
        synchronized (map) {
            for (File attachment : deletableAttachments) {
                List<EMailNotificationModel> models = this._attachmentFiles.get(attachment.getAbsolutePath());
                if (models == null) {
                    attachment.delete();
                    continue;
                }
                if (models.size() != 0) continue;
                attachment.delete();
                this._attachmentFiles.remove(attachment.getAbsolutePath());
            }
        }
    }

    public void sendNotification(MessageInfo info, String to, boolean withAttachment, List<SubjectElement> subjectElements, int logId) throws LogException {
        this.sendNotification(info, to, withAttachment, subjectElements, logId, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(MessageInfo info, String to, boolean withAttachment, List<SubjectElement> subjectElements, int logId, String logMsg, String description) throws LogException {
        File payload = null;
        String subject = "";
        String msg = subject + "\n";
        msg = msg + "\n" + (String)(logMsg == null || logMsg.length() == 0 ? "" : logMsg + "\n") + (String)(description == null || description.length() == 0 ? "" : description + "\n");
        EMailNotificationModel eMailNotificationModel = new EMailNotificationModel();
        eMailNotificationModel.setContent(msg);
        eMailNotificationModel.setMessageInfo(info);
        eMailNotificationModel.setTime(new Date());
        if (withAttachment) {
            File htmlFile = new File(System.getProperty("java.io.tmpdir") + File.separator + info.getDatabaseId() + ".html");
            try {
                boolean createFile = this.reserveAttachmentFile(htmlFile, eMailNotificationModel);
                eMailNotificationModel.setAttachment(htmlFile);
                payload = this.retrievePayloadFile(info);
                if (createFile && Objects.nonNull(payload)) {
                    this.retrieveHtmlAttachement(info, payload, htmlFile);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (payload != null && info != null && !payload.equals(info.getPayloadFile())) {
                    payload.delete();
                }
            }
        }
        try {
            subject = this.getSubjectElementValues(info, subjectElements, logId, payload);
            eMailNotificationModel.setSubject(subject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addEMailNotification(to, eMailNotificationModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubjectElementValues(MessageInfo info, List<SubjectElement> subjectElements, int logId, File payload) {
        if (subjectElements != null && subjectElements.size() > 0) {
            ArrayList<Object> subjectElementList = new ArrayList<Object>();
            HashMap<Integer, String> xpaths = new HashMap<Integer, String>();
            for (SubjectElement subjectElement : subjectElements) {
                try {
                    SubjectElement nse = subjectElement;
                    if (1 == nse.getType()) {
                        if ("MessageId".equals(nse.getVariable())) {
                            subjectElementList.add(info.getMessageId());
                            continue;
                        }
                        if ("ConversationId".equals(nse.getVariable())) {
                            subjectElementList.add(info.getConversationId());
                            continue;
                        }
                        if ("MessageTime".equals(nse.getVariable())) {
                            subjectElementList.add(this._dateFormatter.format(new Date(info.getTimestamp())));
                            continue;
                        }
                        if ("SenderId".equals(nse.getVariable())) {
                            subjectElementList.add(info.getSenderId());
                            continue;
                        }
                        if ("SenderDisplayName".equals(nse.getVariable())) {
                            subjectElementList.add(this._profiles.getProfileForLocalId(info.getSenderId(), true).getDisplayName());
                            continue;
                        }
                        if ("ReceiverId".equals(nse.getVariable())) {
                            subjectElementList.add(info.getReceiverId());
                            continue;
                        }
                        if ("ReceiverDisplayName".equals(nse.getVariable())) {
                            subjectElementList.add(this._profiles.getProfileForLocalId(info.getReceiverId(), true).getDisplayName());
                            continue;
                        }
                        if ("MessageType".equals(nse.getVariable())) {
                            subjectElementList.add(info.getMessageType());
                            continue;
                        }
                        if ("SchemaSet".equals(nse.getVariable())) {
                            subjectElementList.add(info.getSchemaSet());
                            continue;
                        }
                        if ("SchemaVersion".equals(nse.getVariable())) {
                            subjectElementList.add(info.getSchemaVersion());
                            continue;
                        }
                        if (!"LogId".equals(nse.getVariable())) continue;
                        subjectElementList.add("" + logId);
                        continue;
                    }
                    if (2 == nse.getType()) {
                        xpaths.put(subjectElementList.size(), nse.getXpath());
                        subjectElementList.add("");
                        continue;
                    }
                    if (3 != nse.getType()) continue;
                    subjectElementList.add(nse.getText());
                }
                catch (Exception nse) {}
            }
            UTF8BOMSkippingInputStream in = null;
            XMLStreamReader reader = null;
            try {
                ArrayList<Object> xpath = new ArrayList<Object>();
                Object currentXPath = "";
                int xpathLevel = 0;
                xpath.add(0, currentXPath);
                StAXContainer collector = new StAXContainer(false);
                for (Integer position : xpaths.keySet()) {
                    String xpathStr = (String)xpaths.get(position);
                    collector.addCustomXPath(position.toString(), xpathStr);
                }
                in = new UTF8BOMSkippingInputStream(new BufferedInputStream(Files.newInputStream(payload.toPath(), new OpenOption[0])));
                XMLInputFactory f = XMLInputFactory.newInstance();
                f.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                f.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
                reader = f.createXMLStreamReader(in);
                while (!collector.elementsFound() && reader.hasNext()) {
                    switch (reader.getEventType()) {
                        case 1: {
                            currentXPath = (String)xpath.get(xpathLevel) + XPATH_SEPARATOR + reader.getName().getLocalPart();
                            xpath.add(++xpathLevel, currentXPath);
                            collector.handleStartElement(reader, xpathLevel, (String)currentXPath);
                            break;
                        }
                        case 2: {
                            collector.handleEndElement(xpathLevel);
                            --xpathLevel;
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 4: {
                            collector.handleText(reader);
                            break;
                        }
                    }
                    reader.next();
                }
                for (Integer position : xpaths.keySet()) {
                    String value = collector.getValue(position.toString());
                    if (value == null || value.length() <= 0) continue;
                    subjectElementList.set(position, value);
                }
            }
            catch (Exception xpath) {
            }
            finally {
                try {
                    assert (reader != null);
                    reader.close();
                }
                catch (Exception xpath) {}
                try {
                    in.close();
                }
                catch (Exception xpath) {}
            }
            StringBuilder subject = new StringBuilder();
            Iterator it = subjectElementList.iterator();
            while (it.hasNext()) {
                subject.append((String)it.next());
                if (!it.hasNext()) continue;
                subject.append(" ");
            }
            return subject.toString();
        }
        return "Notification for message " + info.getMessageId();
    }

    private File retrievePayloadFile(MessageInfo info) {
        File payloadFile;
        block20: {
            payloadFile = null;
            try {
                File archiveFolder = info.getMessageFolder();
                if (archiveFolder != null && archiveFolder.isDirectory()) {
                    if (info.getPayloadFile() != null && info.getPayloadFile().exists()) {
                        payloadFile = info.getPayloadFile();
                    }
                    break block20;
                }
                if (archiveFolder == null || !archiveFolder.isFile()) break block20;
                try (ZipFile zip = new ZipFile(archiveFolder);){
                    Enumeration<? extends ZipEntry> zipEntries = zip.entries();
                    while (zipEntries.hasMoreElements()) {
                        ZipEntry entry = zipEntries.nextElement();
                        String name = entry.getName();
                        try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(payloadFile.toPath(), new OpenOption[0]));
                             BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));){
                            if (info.getPayloadFile() == null || !name.equals(info.getPayloadFile().getName())) continue;
                            payloadFile = File.createTempFile("xp-", ".tmp");
                            ((InputStream)in).transferTo(fos);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return payloadFile;
    }

    private boolean retrieveHtmlAttachement(MessageInfo info, File payload, File htmlFile) {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(htmlFile.toPath(), new OpenOption[0]));){
            File xslFile = this.retrieveXSL(info);
            this._xslTransformer.transform(payload, xslFile, out);
        }
        catch (Exception e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Error while transforming XML file" + (String)msg;
            _log.error((Object)("[" + info.getDatabaseId() + "] " + (String)msg));
            return false;
        }
        return true;
    }

    private File retrieveXSL(MessageInfo messageInfo) throws IOException {
        try {
            String schemaSet = messageInfo.getSchemaSet();
            String schemaVersion = messageInfo.getSchemaVersion();
            if (schemaSet.toLowerCase().equals("unknown") || schemaVersion.toLowerCase().equals("unknown")) {
                return this.retrieveDefaultXSL();
            }
            SchemaData schemaData = this._schemataConfig.getSchemaBySetTypeVersion(schemaSet, messageInfo.getMessageType(), schemaVersion);
            if (schemaData == null || schemaData.getXslFile() == null) {
                return this.retrieveDefaultXSL();
            }
            return schemaData.getXslFile();
        }
        catch (Exception e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).length() == 0 ? "." : ": " + (String)msg;
            msg = "Could not retrieve XSL file for message" + (String)msg;
            IOException ioe = new IOException((String)msg);
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    private File retrieveDefaultXSL() {
        return new File(this._schemataConfig.getXslFolder(), "genericHtmlOutput.xsl");
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ShutdownService) {
            ShutdownService shutdownEvent = (ShutdownService)event;
            if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                this.shutdown();
            }
        }
    }

    @Override
    public String getServiceName() {
        return "EMailNotification";
    }
}

