/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.update;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;

public class CreateSequenceIfNotExists
implements CustomTaskChange {
    private static final String DB_POSTGRESQL = "postgresql";
    private static final String DB_ORACLE = "oracle";
    private static final String DB_HSQLDB = "hsqldb";
    private static final String DB_MSSQL = "mssql";
    private static final String DB_MYSQL = "mysql";
    private String sequenceName;
    private String tableName;
    private String columnName;
    private String confirmationMessage;

    public void execute(Database database) throws CustomChangeException {
        block65: {
            try {
                if (!(database.getConnection() instanceof JdbcConnection)) {
                    throw new CustomChangeException("Expected JDBC connection");
                }
                Connection jdbcConn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
                boolean sequenceExists = false;
                String queryCheck = switch (database.getShortName()) {
                    case DB_POSTGRESQL -> "SELECT 1 FROM information_schema.sequences WHERE UPPER(sequence_name) = ?";
                    case DB_ORACLE -> "SELECT 1 FROM all_sequences WHERE UPPER(sequence_name) = ?";
                    case DB_MSSQL -> "SELECT 1 FROM sys.sequences WHERE UPPER(name) = ?";
                    case DB_HSQLDB -> "SELECT 1 FROM INFORMATION_SCHEMA.SEQUENCES WHERE UPPER(SEQUENCE_NAME) = ?";
                    case DB_MYSQL -> "SELECT 1 FROM INFORMATION_SCHEMA.tables WHERE UPPER(TABLE_NAME) = ?";
                    default -> throw new CustomChangeException("Unsupported database: " + database.getShortName());
                };
                try (PreparedStatement checkStmt = jdbcConn.prepareStatement(queryCheck);){
                    checkStmt.setString(1, this.sequenceName);
                    try (ResultSet rs = checkStmt.executeQuery();){
                        sequenceExists = rs.next();
                    }
                }
                if (!sequenceExists) {
                    String[] stringArray;
                    long startWith = 1L;
                    String maxSql = "SELECT COALESCE(MAX(" + this.columnName + "), 0) + 1 FROM " + this.tableName;
                    try (Statement stmt = jdbcConn.createStatement();
                         Object rsMax = stmt.executeQuery(maxSql);){
                        if (rsMax.next()) {
                            startWith = rsMax.getLong(1);
                        }
                    }
                    switch (database.getShortName()) {
                        case "postgresql": 
                        case "oracle": 
                        case "hsqldb": {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = "CREATE SEQUENCE " + this.sequenceName + " START WITH " + startWith;
                            break;
                        }
                        case "mssql": {
                            String[] stringArray3 = new String[1];
                            stringArray = stringArray3;
                            stringArray3[0] = "CREATE SEQUENCE " + this.sequenceName + " START WITH " + startWith + " INCREMENT BY 1";
                            break;
                        }
                        case "mysql": {
                            String[] stringArray4 = new String[2];
                            stringArray4[0] = "CREATE TABLE " + this.sequenceName + " ( next_val BIGINT NOT NULL)";
                            stringArray = stringArray4;
                            stringArray4[1] = "INSERT INTO " + this.sequenceName + " VALUES (" + startWith + ")";
                            break;
                        }
                        default: {
                            throw new CustomChangeException("Unsupported database: " + database.getShortName());
                        }
                    }
                    String[] createSqlStatements = stringArray;
                    try (Statement stmt = jdbcConn.createStatement();){
                        for (String createStatement : createSqlStatements) {
                            stmt.execute(createStatement);
                        }
                    }
                    this.confirmationMessage = "Sequence '" + this.sequenceName + "' created with StartValue " + startWith;
                    break block65;
                }
                this.confirmationMessage = "Sequence '" + this.sequenceName + "' already exists";
            }
            catch (Exception e) {
                throw new CustomChangeException("Error creating sequence '" + this.sequenceName + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = new ValidationErrors();
        if (StringUtils.isBlank((CharSequence)this.sequenceName)) {
            errors.addError("sequenceName is required");
        }
        if (StringUtils.isBlank((CharSequence)this.tableName)) {
            errors.addError("tableName is required");
        }
        if (StringUtils.isBlank((CharSequence)this.columnName)) {
            errors.addError("columnName is required");
        }
        return errors;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName.toUpperCase();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName.toUpperCase();
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName.toUpperCase();
    }
}

