/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.certificate.ExtendedKeyUsage;
import de.ponton.xmlpipe.rest.certificate.SubjectAlternativeNameDto;
import de.pontonconsulting.xmlpipe.config.DatabaseType;
import de.pontonconsulting.xmlpipe.config.privatepartnerprofile.CertificateStatus;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PipelineIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.BackendPartnerId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerCertificateData;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfileData;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartyId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.SubjectAlternativeName;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PartnerProfileDAO
extends BaseDAO {
    public static final Logger LOG = LogManager.getLogger((String)"Messenger.PartnerProfileDAO");
    private final CertificateUtility certificateUtility;
    private final CertificateDtoFactory certificateDtoFactory;

    public PartnerProfileDAO(HibernateSessionFactory hibernateSessionFactory, CertificateUtility certificateUtility, CertificateDtoFactory certificateDtoFactory) {
        super(hibernateSessionFactory);
        this.certificateUtility = certificateUtility;
        this.certificateDtoFactory = certificateDtoFactory;
    }

    public List<PartnerProfile> getAllPartnerProfiles() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerProfile ORDER BY partnerId", PartnerProfile.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public boolean isPartnerRemote(String partnerId) {
        boolean bl;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT pp.remote FROM PartnerProfile pp WHERE pp.partnerId = :partnerId", Boolean.class);
                query.setParameter("partnerId", (Object)partnerId);
                bl = Boolean.TRUE.equals(query.getSingleResult());
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return false;
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public List<PartnerCertificateData> getAllPartnerCertificates() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerCertificateData ORDER BY partnerId", PartnerCertificateData.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<PartnerCertificateData> getAllValidPartnerCertificatesForPartnerId(String partnerId, OffsetDateTime now) {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerCertificateData WHERE partnerId = :partnerId AND revocationStatus = 'OK' AND :now BETWEEN validFrom AND validTo ORDER BY partnerId", PartnerCertificateData.class);
                query.setParameter("now", (Object)now);
                query.setParameter("partnerId", (Object)partnerId);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<PartnerCertificateData> getAllPartnerCertificatesForPartnerId(String partnerId) {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerCertificateData WHERE partnerId = :partnerId ORDER BY partnerId", PartnerCertificateData.class);
                query.setParameter("partnerId", (Object)partnerId);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public OffsetDateTime getPartnerLastChange(String partnerId) {
        OffsetDateTime offsetDateTime;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT pp.lastChange FROM PartnerProfile pp WHERE pp.partnerId = :partnerId", OffsetDateTime.class);
                query.setParameter("partnerId", (Object)partnerId);
                offsetDateTime = (OffsetDateTime)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return offsetDateTime;
    }

    public List<PartnerProfile> getAllLocalPartnerProfiles() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerProfile WHERE remote = false", PartnerProfile.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<PartnerProfile> getAllRemotePartnerProfiles() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerProfile WHERE remote = true", PartnerProfile.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<PartnerProfile> getAllRemotePartnerProfilesFromRegistry() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                String hql = DatabaseType.ORACLE.equals((Object)this.getDatabaseType()) ? "FROM PartnerProfile WHERE remote = true AND registryAutoupdate = true AND registryPath IS NOT NULL" : "FROM PartnerProfile WHERE remote = true AND registryAutoupdate = true AND registryPath IS NOT NULL AND registryPath <> ''";
                TypedQuery query = entityManager.createQuery(hql, PartnerProfile.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<PartnerProfile> getAllLocalPartnerProfilesFromRegistry() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                String hql = DatabaseType.ORACLE.equals((Object)this.getDatabaseType()) ? "FROM PartnerProfile WHERE remote = false AND registryPath IS NOT NULL" : "FROM PartnerProfile WHERE remote = false AND registryPath IS NOT NULL AND registryPath <> ''";
                TypedQuery query = entityManager.createQuery(hql, PartnerProfile.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public Optional<PartnerProfile> getPartnerProfile(String partnerId) {
        Optional<PartnerProfile> optional;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerProfile WHERE partnerId = :partnerId", PartnerProfile.class);
                query.setParameter("partnerId", (Object)partnerId);
                optional = Optional.ofNullable((PartnerProfile)query.getSingleResult());
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Optional.empty();
                }
            }
            entityManager.close();
        }
        return optional;
    }

    public PartnerProfileData getPartnerProfileData(String partnerId) throws ProfileStoreAccessException {
        PartnerProfileData partnerProfileData;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM PartnerProfileData WHERE partnerId = :partnerId", PartnerProfileData.class);
                query.setParameter("partnerId", (Object)partnerId);
                partnerProfileData = (PartnerProfileData)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    throw new ProfileStoreAccessException(-1, "No profile data found for partnerId: " + partnerId);
                }
            }
            entityManager.close();
        }
        return partnerProfileData;
    }

    public long storePartnerProfile(CppPartner cppPartner, String username) throws ProfileStoreAccessException {
        long lastChange = Instant.now().toEpochMilli();
        this.storePartnerProfile(cppPartner, lastChange, username);
        return lastChange;
    }

    public void storePartnerProfile(CppPartner cppPartner, long lastChange, String username) throws ProfileStoreAccessException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            ByteArrayOutputStream publicPart = new ByteArrayOutputStream();
            cppPartner.exportPublicPart(publicPart);
            ByteArrayOutputStream privatePart = new ByteArrayOutputStream();
            cppPartner.exportPrivatePart(privatePart);
            entityManager.getTransaction().begin();
            String partnerId = cppPartner.getLocalId();
            if (StringUtils.isBlank((CharSequence)cppPartner.getInternalId())) {
                throw new ProfileStoreAccessException(-1, "Internal ID is missing for partnerId: " + partnerId);
            }
            if (StringUtils.isBlank((CharSequence)partnerId)) {
                throw new ProfileStoreAccessException(-1, "Partner without local partnerId can't be stored (internalId= " + cppPartner.getInternalId() + ")");
            }
            entityManager.createQuery("DELETE PartyId WHERE partnerId = :partnerId").setParameter("partnerId", (Object)partnerId).executeUpdate();
            entityManager.createQuery("DELETE BackendPartnerId WHERE partnerId = :partnerId").setParameter("partnerId", (Object)partnerId).executeUpdate();
            entityManager.createQuery("DELETE PartnerCertificateData WHERE partnerId = :partnerId").setParameter("partnerId", (Object)partnerId).executeUpdate();
            entityManager.merge((Object)new PartnerProfile().setPartnerId(partnerId).setDisplayName(cppPartner.getDisplayName()).setRemote(cppPartner.isRemote()).setRegistryPath(cppPartner.getRemoteFile()).setRegistryAutoupdate(cppPartner.isAutoupdate()).setRegistryTimestamp(cppPartner.getLastModified() > 0L ? OffsetDateTime.ofInstant(Instant.ofEpochMilli(cppPartner.getLastModified()), ZoneId.of("UTC")) : null).setValid(cppPartner.isValid()).setDefaultCertificateId(cppPartner.getDefaultCertRefId()).setAs1DefaultCertificateId(this.safeGetCertificateId(cppPartner, "AS1")).setAs2DefaultCertificateId(this.safeGetCertificateId(cppPartner, "AS2")).setAs3DefaultCertificateId(this.safeGetCertificateId(cppPartner, "AS3")).setAs4DefaultCertificateId(this.safeGetCertificateId(cppPartner, "AS4")).setEbXmlDefaultCertificateId(this.safeGetCertificateId(cppPartner, "EbXml20")).setProcessingDefaultCertificateId(this.safeGetProcessingId(cppPartner, "Messenger 2.1")).setUsername(username).setLastChange(OffsetDateTime.ofInstant(Instant.ofEpochMilli(lastChange), ZoneOffset.UTC)).setBackendPartnerIds(Set.of(new BackendPartnerId().setPartnerId(partnerId).setBackendPartnerId(cppPartner.getInternalId()))).setPartyIds(cppPartner.getPartyIdList().stream().map(cppPartnerPartyId -> new PartyId().setPartnerId(partnerId).setPartyIdType(cppPartnerPartyId.getType()).setPartyIdId(cppPartnerPartyId.getValue())).collect(Collectors.toSet())));
            entityManager.merge((Object)new PartnerProfileData().setPartnerId(partnerId).setPublicProfile(publicPart.toByteArray()).setPrivateProfile(privatePart.toByteArray()));
            for (String certId : cppPartner.getCertificateIds()) {
                try {
                    X509Certificate x509Certificate = cppPartner.getX509Certificate(certId);
                    String certAlias = cppPartner.buildAliasForPartnerCertificate(x509Certificate);
                    Optional<CertificateStatus> status = cppPartner.getCertificateStatus(x509Certificate);
                    if (status.isEmpty()) {
                        status = cppPartner.getNewRevocationStatus(x509Certificate);
                    }
                    String revocationStatus = status.get().isRevoked() ? "REVOKED" : "OK";
                    long lastSuccessfulQueryMillis = status.get().getLastSuccessfulQuery();
                    if (lastSuccessfulQueryMillis <= 0L || lastSuccessfulQueryMillis > Instant.now().toEpochMilli()) {
                        lastSuccessfulQueryMillis = Instant.now().toEpochMilli();
                    }
                    OffsetDateTime lastSuccessfulQuery = OffsetDateTime.ofInstant(Instant.ofEpochMilli(lastSuccessfulQueryMillis), ZoneOffset.UTC);
                    byte[] encodedPrivateKey = null;
                    byte[] password = null;
                    if (!cppPartner.isRemote()) {
                        try {
                            SignCertInfo signCertInfo = cppPartner.getPrivateKey(certId);
                            PrivateKey privateKey = signCertInfo.getPrivateKey();
                            if (privateKey == null) {
                                LOG.error("Private key not found for certificate alias {}", (Object)certAlias);
                            } else {
                                PKCS8EncryptedPrivateKeyInfo privateKeyInfo = CryptoUtil.createPkcs8PrivateKeyInfo(cppPartner.getPrivateKeyPassword(certAlias), privateKey);
                                encodedPrivateKey = privateKeyInfo.getEncoded();
                            }
                        }
                        catch (ProfileException | IOException | CertificateException | OperatorCreationException e) {
                            LOG.error("Error while retrieving private key for certId {} : {}", (Object)certId, (Object)e.getMessage());
                        }
                        password = cppPartner.getEncryptedPrivateKeyPassword(certAlias);
                    }
                    String skiHexString = null;
                    try {
                        byte[] skiBytes = this.certificateUtility.getSKIBytesFromCert(x509Certificate);
                        skiHexString = Hex.encodeHexString((byte[])skiBytes);
                    }
                    catch (WSSecurityException wsse) {
                        LOG.error("Failed to get SKI bytes from certificate: {}", (Object)wsse.getMessage());
                    }
                    List<Object> sanDtos = new ArrayList();
                    try {
                        sanDtos = this.certificateDtoFactory.getSubjectAlternativeNames(x509Certificate);
                    }
                    catch (CertificateParsingException e) {
                        LOG.error("Failed to get subject alternative names from certificate: {}", (Object)e.getMessage());
                    }
                    ArrayList<ExtendedKeyUsage> extendedKeyUsages = new ArrayList();
                    try {
                        extendedKeyUsages = this.certificateDtoFactory.getExtendedKeyUsages(x509Certificate);
                    }
                    catch (CertificateParsingException e) {
                        LOG.error("Failed to get extended key usages from certificate: {}", (Object)e.getMessage());
                    }
                    try {
                        PartnerCertificateData certificateData = new PartnerCertificateData();
                        certificateData.setPartnerId(partnerId).setCertificate(x509Certificate.getEncoded()).setSubjectKeyIdentifier(skiHexString).setInternalCertId(certId).setSerial(x509Certificate.getSerialNumber().toString(16)).setIssuer(this.certificateUtility.getIssuer(x509Certificate)).setSubjectDn(this.certificateUtility.getSubject(x509Certificate)).setKeyPairAlgo(this.certificateUtility.getKeyAlgorithmInfo(x509Certificate)).setKeyUsage(this.certificateDtoFactory.getKeyUsages(x509Certificate)).setExtendedKeyUsage(extendedKeyUsages).setEncryptedPrivateKey(encodedPrivateKey).setPrivateKeyPassword(password).setValidFrom(x509Certificate.getNotBefore().toInstant().truncatedTo(ChronoUnit.SECONDS).atOffset(ZoneOffset.UTC)).setValidTo(x509Certificate.getNotAfter().toInstant().truncatedTo(ChronoUnit.SECONDS).atOffset(ZoneOffset.UTC)).setRevocationStatus(revocationStatus).setLastSuccessfulRevocationCheck(lastSuccessfulQuery);
                        entityManager.persist((Object)certificateData);
                        for (SubjectAlternativeNameDto subjectAlternativeNameDto : sanDtos) {
                            SubjectAlternativeName san = new SubjectAlternativeName().setPartnerCertificateDataId(certificateData.getPartnerCertificateDataId()).setNameType(subjectAlternativeNameDto.getType().toString()).setNameValue(subjectAlternativeNameDto.getValue());
                            entityManager.persist((Object)san);
                        }
                        LOG.debug("Certificate with ID {} for partnerId {} added to DB", (Object)certId, (Object)partnerId);
                    }
                    catch (CertificateEncodingException e) {
                        LOG.error("Certificate with ID {} for partnerId {} could not be added to DB: {}", (Object)certId, (Object)partnerId, (Object)e.getMessage());
                    }
                }
                catch (CertificateIdNotFoundException nfe) {
                    LOG.error("Certificate with ID {} not found for partnerId {}: {}", (Object)certId, (Object)partnerId, (Object)nfe.getMessage());
                }
            }
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            LOG.error("Failed to store partner profile for partnerId {} {}", (Object)cppPartner.getLocalId(), (Object)e.toString());
            throw e;
        }
    }

    public boolean doesPartnerProfileExist(String partnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT COUNT(pp) FROM PartnerProfile pp WHERE pp.partnerId = :partnerId", Long.class);
            query.setParameter("partnerId", (Object)partnerId);
            boolean bl = (Long)query.getSingleResult() > 0L;
            return bl;
        }
    }

    public boolean deletePartnerProfile(String partnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int count = entityManager.createQuery("DELETE FROM PartnerProfile WHERE partnerId = :partnerId").setParameter("partnerId", (Object)partnerId).executeUpdate();
            entityManager.getTransaction().commit();
            boolean bl = count > 0;
            return bl;
        }
    }

    public Optional<String> getPartnerIdForPartyId(String partyIdType, String partyIdId) {
        if ("E-Mail".equals(partyIdType)) {
            partyIdId = StringUtils.lowerCase((String)partyIdId);
        }
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("FROM PartyId WHERE partyIdType = :partyIdType AND partyIdId = :partyIdId", PartyId.class);
            query.setParameter("partyIdType", (Object)partyIdType);
            query.setParameter("partyIdId", (Object)partyIdId);
            List result = query.getResultList();
            Optional<String> optional = result.stream().findFirst().map(PartyId::getPartnerId);
            return optional;
        }
    }

    public long getRemotePartnerCount() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT COUNT(pp) FROM PartnerProfile pp WHERE pp.remote = true", Long.class);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    public long getLocalPartnerCount() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT COUNT(pp) FROM PartnerProfile pp WHERE pp.remote = false", Long.class);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    public SortedSet<String> getAllDistinctDisplayNamesExcludePartner(String partnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT DISTINCT pp.displayName FROM PartnerProfile pp WHERE pp.partnerId != :partnerId", String.class);
            query.setParameter("partnerId", (Object)partnerId);
            SortedSet sortedSet = query.getResultStream().collect(Collectors.toCollection(TreeSet::new));
            return sortedSet;
        }
    }

    public Optional<String> getPartnerIdForBackendPartnerId(String backendPartnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("FROM BackendPartnerId WHERE backendPartnerId = :backendPartnerId", BackendPartnerId.class);
            query.setParameter("backendPartnerId", (Object)backendPartnerId);
            List result = query.getResultList();
            Optional<String> optional = result.stream().findFirst().map(BackendPartnerId::getPartnerId);
            return optional;
        }
    }

    public SortedSet<String> getPartnerIdsOfAllLocalPartners() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT pp.partnerId FROM PartnerProfile pp WHERE pp.remote = false", String.class);
            SortedSet sortedSet = query.getResultStream().collect(Collectors.toCollection(TreeSet::new));
            return sortedSet;
        }
    }

    public SortedSet<String> getPartnerIdsOfAllRemotePartners() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT pp.partnerId FROM PartnerProfile pp WHERE pp.remote = true", String.class);
            SortedSet sortedSet = query.getResultStream().collect(Collectors.toCollection(TreeSet::new));
            return sortedSet;
        }
    }

    public Set<String> getBackendPartnerIdsOfAllRemotePartners() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT bpi.backendPartnerId FROM BackendPartnerId bpi, PartnerProfile pp WHERE pp.remote = false AND pp.partnerId = bpi.partnerId", String.class);
            Set set = query.getResultStream().collect(Collectors.toCollection(TreeSet::new));
            return set;
        }
    }

    public Set<String> getBackendPartnerIdsOfAllLocalPartners() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT bpi.backendPartnerId FROM BackendPartnerId bpi, PartnerProfile pp WHERE pp.remote = true AND pp.partnerId = bpi.partnerId", String.class);
            Set set = query.getResultStream().collect(Collectors.toCollection(TreeSet::new));
            return set;
        }
    }

    public Set<String> getBackendPartnerIdsOfAllPartners() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT bpi.backendPartnerId FROM BackendPartnerId bpi", String.class);
            Set set = query.getResultStream().collect(Collectors.toCollection(TreeSet::new));
            return set;
        }
    }

    public Optional<String> getPartnerIdForRegistryPath(String registryPath) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT pp.partnerId FROM PartnerProfile pp WHERE pp.registryPath = :registryPath", String.class);
            query.setParameter("registryPath", (Object)registryPath);
            Optional<String> optional = query.getResultList().stream().findFirst();
            return optional;
        }
    }

    public List<PartnerCertificateData> getLocalPartnerCertificateDataByExtendedKeyUsage(ExtendedKeyUsage extendedKeyUsage) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            String queryString = "SELECT pcd FROM PartnerCertificateData pcd JOIN PartnerProfile pp ON pcd.partnerId = pp.partnerId WHERE pcd.extendedKeyUsage LIKE :extendedKeyUsage AND pp.remote = false";
            TypedQuery query = entityManager.createQuery(queryString, PartnerCertificateData.class);
            query.setParameter("extendedKeyUsage", (Object)("%" + String.valueOf((Object)extendedKeyUsage) + "%"));
            List list = query.getResultList();
            return list;
        }
    }

    private String safeGetCertificateId(CppPartner partner, String packageName) {
        try {
            return partner.getPackagingCertificateId(packageName);
        }
        catch (PackageIdNotFoundException e) {
            LOG.warn("Failed to retrieve packaging certificate ID: {}", (Object)e.getMessage());
            return null;
        }
    }

    private String safeGetProcessingId(CppPartner partner, String pipelineId) {
        try {
            return partner.getPipelineCertRef(pipelineId);
        }
        catch (PipelineIdNotFoundException e) {
            LOG.warn("Failed to retrieve processing certificate ID: {}", (Object)e.getMessage());
            return null;
        }
    }

    public List<PartnerProfile> getAllPartnerProfiles(Optional<String> internalId, Optional<Boolean> isLocal, Optional<String> displayName) {
        List list;
        block13: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                StringBuilder queryBuilder = new StringBuilder("SELECT pp FROM PartnerProfile pp");
                boolean needsJoin = internalId.isPresent();
                if (needsJoin) {
                    queryBuilder.append(", BackendPartnerId bpi");
                }
                ArrayList<String> conditions = new ArrayList<String>();
                if (internalId.isPresent()) {
                    conditions.add("pp.partnerId = bpi.partnerId AND bpi.backendPartnerId = :internalId");
                }
                if (isLocal.isPresent()) {
                    conditions.add("pp.remote = :remote");
                }
                if (displayName.isPresent()) {
                    conditions.add("pp.displayName LIKE :displayName");
                }
                if (!conditions.isEmpty()) {
                    queryBuilder.append(" WHERE ").append(String.join((CharSequence)" AND ", conditions));
                }
                queryBuilder.append(" ORDER BY pp.partnerId");
                TypedQuery query = entityManager.createQuery(queryBuilder.toString(), PartnerProfile.class);
                internalId.ifPresent(s -> query.setParameter("internalId", s));
                isLocal.ifPresent(aBoolean -> query.setParameter("remote", (Object)(aBoolean == false ? 1 : 0)));
                displayName.ifPresent(s -> query.setParameter("displayName", (Object)("%" + s + "%")));
                list = query.getResultList();
                if (entityManager == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }
}

