/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.DatabaseType;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class OutboundQueueMessageDAO
extends BaseDAO {
    public static final int STATUS_DB_CHECK = -1;
    public static final int STATUS_ENQUEUED = 0;
    public static final int STATUS_IN_TRANSFER = 1;
    public static final int STATUS_DELAYED = 2;
    public static final int STATUS_FINISHED = 99;
    private final MessengerConfig _messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private final MessageDAO messageDAO;
    private Runnable messageEnqueuedNotifier;
    private Function<Long, OutboundQueueMessage> messageFinishedNotifier;

    public OutboundQueueMessageDAO(HibernateSessionFactory hibernateSessionFactory, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask, MessageDAO messageDAO) {
        super(hibernateSessionFactory);
        this._messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
        this.messageDAO = messageDAO;
    }

    public void enqueue(XpMessage xpMessage) throws DbException {
        this.enqueue(xpMessage, null, 0);
    }

    public void enqueue(XpMessage xpMessage, Long timeToLive, int priority) throws DbException {
        OutboundQueueMessage outboundQueue = new OutboundQueueMessage();
        outboundQueue.setStatus(0);
        outboundQueue.setMessageId(xpMessage.getDatabaseId());
        outboundQueue.setReceiverId(xpMessage.getReceiverLocalId());
        outboundQueue.setPriority(priority);
        outboundQueue.setTimeToLive(OutboundQueueMessageDAO.toOffsetDateTime(timeToLive));
        outboundQueue.setEnqueueTime(this.getNow());
        outboundQueue.setMessengerId(xpMessage.getMessengerId());
        this.enqueue(outboundQueue);
    }

    void enqueue(OutboundQueueMessage outboundQueue) throws DbException {
        if (Objects.isNull(outboundQueue.getMessageId()) || outboundQueue.getMessageId() < 0L) {
            throw new DbException(13013, "Can't enqueue OutboundMessage for receiver '" + outboundQueue.getReceiverId() + "' without messageId (" + outboundQueue.getMessageId() + ")");
        }
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)outboundQueue);
            this.messageDAO.updateMessageStatusInSameTransaction(outboundQueue.getMessageId(), 2, entityManager);
            entityManager.getTransaction().commit();
            if (Objects.nonNull(this.messageEnqueuedNotifier)) {
                this.messageEnqueuedNotifier.run();
            }
        }
        catch (RuntimeException e) {
            throw new DbException(13013, "Can't enqueue OutboundMessage (" + outboundQueue.getMessageId() + "): " + e.getMessage(), e);
        }
    }

    public void setTimeToLive(long messageDatabaseId, long timeToLive) throws DbException {
        block9: {
            try (EntityManager entityManager = this.createNewEntityManager();){
                entityManager.getTransaction().begin();
                int result = entityManager.createQuery("UPDATE OutboundQueueMessage\nSET timeToLive = :timeToLive\nWHERE messageId = :messageId\n").setParameter("timeToLive", (Object)OutboundQueueMessageDAO.toOffsetDateTime(timeToLive)).setParameter("messageId", (Object)messageDatabaseId).executeUpdate();
                if (result == 1) {
                    entityManager.getTransaction().commit();
                    break block9;
                }
                entityManager.getTransaction().rollback();
                throw new IllegalStateException("Message with id " + messageDatabaseId + " does not exist in the outbound queue.");
            }
            catch (RuntimeException e) {
                throw new DbException(-1, "Could not set timeToLive for OutboundMessage (" + messageDatabaseId + "): " + e.getMessage());
            }
        }
    }

    public List<String> getReceiverWithQueuedMessages() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List results;
                list = results = entityManager.createQuery("SELECT DISTINCT receiverId\nFROM OutboundQueueMessage\nWHERE (status = 0 AND receiverId NOT IN (SELECT partnerId FROM RemoteMaintenanceInterval WHERE startTime <= :timestamp AND :timestamp <= endTime)\n       OR (status = 1 AND messengerId = :messengerId))\n", String.class).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).setParameter("timestamp", (Object)this.referenceDateTask.getReferenceDate().getTime()).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select receivers with pending messages: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<String> getReceiverWithInTransitMessages() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List results;
                list = results = entityManager.createQuery("SELECT DISTINCT receiverId\nFROM OutboundQueueMessage\nWHERE status = 1 AND messengerId = :messengerId\n", String.class).setParameter("timestamp", (Object)this.referenceDateTask.getReferenceDate().getTime()).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select receivers with pending messages: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<OutboundQueueMessage> getOwnMessagesInTransfer() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List messages;
                list = messages = entityManager.createQuery("FROM OutboundQueueMessage\nWHERE status = :status AND messengerId = :messengerId\n", OutboundQueueMessage.class).setParameter("status", (Object)1).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select messages with status 'IN TRANSFER' of messenger " + this._messengerConfig.getMessengerId() + ": " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public OutboundQueueMessage getMessage(long messageId) throws DbException {
        OutboundQueueMessage outboundQueueMessage;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                OutboundQueueMessage nextMessage;
                outboundQueueMessage = nextMessage = (OutboundQueueMessage)entityManager.find(OutboundQueueMessage.class, (Object)messageId);
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select OutboundMessage " + messageId + ": " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return outboundQueueMessage;
    }

    public OutboundQueueMessage getMessageInTransfer(long messageId) throws DbException {
        OutboundQueueMessage outboundQueueMessage;
        block9: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                OutboundQueueMessage msg;
                outboundQueueMessage = msg = (OutboundQueueMessage)entityManager.createQuery("FROM OutboundQueueMessage\nWHERE messageId = :messageId AND status = :status AND messengerId = :messengerId\n", OutboundQueueMessage.class).setParameter("messageId", (Object)messageId).setParameter("status", (Object)1).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).getSingleResult();
                if (entityManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException ignore) {
                    return null;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select OutboundMessage " + messageId + " with status IN TRANSFER: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return outboundQueueMessage;
    }

    public List<Long> selectNextMessageIds(String receiverId, int messageCount) throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List resultList;
                list = resultList = entityManager.createQuery("SELECT messageId\nFROM OutboundQueueMessage\nWHERE status = :status AND receiverId = :receiverId\nORDER BY priority DESC, messageId ASC\n", Long.class).setParameter("status", (Object)0).setParameter("receiverId", (Object)receiverId).setMaxResults(messageCount).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select next messageIds of receiver " + receiverId + ": " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startTransfer(long messageId) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            String selectAndLockSql = switch (this.getDatabaseType()) {
                case DatabaseType.ORACLE, DatabaseType.POSTGRESQL, DatabaseType.MYSQL -> "SELECT MESSAGE_ID\nFROM OUTBOUND_QUEUE\nWHERE MESSAGE_ID = ? AND STATUS = 0\nFOR UPDATE SKIP LOCKED\n";
                case DatabaseType.MSSQL -> "SELECT MESSAGE_ID\nFROM OUTBOUND_QUEUE WITH (UPDLOCK, READPAST)\nWHERE MESSAGE_ID = ? AND STATUS = 0\n";
                default -> "SELECT MESSAGE_ID\nFROM OUTBOUND_QUEUE\nWHERE MESSAGE_ID = ? AND STATUS = 0\nFOR UPDATE\n";
            };
            List messageIds = entityManager.createNativeQuery(selectAndLockSql, Long.class).setParameter(1, (Object)messageId).getResultList();
            if (messageIds.isEmpty() || messageIds.getFirst() == null) {
                entityManager.getTransaction().rollback();
                _log.debug("The queued outbound message '{}' is already in transit.", (Object)messageId);
                boolean bl = false;
                return bl;
            }
            int updateCount = entityManager.createQuery("UPDATE OutboundQueueMessage\nSET status = :inTransferStatus, lastTransmission = :now, messengerId = :messengerId\nWHERE messageId = :messageId AND status = :enqueuedStatus\n").setParameter("inTransferStatus", (Object)1).setParameter("now", (Object)this.getNow()).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).setParameter("messageId", (Object)messageId).setParameter("enqueuedStatus", (Object)0).executeUpdate();
            if (updateCount == 0) {
                entityManager.getTransaction().rollback();
                _log.debug("Message '{}' already in transfer.", (Object)messageId);
                boolean bl = false;
                return bl;
            }
            entityManager.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            throw new DbException(13003, "Can't start transfer for message: " + e.getMessage(), e);
        }
    }

    private OffsetDateTime getNow() {
        return this.referenceDateTask.getReferenceOffsetDateTime();
    }

    static OffsetDateTime toOffsetDateTime(Long millis) {
        return Objects.isNull(millis) ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    public boolean finishMessage(long messageId) throws DbException {
        return this.finishMessage(messageId, true);
    }

    public boolean finishMessageWithoutNotify(long messageId) throws DbException {
        return this.finishMessage(messageId, false);
    }

    private boolean finishMessage(long messageId, boolean withNotify) throws DbException {
        boolean bl;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                boolean finished = this.finishMessage(messageId, entityManager, withNotify);
                entityManager.getTransaction().commit();
                bl = finished;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13011, "Can't finish OutboundMessage (" + messageId + "): " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public OutboundQueueMessage finishMessageWithResult(long messageId) throws DbException {
        OutboundQueueMessage msg = Objects.nonNull(this.messageFinishedNotifier) ? this.messageFinishedNotifier.apply(messageId) : null;
        this.finishMessage(messageId);
        if (Objects.isNull(msg)) {
            msg = this.getMessage(messageId);
        }
        return msg;
    }

    public boolean finishMessage(long messageId, EntityManager entityManager) throws DbException {
        return this.finishMessage(messageId, entityManager, true);
    }

    private boolean finishMessage(long messageId, EntityManager entityManager, boolean withNotify) throws DbException {
        boolean finished;
        boolean bl = finished = 1 == entityManager.createQuery("UPDATE OutboundQueueMessage\nSET status = :status\nWHERE messageId = :messageId\n").setParameter("status", (Object)99).setParameter("messageId", (Object)messageId).executeUpdate();
        if (finished && withNotify && Objects.nonNull(this.messageFinishedNotifier)) {
            this.messageFinishedNotifier.apply(messageId);
        }
        return finished;
    }

    public int finishMessages(Collection<Long> messageIds, EntityManager entityManager) {
        int finished = entityManager.createQuery("UPDATE OutboundQueueMessage\nSET status = :status\nWHERE messageId IN :messageIds\n").setParameter("status", (Object)99).setParameter("messageIds", messageIds).executeUpdate();
        if (Objects.nonNull(this.messageFinishedNotifier)) {
            messageIds.forEach(messageId -> this.messageFinishedNotifier.apply((Long)messageId));
        }
        return finished;
    }

    public int deleteFinishMessages() throws DbException {
        int n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int deleteCount = entityManager.createQuery("DELETE OutboundQueueMessage\nWHERE status = :status AND messengerId = :messengerId\n").setParameter("status", (Object)99).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).executeUpdate();
                entityManager.getTransaction().commit();
                n = deleteCount;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13011, "Can't delete FINISHED OutboundMessage: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return n;
    }

    public boolean deleteMessage(long messageId) throws DbException {
        boolean bl;
        block9: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int deleteCount = entityManager.createQuery("DELETE OutboundQueueMessage\nWHERE messageId = :messageId\n").setParameter("messageId", (Object)messageId).executeUpdate();
                entityManager.getTransaction().commit();
                if (Objects.nonNull(this.messageFinishedNotifier)) {
                    this.messageFinishedNotifier.apply(messageId);
                }
                boolean bl2 = bl = deleteCount == 1;
                if (entityManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13011, "Can't delete OutboundMessage (" + messageId + "): " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public boolean rescheduleMessage(long messageId) throws DbException {
        boolean bl;
        block9: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int rescheduleCount = entityManager.createQuery("UPDATE OutboundQueueMessage\nSET status = :enqueuedStatus, timeToLive = null\nWHERE messageId = :messageId AND status != :finishedStatus\n").setParameter("enqueuedStatus", (Object)0).setParameter("messageId", (Object)messageId).setParameter("finishedStatus", (Object)99).executeUpdate();
                entityManager.getTransaction().commit();
                if (rescheduleCount == 1 && Objects.nonNull(this.messageEnqueuedNotifier)) {
                    this.messageEnqueuedNotifier.run();
                }
                boolean bl2 = bl = rescheduleCount == 1;
                if (entityManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13017, "Can't reschedule OutboundMessage (" + messageId + "): " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public int getQueueSize() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            int n = ((Long)entityManager.createQuery("SELECT COUNT(*)\nFROM OutboundQueueMessage\nWHERE status != :status\n", Long.class).setParameter("status", (Object)99).getSingleResult()).intValue();
            return n;
        }
    }

    public void dbConsistencyCheck(Message testMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            OutboundQueueMessage outboundQueue = new OutboundQueueMessage();
            outboundQueue.setStatus(-1);
            outboundQueue.setMessageId(testMessage.getId());
            outboundQueue.setReceiverId(testMessage.getReceiverId());
            outboundQueue.setPriority(-1);
            outboundQueue.setEnqueueTime(this.getNow());
            entityManager.persist((Object)outboundQueue);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13042, "DB Consistency check for table 'OUTBOUND_QUEUE' failed. Reason: " + e.getMessage(), e);
        }
    }

    public void setMessageEnqueuedNotifier(Runnable messageEnqueuedNotifier) {
        this.messageEnqueuedNotifier = messageEnqueuedNotifier;
    }

    public void setMessageFinishedNotifier(Function<Long, OutboundQueueMessage> messageFinishedNotifier) {
        this.messageFinishedNotifier = messageFinishedNotifier;
    }

    public boolean containsMessages(Collection<Long> messageDataIds, EntityManager entityManager) {
        return ((Long)entityManager.createQuery("SELECT COUNT(*)\nFROM OutboundQueueMessage\nWHERE messageId IN :messageIds\n", Long.class).setParameter("messageIds", messageDataIds).getSingleResult()).intValue() > 0;
    }

    public List<OutboundQueueMessage> getExpiredMessages(List<Integer> stoppedMessengerIds) throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                List messages;
                list = messages = entityManager.createQuery("FROM OutboundQueueMessage\nWHERE status = :status AND (timeToLive <= :now OR timeToLive IS NULL) AND messengerId IN :messengerIds\n", OutboundQueueMessage.class).setParameter("status", (Object)1).setParameter("now", (Object)this.referenceDateTask.getReferenceOffsetDateTime()).setParameter("messengerIds", stoppedMessengerIds).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13008, "Can't select expired messages: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public boolean resetTransmissionState(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery("UPDATE OutboundQueueMessage\nSET status = :enqueuedStatus, timeToLive = null, lastTransmission = null, messengerId = null\nWHERE messageId = :messageId AND status = :inTransferStatus\n").setParameter("enqueuedStatus", (Object)0).setParameter("messageId", (Object)messageId).setParameter("inTransferStatus", (Object)1).executeUpdate();
            if (updateCount == 0) {
                _log.warn("No OutboundQueue message found to reset (messageId={} / status=1)", (Object)messageId);
            } else {
                _log.trace("TransmissionState of InboundQueue message (messageId={}) reset", (Object)messageId);
            }
            entityManager.getTransaction().commit();
            boolean bl = updateCount == 1;
            return bl;
        }
    }
}

