/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerAddOnAdapter;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerAddOnConfig;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PlugableAdapterConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Optional;

public class MessengerAddOnDAO
extends BaseDAO {
    public MessengerAddOnDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public void storeMessengerAddOnAdapter(MessengerAddOnAdapter adapter) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            MessengerAddOnAdapter entity = (MessengerAddOnAdapter)entityManager.find(MessengerAddOnAdapter.class, (Object)adapter.getFilename());
            if (entity == null) {
                entityManager.persist((Object)adapter);
            } else if (adapter.getTimestamp().isAfter(entity.getTimestamp())) {
                entity.setData(adapter.getData());
                entity.setTimestamp(adapter.getTimestamp());
                entityManager.merge((Object)entity);
            }
            entityManager.getTransaction().commit();
        }
    }

    public void storeMessengerAddOnConfig(MessengerAddOnConfig config) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            MessengerAddOnConfig entity = (MessengerAddOnConfig)entityManager.find(MessengerAddOnConfig.class, (Object)config.getFilename());
            if (entity == null) {
                entityManager.persist((Object)config);
            } else if (config.getTimestamp().isAfter(entity.getTimestamp())) {
                entity.setData(config.getData());
                entity.setTimestamp(config.getTimestamp());
                entityManager.merge((Object)entity);
            }
            entityManager.getTransaction().commit();
        }
    }

    public List<MessengerAddOnConfig> loadAllConfigs() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("from MESSENGER_ADD_ON_CONFIG", MessengerAddOnConfig.class).getResultList();
            return list;
        }
    }

    public List<MessengerAddOnAdapter> loadAllAdapters() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("from MESSENGER_ADD_ON_ADAPTER", MessengerAddOnAdapter.class).getResultList();
            return list;
        }
    }

    public void storePlugableAdapterConfig(PlugableAdapterConfig config) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            PlugableAdapterConfig entity = (PlugableAdapterConfig)entityManager.find(PlugableAdapterConfig.class, (Object)config.getFilename());
            if (entity == null) {
                entityManager.persist((Object)config);
            } else if (config.getTimestamp().isAfter(entity.getTimestamp())) {
                entity.setData(config.getData());
                entity.setTimestamp(config.getTimestamp());
                entityManager.merge((Object)entity);
            }
            entityManager.getTransaction().commit();
        }
    }

    public void deletePlugableAdapterConfig(String filename) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            PlugableAdapterConfig entity = (PlugableAdapterConfig)entityManager.find(PlugableAdapterConfig.class, (Object)filename);
            if (entity != null) {
                entityManager.remove((Object)entity);
            }
            entityManager.getTransaction().commit();
        }
    }

    public List<PlugableAdapterConfig> loadAllPlugableAdapterConfigs() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("from PLUGABLE_ADAPTER_CONFIG", PlugableAdapterConfig.class).getResultList();
            return list;
        }
    }

    public Optional<PlugableAdapterConfig> loadPlugableAdapterConfig(String filename) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Optional<PlugableAdapterConfig> optional = Optional.ofNullable((PlugableAdapterConfig)entityManager.find(PlugableAdapterConfig.class, (Object)filename));
            return optional;
        }
    }
}

