/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.DatabaseType;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageWorkData;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageWorkDataId;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BlockInputStream;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;

public class MessageWorkDataDAO
extends BaseDAO {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageWorkDataDAO.class.getSimpleName()));
    private static final long MAX_MESSAGE_SIZE = 0x400000L;

    public MessageWorkDataDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    MessageWorkData loadMessageWorkData(long messageDbId, String type) {
        MessageWorkData messageWorkData;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                messageWorkData = (MessageWorkData)entityManager.find(MessageWorkData.class, (Object)new MessageWorkDataId(messageDbId, type, 0));
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return messageWorkData;
    }

    public int cleanupMessageWorkData(long messageDbId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int deleteCount = entityManager.createNativeQuery("DELETE FROM MESSAGE_WORK_DATA WHERE MESSAGE_ID = :messageDbId").setParameter("messageDbId", (Object)messageDbId).executeUpdate();
            LOG.info("Deleted {} MessageWorkData records of messageDbId {}", (Object)deleteCount, (Object)messageDbId);
            entityManager.getTransaction().commit();
            int n = deleteCount;
            return n;
        }
    }

    public void uploadMessageArtifactToDB(long messageDbId, File artifact) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            ((Session)entityManager.unwrap(Session.class)).doReturningWork(connection -> {
                try (PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM MESSAGE_WORK_DATA WHERE MESSAGE_ID = ? AND TYPE = ?");){
                    try {
                        this.uploadData(messageDbId, artifact, artifact.getParentFile().toPath(), deleteStatement, connection, new AtomicInteger(0));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            });
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            throw new DbException(13022, "Can't upload message artifact to DB for messageId " + messageDbId + ": " + e.getMessage(), e);
        }
    }

    public int uploadDirectoryToDB(long messageDbId, File directory) throws DbException {
        if (Objects.isNull(directory)) {
            LOG.warn("Message work directory does not exist for message {}", (Object)messageDbId);
            return 0;
        }
        File[] files = directory.listFiles();
        if (Objects.isNull(files) || files.length == 0) {
            LOG.warn("No files found in directory {}", (Object)directory.getAbsolutePath());
            return 0;
        }
        AtomicInteger uploadCount = new AtomicInteger();
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            ((Session)entityManager.unwrap(Session.class)).doReturningWork(connection -> {
                Path baseDirectory = directory.toPath();
                try (PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM MESSAGE_WORK_DATA WHERE MESSAGE_ID = ? AND TYPE = ?");){
                    for (File file : files) {
                        try {
                            this.uploadFile(messageDbId, file, baseDirectory, deleteStatement, connection, uploadCount);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                return true;
            });
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            throw new DbException(13022, "Can't upload WorkFolder to DB for messageId " + messageDbId + ": " + e.getMessage(), e);
        }
        return uploadCount.get();
    }

    private void uploadFile(long messageDbId, File file, Path baseDirectory, PreparedStatement deleteStatement, Connection connection, AtomicInteger uploadCount) throws SQLException, IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (Objects.nonNull(files)) {
                for (File directoryFile : files) {
                    this.uploadFile(messageDbId, directoryFile, baseDirectory, deleteStatement, connection, uploadCount);
                }
            }
        } else {
            this.uploadData(messageDbId, file, baseDirectory, deleteStatement, connection, uploadCount);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadData(long messageDbId, File file, Path baseDirectory, PreparedStatement deleteStatement, Connection connection, AtomicInteger uploadCount) throws SQLException, IOException {
        String type = baseDirectory.relativize(file.toPath()).toString().replace(File.separatorChar, '|');
        deleteStatement.setLong(1, messageDbId);
        deleteStatement.setString(2, type);
        int deleted = deleteStatement.executeUpdate();
        if (deleted > 0) {
            LOG.debug("Deleted old WorkData [{} | {}]", (Object)messageDbId, (Object)type);
        }
        int index = 0;
        try {
            try (DeflaterInputStream fis = new DeflaterInputStream(new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
                 BlockInputStream blockInputStream = new BlockInputStream(fis, 0x400000L);){
                while (blockInputStream.hasNext()) {
                    PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO MESSAGE_WORK_DATA (MESSAGE_ID, TYPE, DATA, PART, LAST_MODIFIED) VALUES (?, ?, ?, ?, ?)");
                    try {
                        insertStatement.setLong(1, messageDbId);
                        insertStatement.setString(2, type);
                        insertStatement.setBinaryStream(3, blockInputStream);
                        insertStatement.setInt(4, index);
                        insertStatement.setObject(5, OffsetDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), ZoneOffset.UTC));
                        insertStatement.executeUpdate();
                        ++index;
                    }
                    finally {
                        if (insertStatement == null) continue;
                        insertStatement.close();
                    }
                }
            }
            uploadCount.incrementAndGet();
            LOG.debug("Inserted new WorkData [{} | {}]", (Object)messageDbId, (Object)type);
            return;
        }
        catch (IOException e) {
            if (file.exists()) throw e;
            LOG.debug("File '{}' was deleted from WorkFolder already", (Object)file.getName());
            return;
        }
    }

    public int restoreDirectoryFromDB(long messageDbId, File directory) throws DbException {
        int n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                n = (Integer)((Session)entityManager.unwrap(Session.class)).doReturningWork(connection -> {
                    boolean isAutoCommit = connection.getAutoCommit();
                    connection.setAutoCommit(false);
                    int count = 0;
                    boolean recordsFound = false;
                    try (PreparedStatement select = connection.prepareStatement("SELECT TYPE, LAST_MODIFIED, PART, DATA FROM MESSAGE_WORK_DATA WHERE MESSAGE_ID = ? ORDER BY TYPE, PART", 1003, 1007);){
                        select.setLong(1, messageDbId);
                        select.setFetchSize(this.getDatabaseType() == DatabaseType.MYSQL ? Integer.MIN_VALUE : 1);
                        try (ResultSet resultSet = select.executeQuery();){
                            String currentType = null;
                            String fileName = null;
                            File outputFile = null;
                            OutputStream outputStream = null;
                            long lastModified = 0L;
                            boolean fileWritten = false;
                            while (resultSet.next()) {
                                long dbLastModified;
                                recordsFound = true;
                                String type = resultSet.getString("TYPE");
                                Timestamp timestamp = resultSet.getTimestamp("LAST_MODIFIED");
                                long l = dbLastModified = timestamp == null ? 0L : Math.max(timestamp.getTime(), 0L);
                                if (!type.equals(currentType)) {
                                    if (outputStream != null) {
                                        outputStream.flush();
                                        outputStream.close();
                                        if (fileWritten) {
                                            outputFile.setLastModified(lastModified);
                                            ++count;
                                            LOG.debug("Downloaded WorkData [{} | {}]", (Object)messageDbId, (Object)fileName);
                                        }
                                    }
                                    currentType = type;
                                    fileName = type.replace('|', File.separatorChar);
                                    outputFile = directory.toPath().resolve(fileName).toFile();
                                    lastModified = dbLastModified;
                                    fileWritten = false;
                                    if (!outputFile.exists() || lastModified != outputFile.lastModified()) {
                                        outputFile.getParentFile().mkdirs();
                                        if (outputFile.exists()) {
                                            LOG.warn("File [{}] already exists and will be overwritten", (Object)outputFile.getAbsolutePath());
                                        }
                                        outputStream = new InflaterOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
                                    } else {
                                        LOG.debug("Skip download of WorkData [{} | {}] because target file exists and is not changed", (Object)messageDbId, (Object)fileName);
                                        outputStream = null;
                                    }
                                }
                                if (outputStream == null) continue;
                                InputStream inputStream = resultSet.getBinaryStream("DATA");
                                try {
                                    inputStream.transferTo(outputStream);
                                    fileWritten = true;
                                }
                                finally {
                                    if (inputStream == null) continue;
                                    inputStream.close();
                                }
                            }
                            if (outputStream != null) {
                                outputStream.flush();
                                outputStream.close();
                                if (fileWritten) {
                                    outputFile.setLastModified(lastModified);
                                    ++count;
                                    LOG.debug("Downloaded WorkData [{} | {}]", (Object)messageDbId, fileName);
                                }
                            }
                        }
                    }
                    catch (IOException | SQLException e) {
                        throw new PersistenceException("Can't restore WorkFolder '" + String.valueOf(directory) + "' from DB for messageId " + messageDbId, (Throwable)e);
                    }
                    finally {
                        connection.setAutoCommit(isAutoCommit);
                    }
                    return recordsFound ? count : -1;
                });
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DbException(13022, "Cannot read file from archive from DB for id " + messageDbId, e);
                }
            }
            entityManager.close();
        }
        return n;
    }
}

