/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificateId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerFTPUser;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import java.security.cert.CRLReason;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListenerConfigDAO
extends BaseDAO {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ListenerConfigDAO");
    private static final String PARAM_NOW = "now";
    private static final String PARAM_ALIAS = "alias";
    private static final String PARAM_TYPE = "type";

    public ListenerConfigDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public void saveFtpUser(String name, String password, String partnerLocalId, String username) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            ListenerFTPUser user = (ListenerFTPUser)entityManager.find(ListenerFTPUser.class, (Object)name);
            if (Objects.isNull(user)) {
                user = new ListenerFTPUser();
                user.setName(name);
            }
            user.setPassword(password);
            user.setPartnerLocalId(partnerLocalId);
            user.setUsername(username);
            user.setLastChange(OffsetDateTime.now(ZoneOffset.UTC));
            entityManager.persist((Object)user);
            entityManager.getTransaction().commit();
        }
    }

    public void importFtpUser(ListenerFTPUser listenerFTPUser) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)listenerFTPUser);
            entityManager.getTransaction().commit();
        }
    }

    public ListenerFTPUser loadFtpUser(String name) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            ListenerFTPUser listenerFTPUser = (ListenerFTPUser)entityManager.find(ListenerFTPUser.class, (Object)name);
            return listenerFTPUser;
        }
    }

    public List<ListenerFTPUser> loadFtpUsers() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("FROM ListenerFTPUser ORDER BY name", ListenerFTPUser.class).getResultList();
            return list;
        }
    }

    public void saveListenerCertificate(ListenerCertificate listenerCertificate) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)listenerCertificate);
            entityManager.getTransaction().commit();
        }
    }

    public ListenerCertificate loadListenerCertificate(String alias, ListenerCertificate.Type type) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            ListenerCertificate listenerCertificate = (ListenerCertificate)entityManager.find(ListenerCertificate.class, (Object)new ListenerCertificateId(alias, type));
            return listenerCertificate;
        }
    }

    public List<ListenerCertificate> loadListenerCertificatesByType(ListenerCertificate.Type type) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("FROM ListenerCertificate WHERE aliasAndType.type = :type", ListenerCertificate.class).setParameter(PARAM_TYPE, (Object)type).getResultList();
            return list;
        }
    }

    public List<ListenerCertificate> loadListenerCertificates() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("FROM ListenerCertificate", ListenerCertificate.class).getResultList();
            return list;
        }
    }

    public List<String> loadListenerCertificateAliasesByType(ListenerCertificate.Type type) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("SELECT aliasAndType.alias FROM ListenerCertificate WHERE aliasAndType.type = :type", String.class).setParameter(PARAM_TYPE, (Object)type).getResultList();
            return list;
        }
    }

    public void setListenerCertificateTRUSTED(String alias, ListenerCertificate.Type type) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("UPDATE ListenerCertificate\nSET status=:status, crlReason=null, lastCheck=:now, lastSuccessfulCheck=:now\nWHERE aliasAndType.alias=:alias AND aliasAndType.type=:type").setParameter("status", (Object)ListenerCertificate.Status.TRUSTED).setParameter(PARAM_NOW, (Object)OffsetDateTime.now(ZoneOffset.UTC)).setParameter(PARAM_ALIAS, (Object)alias).setParameter(PARAM_TYPE, (Object)type).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public void setListenerCertificateStatus(String alias, ListenerCertificate.Type type, ListenerCertificate.Status status, CRLReason crlReason) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("UPDATE ListenerCertificate\nSET status=:status, crlReason=:crlReason, lastCheck=:now\nWHERE aliasAndType.alias=:alias AND aliasAndType.type=:type").setParameter("status", (Object)status).setParameter("crlReason", (Object)crlReason).setParameter(PARAM_NOW, (Object)OffsetDateTime.now(ZoneOffset.UTC)).setParameter(PARAM_ALIAS, (Object)alias).setParameter(PARAM_TYPE, (Object)type).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public void importCertificate(ListenerCertificate listenerCertificate) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            ListenerCertificate certFromDB = (ListenerCertificate)entityManager.find(ListenerCertificate.class, (Object)listenerCertificate.getId());
            if (Objects.isNull(certFromDB)) {
                entityManager.persist((Object)listenerCertificate);
                LOG.info("Imported listener certificate {}", (Object)listenerCertificate.getId());
            } else {
                certFromDB.setStatus(ListenerCertificate.Status.TEMPORARILY_DISABLED);
                certFromDB.setCrlReason(CRLReason.UNSPECIFIED);
                certFromDB.setLastCheck(listenerCertificate.getLastCheck());
                certFromDB.setLastSuccessfulCheck(listenerCertificate.getLastSuccessfulCheck());
                entityManager.persist((Object)certFromDB);
                LOG.trace("Update {} certificate {} in database to TEMPORARILY_DISABLED ({})", (Object)listenerCertificate.getType(), (Object)listenerCertificate.getAlias(), (Object)listenerCertificate.getLastCheck());
            }
            entityManager.getTransaction().commit();
        }
    }

    public void deleteCertificate(String alias, ListenerCertificate.Type type) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int deleteCount = entityManager.createQuery("DELETE ListenerCertificate WHERE aliasAndType.alias=:alias AND aliasAndType.type=:type").setParameter(PARAM_ALIAS, (Object)alias).setParameter(PARAM_TYPE, (Object)type).executeUpdate();
            if (deleteCount > 0) {
                LOG.info("Deleted listener {} certificate '{}' from database", (Object)type, (Object)alias);
            }
            entityManager.getTransaction().commit();
        }
    }
}

