/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.ponton.xmlpipe.queue.InboundQueueMessage;
import de.pontonconsulting.xmlpipe.config.DatabaseType;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.InboundQueue;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboundQueueingDAO
extends BaseDAO {
    public static int ACK_SENT = 1;
    public static int ACK_NOT_SENT = 0;
    public static final int STATUS_ENQUEUED = 0;
    public static final int STATUS_IN_TRANSFER = 1;
    private static final Logger _log = LogManager.getLogger((String)"Messenger.InboundQueueingDAO");
    private final MessengerLog _messengerLog;
    private final MessageDAO _messageDAO;
    private final MessengerConfig _messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private static final String ERROR_ADD_INBOUND = "Error while adding inbound message to Database: ";
    private static final String ERROR_REMOVE_INBOUND = "Error while removing from inbound message queue: ";
    private static final String ERROR_GET_INBOUND = "Error while getting inbound message queue: ";
    static final long TEST_VALUE_TIMESECONDS = 123456789012345678L;
    static final String TEST_VALUE_ADAPTER_ID = "hotfolder-1";
    static final long TEST_VALUE_NEXT_TRANSMISSION = 123456789012345678L;
    static final int TEST_VALUE_MESSENGER_ID = 123;

    public InboundQueueingDAO(HibernateSessionFactory hibernateSessionFactory, MessengerLog messengerLog, MessageDAO messageDAO, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask) {
        super(hibernateSessionFactory);
        this._messengerLog = messengerLog;
        this._messageDAO = messageDAO;
        this._messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
    }

    public void addToInboundQueue(InboundQueueMessage inboundQueueMessage) throws DbException {
        try {
            try (EntityManager entityManager = this.createNewEntityManager();){
                entityManager.getTransaction().begin();
                InboundQueue iq = new InboundQueue(inboundQueueMessage.getUniqueId());
                iq.setTimeseconds(inboundQueueMessage.getQueuedTimestamp());
                iq.setAdapterId(inboundQueueMessage.getAdapterId());
                iq.setNextTransmission(0L);
                iq.setMessengerId(this._messengerConfig.getMessengerId());
                iq.setStatus(0);
                iq.setPriority(inboundQueueMessage.getPriority());
                iq.setAckSent(ACK_SENT);
                entityManager.persist((Object)iq);
                this._messageDAO.updateMessageStatusInSameTransaction(inboundQueueMessage.getUniqueId(), 2, entityManager);
                entityManager.getTransaction().commit();
            }
            this._messengerLog.log2db(6, inboundQueueMessage.getUniqueId(), inboundQueueMessage.getAdapterId());
        }
        catch (RuntimeException e) {
            throw new DbException(13006, ERROR_ADD_INBOUND + e.getMessage(), e);
        }
    }

    public void loadMessagesInTransferFromDatabase(Consumer<InboundQueue> callback) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(InboundQueue.class);
            Root inboundQeueRoot = criteriaQuery.from(InboundQueue.class);
            criteriaQuery.select((Selection)inboundQeueRoot);
            criteriaQuery.where((Expression)cb.equal((Expression)inboundQeueRoot.get("messengerId"), (Object)this._messengerConfig.getMessengerId()));
            criteriaQuery.where((Expression)cb.equal((Expression)inboundQeueRoot.get("status"), (Object)1));
            criteriaQuery.orderBy(new Order[]{cb.asc((Expression)inboundQeueRoot.get("timeseconds"))});
            entityManager.createQuery(criteriaQuery).getResultStream().forEach(dbInbound -> {
                try {
                    callback.accept((InboundQueue)dbInbound);
                }
                catch (Throwable e) {
                    _log.error(e.getMessage(), e);
                }
                entityManager.detach(dbInbound);
            });
        }
        catch (RuntimeException e) {
            throw new DbException(13007, ERROR_GET_INBOUND + e.getMessage(), e);
        }
    }

    public List<String> getAdaptersWithPendingMessages() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                list = entityManager.createQuery("SELECT DISTINCT adapterId\nFROM InboundQueue\n", String.class).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13007, ERROR_GET_INBOUND + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public Optional<Long> startTransferOfNextPendingMessage(String adapterId) {
        _log.trace("Getting next pending message for adapterId={}", (Object)adapterId);
        try (EntityManager entityManager = this.createNewEntityManager();){
            List messageIds;
            block18: {
                entityManager.getTransaction().begin();
                try {
                    String selectAndLockSql = switch (this.getDatabaseType()) {
                        case DatabaseType.ORACLE -> "SELECT MESSAGE_ID\nFROM INBOUND_QUEUE\nWHERE MESSAGE_ID IN\n(\n   SELECT MESSAGE_ID FROM INBOUND_QUEUE\n   WHERE ADAPTER_ID = ? AND STATUS = 0\n   ORDER BY PRIORITY DESC, MESSAGE_ID ASC\n   FETCH FIRST 1 ROW ONLY\n)\nFOR UPDATE SKIP LOCKED\n";
                        case DatabaseType.POSTGRESQL, DatabaseType.MYSQL -> "SELECT MESSAGE_ID FROM INBOUND_QUEUE\nWHERE ADAPTER_ID = ? AND STATUS = 0\nORDER BY PRIORITY DESC, MESSAGE_ID ASC\nLIMIT 1\nFOR UPDATE SKIP LOCKED\n";
                        case DatabaseType.MSSQL -> "SELECT TOP 1 MESSAGE_ID FROM INBOUND_QUEUE WITH (UPDLOCK, READPAST)\nWHERE ADAPTER_ID = ? AND STATUS = 0\nORDER BY PRIORITY DESC, MESSAGE_ID ASC\n";
                        default -> "SELECT MESSAGE_ID FROM INBOUND_QUEUE\nWHERE ADAPTER_ID = ? AND STATUS = 0\nORDER BY PRIORITY DESC, MESSAGE_ID ASC\nLIMIT 1\nFOR UPDATE\n";
                    };
                    messageIds = entityManager.createNativeQuery(selectAndLockSql, Long.class).setParameter(1, (Object)adapterId).getResultList();
                    if (!messageIds.isEmpty() && messageIds.getFirst() != null) break block18;
                    entityManager.getTransaction().rollback();
                    _log.debug("No pending InboundQueue message found for adapterId={}", (Object)adapterId);
                    Optional<Long> optional = Optional.empty();
                    return optional;
                }
                catch (Exception e) {
                    _log.error("Can't select next pending InboundQueue message for adapterId={}", (Object)adapterId, (Object)e);
                    if (entityManager.getTransaction().isActive()) {
                        entityManager.getTransaction().rollback();
                    }
                    Optional<Long> optional = Optional.empty();
                    return optional;
                }
            }
            Long messageId = (Long)messageIds.getFirst();
            int updateCount = entityManager.createNativeQuery("UPDATE INBOUND_QUEUE\nSET STATUS = 1, NEXT_TRANSMISSION = ?, MESSENGER_ID = ?\nWHERE MESSAGE_ID = ? AND STATUS = 0\n").setParameter(1, (Object)this.referenceDateTask.getReferenceCurrentTimeMillis()).setParameter(2, (Object)this._messengerConfig.getMessengerId()).setParameter(3, (Object)messageId).executeUpdate();
            if (updateCount == 0) {
                entityManager.getTransaction().rollback();
                _log.debug("Message already claimed by another process for adapterId={}", (Object)adapterId);
                Optional<Long> optional = Optional.empty();
                return optional;
            }
            entityManager.getTransaction().commit();
            _log.trace("Changed status of message with ID={} to IN TRANSFER", (Object)messageId);
            Optional<Long> optional = Optional.of(messageId);
            return optional;
        }
    }

    public boolean setNextTransmission(long messageId, Long nextTransmission) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery("UPDATE InboundQueue\nSET nextTransmission = :nextTransmission\nWHERE messageId = :messageId AND status = 1 AND messengerId = :messengerId\n").setParameter("messageId", (Object)messageId).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).setParameter("nextTransmission", (Object)(Objects.nonNull(nextTransmission) ? nextTransmission.longValue() : this.referenceDateTask.getReferenceCurrentTimeMillis())).executeUpdate();
            if (updateCount == 0) {
                _log.warn("No InboundQueue message found to update NextTransmission (messageId={} / messengerId={} / status=1)", (Object)messageId, (Object)this._messengerConfig.getMessengerId());
            } else {
                _log.trace("Updated NextTransmission InboundQueue message (messageId={})", (Object)messageId);
            }
            entityManager.getTransaction().commit();
            boolean bl = updateCount == 1;
            return bl;
        }
    }

    public List<Long> getTimedOutMessagesOfAdapter(String adapterId, int adapterProcessTimeout) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            long timeout = this.referenceDateTask.getReferenceCurrentTimeMillis() - (long)((adapterProcessTimeout <= 0 ? 30 : adapterProcessTimeout) * 2) * 1000L;
            List list = entityManager.createQuery("SELECT messageId\nFROM InboundQueue\nWHERE adapterId = :adapterId AND status = 1 AND nextTransmission <= :timeout\n", Long.class).setParameter("adapterId", (Object)adapterId).setParameter("timeout", (Object)timeout).getResultList();
            return list;
        }
    }

    public boolean resetTransmissionState(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery("UPDATE InboundQueue\nSET nextTransmission = 0, status = 0\nWHERE messageId = :messageId AND status = 1\n").setParameter("messageId", (Object)messageId).executeUpdate();
            if (updateCount == 0) {
                _log.warn("No InboundQueue message found to reset (messageId={} / status=1)", (Object)messageId);
            } else {
                _log.trace("TransmissionState of InboundQueue message (messageId={}) reset", (Object)messageId);
            }
            entityManager.getTransaction().commit();
            boolean bl = updateCount == 1;
            return bl;
        }
    }

    public boolean deleteFromInboundQueue(long messageDataId) throws DbException {
        boolean bl;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                boolean result = this.deleteFromInboundQueue(messageDataId, entityManager);
                entityManager.getTransaction().commit();
                bl = result;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13007, ERROR_REMOVE_INBOUND + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public boolean deleteFromInboundQueue(long messageDataId, EntityManager entityManager) throws DbException {
        try {
            int result = entityManager.createQuery("DELETE InboundQueue iq\nWHERE iq.messageId = :messageId\n").setParameter("messageId", (Object)messageDataId).executeUpdate();
            return result > 0;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            throw new DbException(13010, ERROR_REMOVE_INBOUND + e.getMessage(), e);
        }
    }

    public void dbConsistencyCheck(Message testMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            InboundQueue iq = new InboundQueue();
            iq.setMessageId(testMessage.getId());
            iq.setStatus(-1);
            iq.setPriority(-1);
            iq.setTimeseconds(123456789012345678L);
            iq.setAdapterId(TEST_VALUE_ADAPTER_ID);
            iq.setNextTransmission(123456789012345678L);
            iq.setMessengerId(123);
            entityManager.persist((Object)iq);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13043, "DB Consistency check for table 'INBOUND_QUEUE' failed. Reason: " + e.getMessage(), e);
        }
    }

    public int getQueueSize(String adapterId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            int count;
            int n = count = ((Long)entityManager.createQuery("SELECT COUNT(*)\nFROM InboundQueue\nWHERE adapterId = :adapterId AND messengerId = :messengerId\n", Long.class).setParameter("messengerId", (Object)this._messengerConfig.getMessengerId()).setParameter("adapterId", (Object)adapterId).getSingleResult()).intValue();
            return n;
        }
    }

    public boolean containsMessages(Collection<Long> messageDataIds, EntityManager entityManager) {
        return ((Long)entityManager.createQuery("SELECT COUNT(*)\nFROM InboundQueue\nWHERE messageId in :messageIds\n", Long.class).setParameter("messageIds", messageDataIds).getSingleResult()).intValue() > 0;
    }
}

