/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.archive.IArchiver;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.FileRef;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class FileRefDAO
extends BaseDAO {
    private static final String TEST_VALUE_FILE_NAME = "my.file.name_1234567890";
    private static final String SQL_DELETE_FILE_REFS_BY_MESSAGE_ID = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.FileRef fr WHERE fr.messageId = :messageId";
    private static final String SQL_DELETE_FILE_REFS_BY_MESSAGE_IDS = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.FileRef fr WHERE fr.messageId IN (:messageIds)";
    private static final String PARAM_MESSAGE_ID = "messageId";
    private static final String PARAM_FILE_NAME = "fileName";
    private static final String PARAM_FILE_TYPE = "fileType";
    private final IFolders _folders;

    public FileRefDAO(HibernateSessionFactory hibernateSessionFactory, IFolders folders) {
        super(hibernateSessionFactory);
        this._folders = folders;
    }

    public void insertMessageFileReference(long messageDataId, File folder, String filename, String mimeType) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Message message = this.findMessage(entityManager, messageDataId);
            if (message != null) {
                String newFolder = this._folders.convertFolderToString(folder);
                if (!folder.getAbsolutePath().equals(message.getFolder())) {
                    message.setFolder(newFolder);
                    entityManager.persist((Object)message);
                }
                if (this.updateMessageFileReference(entityManager, message.getFileRefs(), filename) == 0 && filename != null) {
                    FileRef fileRef = new FileRef();
                    fileRef.setMessageId(messageDataId);
                    fileRef.setFileName(filename);
                    fileRef.setFileType(FileType.PAYLOAD.getDbValue());
                    fileRef.setMimeType(mimeType);
                    entityManager.persist((Object)fileRef);
                }
                entityManager.getTransaction().commit();
            }
        }
        catch (DbException | RuntimeException e) {
            _log.error("File Reference {} of message {} could not be saved in database:{}", (Object)filename, (Object)messageDataId, (Object)e.getMessage(), (Object)e);
        }
    }

    private int updateMessageFileReference(EntityManager entityManager, Set<FileRef> filRefs, String filename) throws DbException {
        int result = 0;
        for (FileRef ref : filRefs) {
            if (FileType.isPayLoad(ref.getFileType())) {
                ref.setFileName(filename);
                entityManager.persist((Object)ref);
                ++result;
                continue;
            }
            if (!filename.equals(ref.getFileName())) continue;
            _log.warn("Found existing Payload-FileRef with filename '{}' which has FileType {} => change FileType to PAYLOAD", (Object)filename, (Object)FileType.fromDbValue(ref.getFileType()));
            ref.setFileType(FileType.PAYLOAD.getDbValue());
            entityManager.persist((Object)ref);
            ++result;
        }
        return result;
    }

    public void storeArchiveResponse(long messageDataId, List<IArchiver.ArchiveResponse> archiveResponses) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            archiveResponses.forEach(ar -> this.saveArchiveResponse(entityManager, messageDataId, (IArchiver.ArchiveResponse)ar));
            entityManager.getTransaction().commit();
        }
    }

    private void saveArchiveResponse(EntityManager entityManager, long messageDataId, IArchiver.ArchiveResponse archiveResponse) {
        FileRef fileRef = entityManager.createQuery("FROM FileRef WHERE messageId = :messageId AND fileName = :fileName", FileRef.class).setParameter(PARAM_MESSAGE_ID, (Object)messageDataId).setParameter(PARAM_FILE_NAME, (Object)archiveResponse.fileName()).getResultStream().findFirst().orElse(null);
        if (Objects.isNull(fileRef)) {
            fileRef = new FileRef();
            fileRef.setMessageId(messageDataId);
            fileRef.setFileName(archiveResponse.fileName());
            fileRef.setFileType(archiveResponse.fileType().getDbValue());
        }
        fileRef.setArchiveReference(archiveResponse.archiveReference());
        entityManager.persist((Object)fileRef);
    }

    public List<FileRef> getArchiveFileRefs(long messageDataId, FileType fileType) throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                list = entityManager.createQuery("FROM FileRef\nWHERE messageId = :messageId AND\n      (fileType = :fileType OR :fileType IS NULL) AND\n      archiveReference IS NOT NULL", FileRef.class).setParameter(PARAM_MESSAGE_ID, (Object)messageDataId).setParameter(PARAM_FILE_TYPE, Objects.isNull((Object)fileType) ? null : Integer.valueOf(fileType.getDbValue())).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13040, "could not load archive file reference of message " + messageDataId + " [fileType=" + String.valueOf((Object)fileType) + "]: " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    public int deleteFromFileRef(long messageDataID) throws DbException {
        int n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int result = this.deleteFromFileRef(messageDataID, entityManager);
                entityManager.getTransaction().commit();
                n = result;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DbException e) {
                    _log.error("Can't delete FileRef {} from database: {}", (Object)messageDataID, (Object)e.toString());
                    throw e;
                }
            }
            entityManager.close();
        }
        return n;
    }

    public int deleteFromFileRef(long messageDataId, EntityManager entityManager) throws DbException {
        try {
            return entityManager.createQuery(SQL_DELETE_FILE_REFS_BY_MESSAGE_ID).setParameter(PARAM_MESSAGE_ID, (Object)messageDataId).executeUpdate();
        }
        catch (EntityNotFoundException e) {
            return 0;
        }
        catch (RuntimeException e) {
            throw new DbException(13048, "Could not delete File reference to " + messageDataId + " from Database:" + e.getMessage(), e);
        }
    }

    public int deleteByMessageDataIds(Collection<Long> messageDataIds, EntityManager entityManager) throws DbException {
        try {
            return entityManager.createQuery(SQL_DELETE_FILE_REFS_BY_MESSAGE_IDS).setParameter("messageIds", messageDataIds).executeUpdate();
        }
        catch (RuntimeException e) {
            throw new DbException(13048, "Could not delete File reference to " + String.valueOf(messageDataIds) + " from Database:", e);
        }
    }

    public void dbConsistencyCheck(Message testMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            FileRef fileRef = new FileRef();
            fileRef.setMessageId(testMessage.getId());
            fileRef.setFileName(TEST_VALUE_FILE_NAME);
            entityManager.persist((Object)fileRef);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13064, "DB Consistency check for table 'FILE_REF' failed. Reason: " + e.getMessage(), e);
        }
    }

    public void dbCleanup(long testMessageDatabaseId) throws DbException {
        this.deleteFromFileRef(testMessageDatabaseId);
    }

    private Message findMessage(EntityManager entityManager, long messageDataId) {
        return (Message)entityManager.find(Message.class, (Object)messageDataId);
    }

    public void saveAttachment(EntityManager entityManager, long messageDataId, XpMessageAttachment attachment) {
        FileRef fileRef = entityManager.createQuery("FROM FileRef WHERE messageId = :messageId AND fileName = :fileName", FileRef.class).setParameter(PARAM_MESSAGE_ID, (Object)messageDataId).setParameter(PARAM_FILE_NAME, (Object)attachment.getAttachment().getName()).getResultStream().findFirst().orElse(null);
        if (Objects.isNull(fileRef)) {
            fileRef = new FileRef();
            fileRef.setMessageId(messageDataId);
            fileRef.setFileName(attachment.getAttachment().getName());
            fileRef.setFileType(FileType.ATTACHMENT.getDbValue());
        }
        fileRef.setMimeType(attachment.getType());
        fileRef.setRole(attachment.getRole());
        fileRef.setDescription(attachment.getDescription());
        fileRef.setLanguage(attachment.getLanguage());
        entityManager.persist((Object)fileRef);
    }

    public List<FileRef> getAttachmentFileRefs(long messageDataId, EntityManager entityManager) {
        return entityManager.createQuery("FROM FileRef WHERE messageId = :messageId AND fileType = :fileType", FileRef.class).setParameter(PARAM_MESSAGE_ID, (Object)messageDataId).setParameter(PARAM_FILE_TYPE, (Object)FileType.ATTACHMENT.getDbValue()).getResultList();
    }
}

