/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.EventLogEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventLog {
    public static int STATUS_OK = 0;
    public static int STATUS_WARN = 1;
    public static int STATUS_ERROR = 2;
    public static String AGR_EVENT_ID = "agreement";
    public static String AGR_UPDATE_EVENT_ID = "agreementUpdate";
    private final Queue<EventLogEntry> _allEventLogEntries = new ConcurrentLinkedQueue<EventLogEntry>();
    final int _maxQueueSize = 50;

    public void writeError(String eventId, String component, String descriptionKey, String description, String[] descArgs, String location) {
        this.writeEvent(eventId, component, descriptionKey, description, descArgs, STATUS_ERROR, location);
    }

    public void writeWarning(String eventId, String component, String descriptionKey, String description, String[] descArgs, String location) {
        this.writeEvent(eventId, component, descriptionKey, description, descArgs, STATUS_WARN, location);
    }

    public void writeOK(String eventId, String component, String descriptionKey, String description, String[] descArgs, String location) {
        this.writeEvent(eventId, component, descriptionKey, description, descArgs, STATUS_OK, location);
    }

    public void writeEvent(String eventId, String component, String descriptionKey, String description, String[] descArgs, int eventStatus, String location) {
        if (this.contains(eventId)) {
            return;
        }
        EventLogEntry entry = new EventLogEntry(eventId, System.currentTimeMillis(), component, descriptionKey, descArgs, description, eventStatus, location);
        this.add(entry);
    }

    public void deleteEvent(String eventId) {
        if (this.contains(eventId)) {
            this.delete(eventId);
        }
    }

    public void add(EventLogEntry entry) {
        if (this._allEventLogEntries.size() >= 50) {
            this._allEventLogEntries.remove();
        }
        this._allEventLogEntries.add(entry);
    }

    private EventLogEntry createDummyEvent(String id) {
        return new EventLogEntry(id, -1L, null, null, null, -1);
    }

    public void delete(String id) {
        this._allEventLogEntries.remove(this.createDummyEvent(id));
    }

    public void deleteForLikeId(String likeId) {
        for (EventLogEntry eventLogEntry : this._allEventLogEntries) {
            if (!eventLogEntry.getId().startsWith(likeId)) continue;
            this._allEventLogEntries.remove(eventLogEntry);
        }
    }

    public int deleteOldOKEvents(long maxAge) {
        int result = 0;
        for (EventLogEntry eventLogEntry : this._allEventLogEntries) {
            if (eventLogEntry.getTimestamp() >= maxAge) continue;
            this._allEventLogEntries.remove(eventLogEntry);
            ++result;
        }
        return result;
    }

    public boolean contains(String id) {
        return this._allEventLogEntries.contains(this.createDummyEvent(id));
    }

    public List<EventLogEntry> getAllEntries() {
        ArrayList<EventLogEntry> eventLogEntries = new ArrayList<EventLogEntry>(this._allEventLogEntries);
        Collections.sort(eventLogEntries);
        return eventLogEntries;
    }

    public void shutdown() {
        this._allEventLogEntries.clear();
    }

    public String getEventId(String eventId, String senderId, String receiverId, String eventIdSubType) {
        return eventId + ".senderId=" + senderId + "/receiverId=" + receiverId + "/" + eventIdSubType;
    }

    public List<String> getEventIdsForPrefix(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (EventLogEntry eventLogEntry : this._allEventLogEntries) {
            if (!eventLogEntry.getId().startsWith(prefix)) continue;
            result.add(eventLogEntry.getId());
        }
        return result;
    }

    public void deleteEventsForAgreement(String eventId, String senderId, String receiverId) {
        this.deleteForLikeId(this.getEventId(eventId, senderId, receiverId, "%"));
    }

    public List<EventLogEntry> getAllEntriesLimited(int limit) {
        ArrayList<EventLogEntry> entriesLimited = new ArrayList<EventLogEntry>();
        List<EventLogEntry> allEntries = this.getAllEntries();
        int limitCount = 0;
        for (EventLogEntry event : allEntries) {
            if (++limitCount > limit) break;
            entriesLimited.add(event);
        }
        return entriesLimited;
    }

    public long getSize() {
        return this._allEventLogEntries.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventLog other = (EventLog)obj;
        return !(this._allEventLogEntries == null ? other._allEventLogEntries != null : !this._allEventLogEntries.equals(other._allEventLogEntries));
    }

    public String toString() {
        return "EventLog [_allEventLogEntries=" + String.valueOf(this._allEventLogEntries) + ", _maxQueueSize=50]";
    }
}

