/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.DatabaseType;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import jakarta.persistence.EntityManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;

public class BaseDAO {
    private final HibernateSessionFactory _hibernateSessionFactory;
    protected static final Logger _log = LogManager.getLogger((String)"Messenger.MessengerLog");

    public BaseDAO(HibernateSessionFactory hibernateSessionFactory) {
        this._hibernateSessionFactory = hibernateSessionFactory;
    }

    protected EntityManager createNewEntityManager() {
        return this._hibernateSessionFactory.createNewEntityManager();
    }

    protected DatabaseType getDatabaseType() {
        return this._hibernateSessionFactory.getDatabaseType();
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void rollbackConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean isConstraintViolationException(Throwable e) {
        if (e instanceof ConstraintViolationException) {
            return true;
        }
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ConstraintViolationException)) continue;
            return true;
        }
        return false;
    }
}

