/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpBaseMessage;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Objects;

@Entity
@Table(name="MESSAGE")
@DiscriminatorValue(value="1")
public class XpInboundMessage
extends XpBaseMessage {
    private static final long serialVersionUID = 3408196931160292144L;
    @Column(name="REFERENCE_ID")
    private Long referenceDatabaseId;
    private transient String referenceId;

    public XpInboundMessage() {
    }

    public XpInboundMessage(XpMessage xpMessage) {
        super(xpMessage);
    }

    @Override
    protected void setMessageProperties(XpMessage xpMessage) {
        super.setMessageProperties(xpMessage);
        this.referenceDatabaseId = xpMessage.getReferenceDatabaseId() == -1L ? null : Long.valueOf(xpMessage.getReferenceDatabaseId());
        this.referenceId = xpMessage.getReferenceId();
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public long getReferenceDatabaseId() {
        return Objects.isNull(this.referenceDatabaseId) ? -1L : this.referenceDatabaseId;
    }

    public boolean isStatusResponse() {
        return Boolean.parseBoolean(this.getProcessingDirective("IsStatusResponse"));
    }
}

