/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.messenger.database.hibernate.BackendPartnerId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ConversationReference;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.FileRef;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageProcessingDirective;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageReference;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKey;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="MESSAGE")
@Immutable
public class XpDatabaseMessage
implements Serializable {
    private static final long serialVersionUID = -985620285544001583L;
    @Id
    @Column(name="ID")
    private long id;
    @Column(name="MESSAGE_ID")
    private String messageId;
    @Column(name="TRANSFER_ID")
    private String transferId;
    @Column(name="DESTINATION_URL")
    private String destinationUrl;
    @Column(name="FOLDER")
    private String folder;
    @Column(name="CONTENT_REFERENCE_FILE")
    private String contentReferenceFile;
    @Column(name="CONTENT_TYPE")
    private String contentType;
    @Column(name="CREATION_TIME")
    private Long creationTime;
    @Column(name="INBOUND")
    private int inbound;
    @Column(name="SEQUENCE_NUMBER")
    private Long sequenceNumber;
    @Column(name="MESSAGE_TYPE")
    private String messageType;
    @Column(name="SCHEMA_VERSION")
    private String schemaVersion;
    @Column(name="SCHEMA_SET")
    private String schemaSet;
    @Column(name="SCHEMA_LOCATION")
    private String schemaLocation;
    @Column(name="SCHEMA_NAMESPACE")
    private String schemaNamespace;
    @Column(name="PROTOCOL")
    private String protocol;
    @Column(name="RECEIVER_ID", insertable=false, updatable=false)
    private String receiverLocalId;
    @Column(name="SENDER_ID", insertable=false, updatable=false)
    private String senderLocalId;
    @Column(name="MESSAGE_TIME")
    private Long messageTime;
    @Column(name="TTL")
    private Long ttl;
    @Column(name="PACKAGING_ID")
    private String packageId;
    @Column(name="SIGNED_ACK_REQUESTED")
    private Integer signedAckRequested;
    @Column(name="TESTFLAG")
    private Integer testFlag;
    @Column(name="STATUS")
    private Integer status;
    @Column(name="ACK_REQUESTED")
    private Boolean ackRequested;
    @Column(name="ACK_RECEIVED")
    private Integer ackReceived;
    @Column(name="ADAPTER_ID")
    private String adapterId;
    @Column(name="MESSENGER_ID")
    private Integer messengerId;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="SENDER_ID")
    private PartnerProfile sender;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="RECEIVER_ID")
    private PartnerProfile receiver;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @JoinColumn(name="MESSAGE_ID", referencedColumnName="ID")
    @SQLRestriction(value="FILE_TYPE = 6")
    private List<FileRef> attachments;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @JoinColumn(name="MESSAGE_ID", referencedColumnName="ID")
    @MapKey(name="id.type")
    private Map<String, MessageProcessingDirective> processingDirectives;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="REFERENCE_ID", referencedColumnName="ID")
    private MessageReference messageReference;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="CONVERSATION", referencedColumnName="ID")
    private ConversationReference conversation;

    protected XpDatabaseMessage() {
    }

    public String getSchemaSet() {
        return this.schemaSet;
    }

    public long getId() {
        return this.id;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getFolder() {
        return this.folder;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public boolean getInbound() {
        return 1 == this.inbound;
    }

    public long getConversationDbId() {
        return Objects.isNull(this.conversation) ? -1L : this.conversation.getId();
    }

    public String getConversationId() {
        return Objects.isNull(this.conversation) ? null : this.conversation.getConversationId();
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getReceiverLocalId() {
        return this.receiverLocalId;
    }

    public String getSenderLocalId() {
        return this.senderLocalId;
    }

    public Long getMessageTime() {
        return this.messageTime;
    }

    public long getReferenceId() {
        return Objects.isNull(this.messageReference) ? -1L : this.messageReference.getId();
    }

    public String getReferenceMessageId() {
        return Objects.isNull(this.messageReference) ? null : this.messageReference.getMessageId();
    }

    public Long getTtl() {
        return this.ttl;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public boolean getSignedAckRequested() {
        return 1 == this.signedAckRequested;
    }

    public boolean isTestMessage() {
        return 1 == this.testFlag;
    }

    public Integer getStatus() {
        return this.status;
    }

    public boolean getAckReceived() {
        return 1 == this.ackReceived;
    }

    public String getAdapterId() {
        if (Objects.isNull(this.adapterId)) {
            return null;
        }
        return this.adapterId.split("\t")[0];
    }

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public Integer getMessengerId() {
        return this.messengerId;
    }

    public List<FileRef> getAttachments() {
        return this.attachments;
    }

    public Map<String, MessageProcessingDirective> getProcessingDirectives() {
        return this.processingDirectives;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }

    public String getProcessingDirective(String type) {
        MessageProcessingDirective processingDirective = this.processingDirectives.get(type);
        return Objects.isNull(processingDirective) ? null : processingDirective.getValue();
    }

    public String getContentReference() {
        return this.contentReferenceFile;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isAck() {
        return "ACK".equals(this.messageType);
    }

    public boolean isAckRequested() {
        return Objects.nonNull(this.ackRequested) && this.ackRequested != false;
    }

    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public String getSenderInternalId() {
        return Objects.isNull(this.sender) ? null : (String)this.sender.getBackendPartnerIds().stream().findFirst().map(BackendPartnerId::getBackendPartnerId).orElse(null);
    }

    public String getReceiverInternalId() {
        return Objects.isNull(this.receiver) ? null : (String)this.receiver.getBackendPartnerIds().stream().findFirst().map(BackendPartnerId::getBackendPartnerId).orElse(null);
    }

    public void removeAllAttachments() {
        if (!this.attachments.isEmpty()) {
            this.attachments = Collections.emptyList();
        }
    }
}

