/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@Entity
@Table(name="PARTNER_AGREEMENT")
public class PartnerAgreement
implements Serializable {
    private static final long serialVersionUID = 8986025166318921117L;
    @Id
    private String id;
    @Column(name="OWN_PARTNER_ID")
    private String ownPartnerId;
    @Column(name="COMMUNICATION_PARTNER_ID")
    private String communicationPartnerId;
    @Column(name="PRIVATE_AGREEMENT")
    private byte[] privateAgreement;
    @Column(name="PUBLIC_AGREEMENT")
    private byte[] publicAgreement;
    @Column(name="USERNAME")
    private String username;
    @Column(name="ADAPTER_ID")
    private String adapterId;
    @Column(name="PACKAGING_ID")
    private String packagingId;
    @Column(name="PING_ALL_ENABLED")
    private Boolean pingAllEnabled;
    @Column(name="URL_IS_VALID")
    private Boolean urlIsValid;
    @Column(name="FALLBACK_URL_IS_VALID")
    private Boolean fallbackUrlIsValid;
    @Column(name="LAST_CHANGE")
    private OffsetDateTime lastChange;

    public String getId() {
        return this.id;
    }

    public PartnerAgreement setId(String id) {
        this.id = id;
        return this;
    }

    public String getOwnPartnerId() {
        return this.ownPartnerId;
    }

    public PartnerAgreement setOwnPartnerId(String ownPartnerId) {
        this.ownPartnerId = ownPartnerId;
        return this;
    }

    public String getCommunicationPartnerId() {
        return this.communicationPartnerId;
    }

    public PartnerAgreement setCommunicationPartnerId(String communicationPartnerId) {
        this.communicationPartnerId = communicationPartnerId;
        return this;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public PartnerAgreement setAdapterId(String adapterId) {
        this.adapterId = adapterId;
        return this;
    }

    public String getPackagingId() {
        return this.packagingId;
    }

    public PartnerAgreement setPackagingId(String packagingId) {
        this.packagingId = packagingId;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public PartnerAgreement setUsername(String username) {
        this.username = username;
        return this;
    }

    public byte[] getPrivateAgreement() {
        return this.privateAgreement;
    }

    public PartnerAgreement setPrivateAgreement(byte[] privateAgreement) {
        this.privateAgreement = privateAgreement;
        return this;
    }

    public byte[] getPublicAgreement() {
        return this.publicAgreement;
    }

    public PartnerAgreement setPublicAgreement(byte[] publicAgreement) {
        this.publicAgreement = publicAgreement;
        return this;
    }

    public boolean isPingAllEnabled() {
        return Objects.requireNonNullElse(this.pingAllEnabled, false);
    }

    public PartnerAgreement setPingAllEnabled(boolean pingAllEnabled) {
        this.pingAllEnabled = pingAllEnabled;
        return this;
    }

    public boolean urlIsValid() {
        return Objects.isNull(this.urlIsValid) || this.urlIsValid != false;
    }

    public PartnerAgreement setUrlIsValid(Boolean urlIsValid) {
        this.urlIsValid = urlIsValid;
        return this;
    }

    public boolean fallbackUrlIsValid() {
        return Objects.isNull(this.fallbackUrlIsValid) || this.fallbackUrlIsValid != false;
    }

    public PartnerAgreement setFallbackUrlIsValid(Boolean fallbackUrlIsValid) {
        this.fallbackUrlIsValid = fallbackUrlIsValid;
        return this;
    }

    public OffsetDateTime getLastChange() {
        return this.lastChange;
    }

    public PartnerAgreement setLastChange(OffsetDateTime lastChange) {
        this.lastChange = lastChange;
        return this;
    }
}

