/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.ponton.xmlpipe.rest.authorization.Permissions;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.UserRole;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="MESSENGER_USER")
public class MessengerUser
implements Serializable,
UserDetails,
CredentialsContainer {
    private static final long serialVersionUID = -8121436944949384328L;
    @Id
    @Column(name="USERNAME", nullable=false, length=255)
    private String username;
    @Column(name="PASSWORD", nullable=false, length=255)
    private String password;
    @Column(name="LANGUAGE", nullable=false, length=255)
    private String language;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="MESSENGER_USER_ROLE", joinColumns={@JoinColumn(name="USERNAME", referencedColumnName="USERNAME")}, inverseJoinColumns={@JoinColumn(name="USER_ROLE_ID", referencedColumnName="ID")})
    private List<UserRole> roles = new ArrayList<UserRole>();
    @Column(name="EXPIRATION", nullable=false)
    private OffsetDateTime expiration;
    @Column(name="LOCKED_UNTIL", nullable=false)
    private OffsetDateTime lockedUntil;
    @Column(name="EXPIRATION_ENABLED")
    private boolean expirationEnabled;
    @Column(name="FAILED_LOGIN_ATTEMPTS")
    private int failedLoginAttempts;
    @Column(name="DISABLED")
    private boolean disabled;
    @Column(name="TOTP_SECRET", length=255)
    private String totpSecret;
    @Column(name="TOTP_ENABLED")
    private boolean totpEnabled;
    @Transient
    private transient Supplier<OffsetDateTime> currentTimeSupplier = OffsetDateTime::now;

    public MessengerUser() {
    }

    public MessengerUser(MessengerUser other) {
        this.username = other.getUsername();
        this.password = other.getPassword();
        this.language = other.getLanguage();
        this.expiration = other.getExpiration();
        this.lockedUntil = other.getLockedUntil();
        this.expirationEnabled = other.getExpirationEnabled();
        this.failedLoginAttempts = other.getFailedLoginAttempts();
        this.disabled = other.getDisabled();
        this.totpSecret = other.getTotpSecret();
        this.totpEnabled = other.getTotpEnabled();
        this.currentTimeSupplier = other.currentTimeSupplier;
        this.roles = other.roles == null ? null : new ArrayList<UserRole>(other.roles);
    }

    public String getUsername() {
        return this.username;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return this.lockedUntil == null || this.lockedUntil.isBefore(this.currentTimeSupplier.get());
    }

    @Transient
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        if (this.expirationEnabled && this.expiration != null) {
            return this.expiration.isAfter(this.currentTimeSupplier.get());
        }
        return !this.expirationEnabled;
    }

    @JsonIgnore
    @Transient
    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    @Transient
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.roles.stream().flatMap(userRole -> userRole.getPermissions().stream().map(Permissions::getSimpleGrantedAuthorityFor)).toList();
    }

    public String getPassword() {
        return this.password;
    }

    public MessengerUser setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public MessengerUser setLanguage(String language) {
        this.language = language;
        return this;
    }

    public List<UserRole> getRoles() {
        return this.roles;
    }

    public MessengerUser setRoles(List<UserRole> roles) {
        this.roles = roles;
        return this;
    }

    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public MessengerUser setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public OffsetDateTime getLockedUntil() {
        return this.lockedUntil;
    }

    public MessengerUser setLockedUntil(OffsetDateTime lockedUntil) {
        this.lockedUntil = lockedUntil;
        return this;
    }

    public boolean getExpirationEnabled() {
        return this.expirationEnabled;
    }

    public MessengerUser setExpirationEnabled(boolean expirationEnabled) {
        this.expirationEnabled = expirationEnabled;
        return this;
    }

    public int getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public MessengerUser setFailedLoginAttempts(int failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
        return this;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public MessengerUser setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public MessengerUser setTotpSecret(String totpSecret) {
        this.totpSecret = totpSecret;
        return this;
    }

    public boolean getTotpEnabled() {
        return this.totpEnabled;
    }

    public MessengerUser setTotpEnabled(boolean totpEnabled) {
        this.totpEnabled = totpEnabled;
        return this;
    }

    public void resetFailedAttemptCount() {
        this.failedLoginAttempts = 0;
    }

    public void increaseFailedAttemptCount() {
        ++this.failedLoginAttempts;
    }

    public MessengerUser setCurrentTimeSupplier(Supplier<OffsetDateTime> currentTimeSupplier) {
        this.currentTimeSupplier = currentTimeSupplier;
        return this;
    }

    public void eraseCredentials() {
        this.password = null;
    }
}

