/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.config.DatabaseConfig;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.hsqldb.Server;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.ServerConfiguration;
import org.hsqldb.server.ServerProperties;

public class HSQLDBController {
    private static final Logger LOGGER = LogManager.getLogger((String)("Messenger." + HSQLDBController.class.getName()));
    private final boolean needHSQL;
    private File dbLocation;
    private Server server;
    private String url;
    private String user;
    private String password;

    public HSQLDBController(DatabaseConfig databaseConfig) throws DbException {
        ServerProperties hsqlproperties;
        block16: {
            try {
                if (!databaseConfig.getUrl().startsWith("jdbc:hsqldb:")) {
                    this.needHSQL = false;
                    return;
                }
                this.needHSQL = true;
            }
            catch (Exception je) {
                throw new DbException(13000, "Could not load database configuration. " + String.valueOf(je));
            }
            this.dbLocation = Paths.get("data", "database", "xpmsglog").toFile();
            LOGGER.info("Starting up HSQL Database located at {}", (Object)this.dbLocation);
            try {
                this.url = databaseConfig.getUrl();
                this.user = databaseConfig.getUsername();
                this.password = databaseConfig.getPassword();
            }
            catch (Exception je) {
                throw new DbException(13000, "Could not load database configuration. " + String.valueOf(je));
            }
            hsqlproperties = null;
            try (InputStream serverStream = this.getClass().getClassLoader().getResourceAsStream("server.properties");){
                Properties prop = new Properties();
                prop.load(serverStream);
                hsqlproperties = new HsqlProperties(prop);
            }
            catch (Exception e) {
                String path = FileUtil.getFileUtil().canonicalOrAbsolutePath("server");
                hsqlproperties = ServerConfiguration.getPropertiesFromFile((int)1, (String)path, (String)"");
                if (!Objects.isNull(hsqlproperties)) break block16;
                hsqlproperties = new HsqlProperties();
            }
        }
        hsqlproperties.setProperty("server.database", this.dbLocation.getAbsolutePath());
        hsqlproperties.setProperty("server.no_system_exit", "true");
        ServerConfiguration.translateDefaultDatabaseProperty((HsqlProperties)hsqlproperties);
        ServerConfiguration.translateDefaultNoSystemExitProperty((HsqlProperties)hsqlproperties);
        try {
            this.server = new Server();
            this.server.setErrWriter(IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.ERROR).buildPrintWriter());
            this.server.setLogWriter(IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.INFO).buildPrintWriter());
            this.server.setProperties((HsqlProperties)hsqlproperties);
            this.server.start();
            Throwable dbError = this.server.getServerError();
            if (dbError != null) {
                throw dbError;
            }
        }
        catch (Throwable e) {
            throw new DbException(13000, "Could not initialize HSQL database. " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (!this.needHSQL || this.server.isNotRunning()) {
            return;
        }
        Connection con = null;
        Statement stmt = null;
        try {
            LOGGER.info("Waiting for DB compression");
            con = DriverManager.getConnection(this.url, this.user, this.password);
            stmt = con.createStatement();
            stmt.execute("CHECKPOINT DEFRAG");
            con.close();
            LOGGER.info("Waiting for DB Shutdown");
            this.server.shutdown();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        LOGGER.info("DB Shutdown completed");
    }
}

