/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpMessagePart;
import java.util.Objects;

public enum FileType {
    UNKNOWN(0),
    PAYLOAD(1),
    BACKEND_ENVELOPE(2),
    PACKAGING_ENVELOPE(3),
    CERTIFICATE(4),
    SIGNATURE(5),
    ATTACHMENT(6),
    PAYLOAD_TECHNICAL(7);

    private final int dbValue;

    private FileType(int dbValue) {
        this.dbValue = dbValue;
    }

    public int getDbValue() {
        return this.dbValue;
    }

    public static FileType fromDbValue(Integer dbValue) {
        if (Objects.isNull(dbValue)) {
            return PAYLOAD;
        }
        for (FileType fileType : FileType.values()) {
            if (fileType.getDbValue() != dbValue.intValue()) continue;
            return fileType;
        }
        throw new IllegalArgumentException("Unknown file type: " + dbValue);
    }

    public static boolean isPayLoad(FileType fileType) {
        return fileType == PAYLOAD;
    }

    public static boolean isPayLoad(Integer dbValue) {
        return Objects.isNull(dbValue) || dbValue.intValue() == PAYLOAD.getDbValue();
    }

    public boolean isPayLoad() {
        return this.dbValue == PAYLOAD.getDbValue();
    }

    public static boolean isAttachment(Integer dbValue) {
        return Objects.nonNull(dbValue) && dbValue.intValue() == ATTACHMENT.getDbValue();
    }

    public static FileType fromXpMessagePart(XpMessagePart xpMessagePart) {
        if (Objects.isNull((Object)xpMessagePart)) {
            return UNKNOWN;
        }
        return switch (xpMessagePart) {
            default -> throw new MatchException(null, null);
            case XpMessagePart.PAYLOAD -> PAYLOAD;
            case XpMessagePart.BACKEND_ENVELOPE -> BACKEND_ENVELOPE;
            case XpMessagePart.PACKAGING_ENVELOPE -> PACKAGING_ENVELOPE;
            case XpMessagePart.CERTIFICATE -> CERTIFICATE;
            case XpMessagePart.SIGNATURE -> SIGNATURE;
            case XpMessagePart.ATTACHMENT -> ATTACHMENT;
        };
    }
}

