/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.tables.AdapterInfoDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ConversationDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.InboundQueueingDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.LogMessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageLogDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.OutboundQueueMessageDAO;

public class DbConsistencyChecker {
    private final AdapterInfoDAO _adapterInfoDAO;
    private final InboundQueueingDAO _inboundQueueingDAO;
    private final OutboundQueueMessageDAO _outboundQueueMessageDAO;
    private final MDNDataDAO _mdnDataDAO;
    private final FileRefDAO _fileRefDAO;
    private final MessageLogDAO _messageLogDAO;
    private final LogMessageDAO _logMessageDAO;
    private final MessageDAO _messageDAO;
    private final ConversationDAO _conversationDAO;

    public DbConsistencyChecker(AdapterInfoDAO adapterInfoDAO, InboundQueueingDAO inboundQueueingDAO, OutboundQueueMessageDAO outboundQueueMessageDAO, MDNDataDAO mdnDataDAO, FileRefDAO fileRefDAO, MessageLogDAO messageLogDAO, LogMessageDAO logMessageDAO, MessageDAO messageDAO, ConversationDAO conversationDAO) {
        this._adapterInfoDAO = adapterInfoDAO;
        this._inboundQueueingDAO = inboundQueueingDAO;
        this._outboundQueueMessageDAO = outboundQueueMessageDAO;
        this._mdnDataDAO = mdnDataDAO;
        this._fileRefDAO = fileRefDAO;
        this._messageLogDAO = messageLogDAO;
        this._logMessageDAO = logMessageDAO;
        this._messageDAO = messageDAO;
        this._conversationDAO = conversationDAO;
    }

    public void checkConsistency() throws DbException {
        this.dbCleanup();
        this.dbConsistencyCheck();
        this.dbCleanup();
    }

    private void dbConsistencyCheck() throws DbException {
        this._conversationDAO.dbConsistencyCheck();
        this._logMessageDAO.dbConsistencyCheck();
        this._adapterInfoDAO.dbConsistencyCheck();
        Message testMessage = this._messageDAO.dbConsistencyCheck();
        this._messageLogDAO.dbConsistencyCheck(testMessage);
        this._fileRefDAO.dbConsistencyCheck(testMessage);
        this._mdnDataDAO.dbConsistencyCheck(testMessage);
        this._outboundQueueMessageDAO.dbConsistencyCheck(testMessage);
        this._inboundQueueingDAO.dbConsistencyCheck(testMessage);
    }

    private void dbCleanup() throws DbException {
        this._adapterInfoDAO.dbCleanup();
        Message testMessage = this._messageDAO.getTestMessage();
        if (testMessage != null) {
            this._inboundQueueingDAO.deleteFromInboundQueue(testMessage.getId());
            this._outboundQueueMessageDAO.deleteMessage(testMessage.getId());
            this._mdnDataDAO.dbCleanup(testMessage.getId());
            this._fileRefDAO.dbCleanup(testMessage.getId());
            this._messageLogDAO.dbCleanup(testMessage.getId());
            this._messageDAO.dbCleanup(testMessage.getId());
        }
        this._logMessageDAO.dbCleanup();
        this._conversationDAO.dbCleanup();
    }
}

