/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.common.security.PasswordCrypt;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Provider;
import java.security.Security;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import liquibase.UpdateSummaryOutputEnum;
import liquibase.command.CommandScope;
import liquibase.command.core.ExecuteSqlCommandStep;
import liquibase.command.core.ListLocksCommandStep;
import liquibase.command.core.ReleaseLocksCommandStep;
import liquibase.command.core.SnapshotCommandStep;
import liquibase.command.core.StatusCommandStep;
import liquibase.command.core.UnexpectedChangesetsCommandStep;
import liquibase.command.core.UpdateCommandStep;
import liquibase.command.core.UpdateSqlCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.command.core.helpers.ShowSummaryArgument;
import liquibase.exception.CommandExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DBUpdateTools {
    private static final Logger _log = LogManager.getLogger((String)"liquibase.DBUpdateTools");
    private static final String PARAM_UPDATE = "update";
    private static final String PARAM_SCRIPT = "updateScript";
    private static final String PARAM_SNAPSHOT = "snapshot";
    private static final String PARAM_STATUS = "status";
    private static final String PARAM_LIST_LOCKS = "listLocks";
    private static final String PARAM_RELEASE_LOCKS = "releaseLocks";
    private static final String PARAM_LIST_ACTIVATIONS = "listActivations";
    private static final String PARAM_DELETE_ACTIVATION = "deleteActivation";
    private static final String PARAM_REST_ADMIN_ACCOUNT = "resetAdminAccount";
    private static final String MESSENGER_CHANGELOG = "db/changelog.xml";
    private static final String HSQL_URL = "jdbc:hsqldb:hsql://localhost";
    private static final String WRAPPER_CONF_SET_PREFIX = "set.";
    private static final String WRAPPER_CONF_SET_DEFAULT_PREFIX = "set.default.";
    private final boolean isStandalone;
    private final String url;
    private final String user;
    private final String password;

    public static void main(String[] args) throws Exception {
        String command = args.length >= 1 ? args[0] : "---";
        String param = args.length >= 2 ? args[1] : null;
        ConnectionParams connectionParams = DBUpdateTools.getConnectionParams();
        if (Objects.isNull(connectionParams.url) || connectionParams.url.isEmpty()) {
            System.err.println("JDBC Database URL not found.");
            System.exit(1);
        }
        if (connectionParams.url.startsWith(HSQL_URL)) {
            System.err.println("Embedded HSQL Database (" + connectionParams.url + ") is not supported by DBUpdateTools, because the database is started by PONTON X/P Messenger only.");
            System.exit(1);
        }
        DBUpdateTools dbUpdateTools = new DBUpdateTools(true, connectionParams.url, connectionParams.user, connectionParams.password);
        switch (command) {
            case "status": {
                dbUpdateTools.status();
                break;
            }
            case "update": {
                dbUpdateTools.updateDB();
                break;
            }
            case "updateScript": {
                dbUpdateTools.createUpdateSQL();
                break;
            }
            case "snapshot": {
                dbUpdateTools.logDBSnapshot();
                break;
            }
            case "listLocks": {
                dbUpdateTools.listLocks();
                break;
            }
            case "releaseLocks": {
                dbUpdateTools.releaseLocks();
                break;
            }
            case "listActivations": {
                dbUpdateTools.listActivations();
                break;
            }
            case "deleteActivation": {
                dbUpdateTools.deleteActivation(param);
                break;
            }
            case "resetAdminAccount": {
                dbUpdateTools.resetAdminAccount();
                break;
            }
            default: {
                DBUpdateTools.printHelpAndExit();
            }
        }
    }

    private static void printHelpAndExit() {
        System.out.println("DBUpdateTools for PONTON X/P Messenger DB. Supported arguments are:");
        System.out.println(" - status: List of undeployed changesets, which will be deployed during update process.");
        System.out.println(" - update: Runs the structural updates of Messenger DB.");
        System.out.println(" - updateScript: Generates a native SQL Script, containing all required structural updates for current Messenger DB.");
        System.out.println(" - snapshot: Dumps a snapshot of current Messenger DB structure.");
        System.out.println(" - listLocks: List currently locked database objects. This may happen, if a update process failed.");
        System.out.println(" - releaseLocks: Releases all locked database objects, to rerun failed update process.");
        System.out.println(" - listActivations: Lists all activation records from Messenger DB");
        System.out.println(" - deleteActivation #instanceAlias#: removes the given activation record from Messenger DB");
        System.out.println(" - resetAdminAccount: Resets the 'xpadmin' account to factory settings");
        System.exit(1);
    }

    private static ConnectionParams getConnectionParams() throws Exception {
        File wrapperConfFile = new File("../launcher/conf", "wrapper.conf");
        Properties wrapperConfProps = new Properties();
        wrapperConfProps.load(new BufferedInputStream(Files.newInputStream(wrapperConfFile.toPath(), new OpenOption[0])));
        String url = DBUpdateTools.readEnvProperty(wrapperConfProps, "DATABASE_URL");
        String usr = DBUpdateTools.readEnvProperty(wrapperConfProps, "DATABASE_USER");
        String pw = DBUpdateTools.readEnvProperty(wrapperConfProps, "DATABASE_PASSWORD");
        Security.addProvider((Provider)new BouncyCastleProvider());
        PasswordCrypt passwordCrypt = new PasswordCrypt("IpIndependent");
        pw = MessengerConfig.getRealPassword(passwordCrypt, pw);
        return new ConnectionParams(url, usr, pw);
    }

    private static String readEnvProperty(Properties wrapperConfProps, String envProperty) {
        String envPropValue = System.getenv(envProperty);
        if ((Objects.isNull(envPropValue) || envPropValue.trim().isEmpty()) && (Objects.isNull(envPropValue = wrapperConfProps.getProperty(WRAPPER_CONF_SET_PREFIX + envProperty)) || envPropValue.trim().isEmpty())) {
            envPropValue = wrapperConfProps.getProperty(WRAPPER_CONF_SET_DEFAULT_PREFIX + envProperty);
        }
        return envPropValue;
    }

    public DBUpdateTools(boolean standalone, String url, String user, String password) throws Exception {
        this.isStandalone = standalone;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public void status() throws CommandExecutionException {
        new CommandScope(StatusCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(UpdateCommandStep.CHANGELOG_FILE_ARG, (Object)MESSENGER_CHANGELOG).execute();
    }

    public void updateDB() throws CommandExecutionException {
        block18: {
            try (Connection conn = DriverManager.getConnection(this.url, this.user, this.password);){
                DatabaseMetaData meta = conn.getMetaData();
                String dbProductName = meta.getDatabaseProductName();
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbProductName) && !dbProductName.toLowerCase().contains("sql server")) break block18;
                String changesetId = "4.6.5-1";
                _log.info("MSSQL database detected, checking for changelog entry 4.6.5-1");
                String deleteSql = "DELETE FROM DATABASECHANGELOG WHERE ID = ?";
                try (PreparedStatement stmt = conn.prepareStatement(deleteSql);){
                    stmt.setString(1, "4.6.5-1");
                    int deleted = stmt.executeUpdate();
                    if (deleted > 0) {
                        _log.info("Deleted {} changelog entry with ID: {}", (Object)deleted, (Object)"4.6.5-1");
                    } else {
                        _log.debug("No changelog entry found with ID: {}", (Object)"4.6.5-1");
                    }
                }
            }
            catch (SQLException e) {
                _log.warn("Could not check database type or delete changelog entry: {}", (Object)e.getMessage());
            }
        }
        this.checkUnexpectedChangesets();
        try {
            _log.info("Start update of DB structure on {}", (Object)this.url);
            System.setProperty("liquibase.sql.logLevel", "INFO");
            new CommandScope(UpdateCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(UpdateCommandStep.CHANGELOG_FILE_ARG, (Object)MESSENGER_CHANGELOG).addArgumentValue(ShowSummaryArgument.SHOW_SUMMARY_OUTPUT, (Object)UpdateSummaryOutputEnum.LOG).execute();
        }
        catch (CommandExecutionException e) {
            _log.error("Can't update DB structure: " + e.getMessage(), (Throwable)e);
            this.logDBSnapshot();
            throw e;
        }
    }

    public void createUpdateSQL() throws CommandExecutionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CommandScope(UpdateSqlCommandStep.COMMAND_NAME).setOutput((OutputStream)out).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(UpdateCommandStep.CHANGELOG_FILE_ARG, (Object)MESSENGER_CHANGELOG).execute();
        if (this.isStandalone) {
            System.out.println(out);
        } else {
            _log.warn(">>> SQL-Script for DBUpdate:");
            _log.warn(out.toString());
            _log.warn("<<< End-of-SQL-Script");
        }
    }

    public void logDBSnapshot() throws CommandExecutionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CommandScope(SnapshotCommandStep.COMMAND_NAME).setOutput((OutputStream)out).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(SnapshotCommandStep.SNAPSHOT_FORMAT_ARG, (Object)"TXT").execute();
        if (this.isStandalone) {
            System.out.println(out);
        } else {
            _log.warn(">>> DB-Snapshot:");
            _log.warn(out.toString());
            _log.warn("<<< End-of-DB-Snapshot");
        }
    }

    private void listLocks() throws CommandExecutionException {
        new CommandScope(ListLocksCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).execute();
    }

    private void releaseLocks() throws CommandExecutionException {
        new CommandScope(ReleaseLocksCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).execute();
    }

    private void listActivations() throws CommandExecutionException {
        new CommandScope(ExecuteSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(ExecuteSqlCommandStep.SQL_ARG, (Object)"SELECT INSTANCE_ID, IP_ADDRESS, LAST_STARTUP, LAST_HEART_BEAT FROM MESSENGER_ACTIVATION").execute();
    }

    private void deleteActivation(String param) throws CommandExecutionException {
        if (StringUtils.isBlank((CharSequence)param)) {
            System.err.println("Parameter #instanceAlias# is missing!");
            DBUpdateTools.printHelpAndExit();
        }
        new CommandScope(ExecuteSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(ExecuteSqlCommandStep.SQL_ARG, (Object)("DELETE FROM MESSENGER_ACTIVATION WHERE INSTANCE_ALIAS = '" + param + "'")).execute();
    }

    private void resetAdminAccount() throws CommandExecutionException {
        new CommandScope(ExecuteSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(ExecuteSqlCommandStep.SQL_ARG, (Object)"DELETE FROM MESSENGER_USER WHERE USERNAME = 'xpadmin'").execute();
        if (this.url.startsWith("jdbc:sqlserver")) {
            new CommandScope(ExecuteSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(ExecuteSqlCommandStep.SQL_ARG, (Object)"INSERT INTO MESSENGER_USER (USERNAME,PASSWORD,EXPIRATION_ENABLED,DISABLED,FAILED_LOGIN_ATTEMPTS,TOTP_ENABLED) VALUES ('xpadmin', '{SHA-1}b0d2655ef242e11f360b75af3fdc610cfebedec2', 'true', 'false', 0, 'false')").execute();
        } else {
            new CommandScope(ExecuteSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(ExecuteSqlCommandStep.SQL_ARG, (Object)"INSERT INTO MESSENGER_USER (USERNAME,PASSWORD,EXPIRATION_ENABLED,DISABLED,FAILED_LOGIN_ATTEMPTS,TOTP_ENABLED) VALUES ('xpadmin', '{SHA-1}b0d2655ef242e11f360b75af3fdc610cfebedec2', true, false, 0, false)").execute();
        }
        new CommandScope(ExecuteSqlCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(ExecuteSqlCommandStep.SQL_ARG, (Object)"INSERT INTO MESSENGER_USER_ROLE (USERNAME,USER_ROLE_ID) VALUES ('xpadmin', 'ROLE_administrator')").execute();
    }

    private void checkUnexpectedChangesets() throws CommandExecutionException {
        try {
            _log.info("Checking for unexpected changesets in DB structure on {}", (Object)this.url);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new CommandScope(UnexpectedChangesetsCommandStep.COMMAND_NAME).setOutput((OutputStream)out).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url).addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.user).addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password).addArgumentValue(UpdateCommandStep.CHANGELOG_FILE_ARG, (Object)MESSENGER_CHANGELOG).execute();
            String result = out.toString().trim();
            if (result.contains("unexpected changes were found")) {
                throw new CommandExecutionException("The Messenger has to be updated. DB structure has changed: " + result);
            }
        }
        catch (CommandExecutionException e) {
            _log.error("Error checking for unexpected changesets: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    public record ConnectionParams(String url, String user, String password) {
    }
}

