/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.adapter;

import de.pontonconsulting.common.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.adapter.AgreementPartners;
import de.pontonconsulting.xmlpipe.adapter.ExtendedMessageResult;
import de.pontonconsulting.xmlpipe.adapter.IMessengerCommunication;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MaintenanceModeException;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.StatusResult;
import de.pontonconsulting.xmlpipe.adapter.TransportURLType;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageConverter;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.Messages;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.DuplicateInProcessException;
import de.pontonconsulting.xmlpipe.messenger.DuplicateInProcessGuardian;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.MessageRegistrationService;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.SendToArchiveOnly;
import de.pontonconsulting.xmlpipe.messenger.SendToListener;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpOutboundMessage;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectMessengerCommunication
implements IMessengerCommunication {
    private static final String PARTNER_ACCESS_PROBLEM = "Partner data could not be accessed";
    public static final Logger _log = LogManager.getLogger((String)"Messenger.DirectCommunication");
    private static final AtomicLong _count = new AtomicLong(0L);
    private final ActivationControl _activation;
    private final AdapterRegistry _adapterRegistry;
    private final Agreements _agreements;
    private final ReferenceDateTask referenceDateTask;
    private final Profiles _profiles;
    private final SendToListener _sendToListener;
    private final SendToArchiveOnly _sendToArchiveOnly;
    private final Messages _messages;
    private final MessengerConfig _messengerConfig;
    private final IFolders _folders;
    private final IdGenerator _idGenerator;
    private final MaintenanceManager _maintenanceManager;
    private final BackEndMessageConverter _converter;
    private final DuplicateInProcessGuardian duplicateInProcessGuardian;
    private final MessageRegistrationService messageRegistrationService;

    public DirectMessengerCommunication(ActivationControl activation, AdapterRegistry adapterRegistry, Agreements agreements, ReferenceDateTask referenceDateTask, Profiles profiles, SendToListener sendToListener, SendToArchiveOnly sendToArchiveOnly, Messages messages, MessengerConfig messengerConfig, IFolders folders, IdGenerator idGenerator, MaintenanceManager maintenanceManager, BackEndMessageConverter converter, DuplicateInProcessGuardian duplicateInProcessGuardian, MessageRegistrationService messageRegistrationService) {
        this._activation = activation;
        this._adapterRegistry = adapterRegistry;
        this._agreements = agreements;
        this.referenceDateTask = referenceDateTask;
        this._profiles = profiles;
        this._sendToListener = sendToListener;
        this._sendToArchiveOnly = sendToArchiveOnly;
        this._messages = messages;
        this._messengerConfig = messengerConfig;
        this._folders = folders;
        this._idGenerator = idGenerator;
        this._maintenanceManager = maintenanceManager;
        this._converter = converter;
        this.duplicateInProcessGuardian = duplicateInProcessGuardian;
        this.messageRegistrationService = messageRegistrationService;
    }

    /*
     * Exception decompiling
     */
    public MessageResult sendOutboundDocument(BackEndMessage beMessage, String adapterId) throws AdapterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ExtendedMessageResult createExtendedMessageResult(MessageResult.MessageResultIdentifier resultIdentifier, BackEndMessage backEndMessage) {
        ExtendedMessageResult result = new ExtendedMessageResult(resultIdentifier);
        this.setMessageResult(result, backEndMessage);
        return result;
    }

    private void setMessageResult(ExtendedMessageResult result, BackEndMessage beMessage) {
        result.setMessageId(beMessage.getTransferIDText());
        result.setConversationId(beMessage.getConversationIDText());
        result.setMessageTime(String.valueOf(beMessage.getCreationTimestamp()));
        result.setMessageType(beMessage.getMessageName());
        result.setSchemaVersion(beMessage.getDTDVersionNumberText());
        result.setSchemaSet(beMessage.getDTDSetText());
        result.setProcessingDirectives((Map)beMessage.getProcessingDirectivesMap());
        result.setSenderId(beMessage.getSenderOrganisationText());
        result.setReceiverId(beMessage.getReceiverOrganisationText());
        result.setTestMessage("Test".equalsIgnoreCase(beMessage.getTestFlag()));
    }

    private File getNewTempFolder() {
        long id = this.getNextId();
        File outboundMessageFolder = new File(this._folders.getWorkOutboundFolder(), "d-" + id);
        if (outboundMessageFolder.exists()) {
            DirectMessengerCommunication.deleteDirectory(outboundMessageFolder);
        }
        return outboundMessageFolder;
    }

    public static boolean deleteDirectory(File folder) {
        if (!folder.exists() || !folder.isDirectory()) {
            return false;
        }
        boolean allOk = true;
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (DirectMessengerCommunication.deleteDirectory(file)) continue;
                allOk = false;
                continue;
            }
            if (file.delete()) continue;
            allOk = false;
        }
        if (!folder.delete()) {
            allOk = false;
        }
        return allOk;
    }

    private void cleanupTempFolder(File outboundMessageFolder) {
        if (outboundMessageFolder == null || !outboundMessageFolder.exists()) {
            return;
        }
        if (!Messenger.isDevelopmentMode()) {
            if (!DirectMessengerCommunication.deleteDirectory(outboundMessageFolder)) {
                _log.warn("folder {} was not successfully deleted.", (Object)outboundMessageFolder);
            }
        } else {
            _log.trace("folder {} was not deleted due to development mode.", (Object)outboundMessageFolder);
        }
    }

    private long getNextId() {
        return _count.incrementAndGet();
    }

    private XpMessage storeMessage(BackEndMessage beMessage, String adapterId, File outboundMessageFolder) throws BackEndMessageException, IOException {
        File source;
        Object extension = ".dat";
        if (StringUtils.isNotEmpty((CharSequence)beMessage.getMimeType())) {
            extension = MimeTypeMapper.getExtension(beMessage.getMimeType());
        } else {
            String extractedExtension = FilenameUtils.getExtension((String)beMessage.getFilename());
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                extension = "." + extractedExtension.trim().toLowerCase();
            }
        }
        String payloadFilename = "payload" + (String)extension;
        File payloadFile = new File(outboundMessageFolder, payloadFilename);
        XpMessage xpMessage = this._converter.getXpMessage(beMessage);
        String processedOriginalFilename = xpMessage.getProcessingDirective("ProcessedOriginalFilename");
        if (StringUtils.isEmpty((CharSequence)processedOriginalFilename)) {
            xpMessage.setProcessingDirective("ProcessedOriginalFilename", "payload-" + System.nanoTime() + (String)extension);
        }
        if ((source = beMessage.getSourceFile()) != null && source.getParentFile().getParentFile().equals(outboundMessageFolder.getParentFile())) {
            source.renameTo(new File(source.getParentFile(), payloadFile.getName()));
            File tempMessageFolder = source.getParentFile();
            tempMessageFolder.renameTo(outboundMessageFolder);
            xpMessage.setCurrentContentReference(payloadFile);
            xpMessage.setCurrentContentType(beMessage.getMimeType());
            Vector<XpMessageAttachment> attachments = xpMessage.getAttachments();
            if (attachments != null && attachments.size() > 0) {
                new File(outboundMessageFolder.getAbsolutePath() + File.separator + attachments.get(0).getAttachment().getParentFile().getName()).renameTo(new File(outboundMessageFolder.getAbsolutePath() + File.separator + "attachments"));
                for (XpMessageAttachment xpMessageAttachment : attachments) {
                    File attachmentFile = xpMessageAttachment.getAttachment();
                    File newFile = new File(outboundMessageFolder.getAbsolutePath() + File.separator + "attachments" + File.separator + attachmentFile.getName());
                    xpMessageAttachment.setAttachment(newFile);
                }
            }
        } else {
            outboundMessageFolder.mkdirs();
            this.writePayloadToFile(xpMessage, beMessage, payloadFile);
            this.copyAttachmentsToFolder(xpMessage, beMessage, outboundMessageFolder, false);
        }
        this.storeBackEndEnvelope(beMessage, outboundMessageFolder);
        xpMessage.setMessageTimestamp(this.referenceDateTask.getReferenceDate());
        xpMessage.setCurrentContentReferenceFolder(outboundMessageFolder);
        xpMessage.setAdapterId(adapterId);
        xpMessage.setMessengerId(this._messengerConfig.getMessengerId());
        if (_log.isTraceEnabled()) {
            _log.trace("Data successfully received from adapter.");
        }
        return xpMessage;
    }

    private void storeBackEndEnvelope(BackEndMessage beMessage, File outboundMessageFolder) {
        File backendEnvelopeFile = new File(outboundMessageFolder, "xp_backendmessage.xml");
        try {
            beMessage.writeBackEndEnvelopeTo(backendEnvelopeFile);
        }
        catch (Exception e) {
            _log.warn("BackendEnvelope could not be stored:{}", (Object)e.getMessage());
        }
    }

    public String[] getFullPartnerList() throws AdapterException {
        if (_log.isTraceEnabled()) {
            _log.trace("full Partner ID-list requested.");
        }
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        Set<String> partners = this._profiles.getAllInternalIds();
        return partners.toArray(new String[partners.size()]);
    }

    public String[] getLocalPartnerList() throws AdapterException {
        if (_log.isTraceEnabled()) {
            _log.trace("local Partner ID-list requested.");
        }
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        Set<String> partners = this._profiles.getLocalInternalIds();
        return partners.toArray(new String[partners.size()]);
    }

    public String[] getRemotePartnerList() throws AdapterException {
        if (_log.isTraceEnabled()) {
            _log.trace("remote Partner ID-list requested.");
        }
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        Set<String> partners = this._messengerConfig.isLoopback() ? this._profiles.getAllInternalIds() : this._profiles.getRemoteInternalIds();
        return partners.toArray(new String[0]);
    }

    public AgreementPartners[] getAgreementPartnersList() throws AdapterException {
        if (_log.isTraceEnabled()) {
            _log.trace("agreement partners list requested.");
        }
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        return (AgreementPartners[])this._agreements.getAgreementList().stream().map(a -> new AgreementPartners(a.getOwnPartnerBackendId(), a.getCommunicationPartnerBackendId())).toArray(AgreementPartners[]::new);
    }

    public boolean partnerExists(String partnerId) throws AdapterException {
        if (_log.isTraceEnabled()) {
            _log.trace("Partner information requested.");
            _log.trace("Getting partner information for partner: {}", (Object)partnerId);
        }
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        CppPartner partner = null;
        try {
            partner = this._profiles.getProfileForInternalId(partnerId, true);
        }
        catch (ProfileNotFoundException pnfe) {
            if (_log.isTraceEnabled()) {
                _log.trace("Partner with the id: {} not found in store.", (Object)partnerId);
            }
        }
        catch (ProfileException pe) {
            _log.error("Cannot access the partner storage.", (Throwable)pe);
            throw new AdapterException(PARTNER_ACCESS_PROBLEM);
        }
        return partner != null;
    }

    public List<MessageResult> pingPartnerEndpoints(String senderId, String receiverId, String adapterId) throws AdapterException {
        ArrayList<MessageResult> messageResults = new ArrayList<MessageResult>();
        Profiles.initThreadCache();
        Agreements.initThreadCache();
        try {
            CppPartner sender = this._profiles.getProfileForInternalId(senderId, true);
            CppPartner receiver = this._profiles.getProfileForInternalId(receiverId, true);
            Communication communication = this._agreements.getAgreement(sender.getLocalId(), receiver.getLocalId(), true).getCommunication(sender.getLocalId(), receiver.getLocalId());
            String transportFallbackURL = communication.getTransportFallbackURL();
            messageResults.add(this.pingPartner(senderId, receiverId, adapterId, TransportURLType.PRIMARY));
            if (transportFallbackURL != null && !transportFallbackURL.isEmpty()) {
                messageResults.add(this.pingPartner(senderId, receiverId, adapterId, TransportURLType.FALLBACK));
            }
        }
        catch (Exception e) {
            throw new AdapterException(e.getMessage(), (Throwable)e);
        }
        finally {
            Agreements.clearThreadCache();
            Profiles.clearThreadCache();
        }
        return messageResults;
    }

    public MessageResult pingPartner(String senderId, String receiverId, String adapterId) {
        return this.pingPartner(senderId, receiverId, adapterId, TransportURLType.FIXED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageResult pingPartner(String senderId, String receiverId, String adapterId, TransportURLType transportURLType) {
        if (_log.isInfoEnabled()) {
            _log.info("Received ping request to partner: {} from adapter {}", (Object)receiverId, (Object)adapterId);
        }
        XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(adapterId);
        ExtendedMessageResult result = null;
        if (!this._activation.isActive()) {
            _log.error("Messenger license not activated. ping blocked.");
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger license not activated. sending blocked.");
            result = new ExtendedMessageResult(MessageResult.MESSENGER_DOES_NOT_ACCEPT_REQUESTS);
        } else if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger is in maintenance mode. sending blocked.");
            result = new ExtendedMessageResult(MessageResult.MAINTENANCE_MODE);
        }
        if (result != null) {
            result.setSenderId(senderId);
            result.setReceiverId(receiverId);
            result.setTransportURLType(transportURLType);
            return result;
        }
        Object lockObject = new Object();
        XpMessage xpMessage = new XpMessage();
        this._maintenanceManager.putLock(lockObject);
        xpMessage.setDatabaseId(tempMessage.getDatabaseId());
        xpMessage.setSenderInternalId(senderId);
        xpMessage.setReceiverInternalId(receiverId);
        xpMessage.setMessageType("PING");
        xpMessage.setTransportURLType(transportURLType);
        xpMessage.setSchemaSet("ponton");
        xpMessage.setMessageVersion("2.1");
        xpMessage.setMessageId(this._idGenerator.generateMessageId());
        xpMessage.setMessageTimestamp(tempMessage.getRegistrationTimestamp());
        xpMessage.setRegistrationTimestamp(tempMessage.getRegistrationTimestamp());
        xpMessage.setAdapterId(adapterId);
        File outboundMessageFolder = this.getNewTempFolder();
        outboundMessageFolder.mkdir();
        xpMessage.setCurrentContentReferenceFolder(outboundMessageFolder);
        Profiles.initThreadCache();
        Agreements.initThreadCache();
        try {
            SendToListenerResult sendToListenerResult = this._sendToListener.handleMessage(xpMessage);
            MessageResult messageResult = this.convertSendToListenerResultToExtendedMessageResult(sendToListenerResult);
            return messageResult;
        }
        catch (MessageRecognitionException e) {
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, e.getMessage());
            result = new ExtendedMessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            result.appendToDescription(e.getMessage());
            ExtendedMessageResult extendedMessageResult = result;
            return extendedMessageResult;
        }
        finally {
            this.cleanupTempFolder(outboundMessageFolder);
            this._maintenanceManager.removeLock(lockObject);
            Agreements.clearThreadCache();
            Profiles.clearThreadCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResult sendStatusRequest(String senderId, String receiverId, String referenceId, String adapterId) {
        if (_log.isInfoEnabled()) {
            _log.info("Status Request to partner: {} reference MSG: {} received from adapter {}", (Object)receiverId, (Object)referenceId, (Object)adapterId);
        }
        XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(adapterId);
        ExtendedMessageResult result = null;
        if (!this._activation.isActive()) {
            _log.error("Messenger license not activated. status request blocked.");
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger license not activated. sending blocked.");
            result = new ExtendedMessageResult(MessageResult.MESSENGER_DOES_NOT_ACCEPT_REQUESTS);
        } else if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger is in maintenance mode. sending blocked.");
            result = new ExtendedMessageResult(MessageResult.MAINTENANCE_MODE);
        }
        if (result != null) {
            result.setSenderId(senderId);
            result.setReceiverId(receiverId);
            return result;
        }
        Object lockObject = new Object();
        XpMessage msg = new XpMessage();
        this._maintenanceManager.putLock(lockObject);
        msg.setDatabaseId(tempMessage.getDatabaseId());
        msg.setSenderInternalId(senderId);
        msg.setReceiverInternalId(receiverId);
        msg.setMessageType("StatusRequest");
        msg.setSchemaSet("ponton");
        msg.setMessageVersion("2.1");
        msg.setMessageId(this._idGenerator.generateMessageId());
        msg.setReferenceId(referenceId);
        msg.setMessageTimestamp(this.referenceDateTask.getReferenceDate());
        msg.setAdapterId(adapterId);
        File outboundMessageFolder = this.getNewTempFolder();
        outboundMessageFolder.mkdir();
        msg.setCurrentContentReferenceFolder(outboundMessageFolder);
        Profiles.initThreadCache();
        Agreements.initThreadCache();
        try {
            SendToListenerResult sendToListenerResult = this._sendToListener.handleMessage(msg);
            MessageResult messageResult = this.convertSendToListenerResultToExtendedMessageResult(sendToListenerResult);
            return messageResult;
        }
        catch (MessageRecognitionException e) {
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, e.getMessage());
            result = new ExtendedMessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            result.appendToDescription(e.getMessage());
            ExtendedMessageResult extendedMessageResult = result;
            return extendedMessageResult;
        }
        finally {
            this.cleanupTempFolder(outboundMessageFolder);
            this._maintenanceManager.removeLock(lockObject);
            Agreements.clearThreadCache();
            Profiles.clearThreadCache();
        }
    }

    private MessageResult convertSendToListenerResultToExtendedMessageResult(SendToListenerResult sendToListenerResult) {
        ExtendedMessageResult result = new ExtendedMessageResult(this.mapEnumValue(sendToListenerResult.getResult()));
        XpOutboundMessage xpOutboundMessage = sendToListenerResult.getXpOutboundQueueMessage();
        if (sendToListenerResult.getDetails() != null) {
            result.appendToDescription(sendToListenerResult.getDetails());
        }
        if (sendToListenerResult.getException() != null) {
            result.appendToDescription((Throwable)sendToListenerResult.getException());
        }
        result.setMessageId(xpOutboundMessage.getMessageId());
        result.setConversationId(xpOutboundMessage.getConversationId());
        result.setMessageTime(String.valueOf(xpOutboundMessage.getMessageTimestamp().getTime()));
        result.setMessageType(xpOutboundMessage.getMessageType());
        result.setSchemaVersion(xpOutboundMessage.getMessageVersion());
        result.setSchemaSet(xpOutboundMessage.getSchemaSet());
        result.setProcessingDirectives(xpOutboundMessage.getProcessingDirectives());
        result.setSenderId(xpOutboundMessage.getSenderInternalId());
        result.setReceiverId(xpOutboundMessage.getReceiverInternalId());
        result.setTestMessage(xpOutboundMessage.isTestMessage());
        result.setTransmissionProtocol(xpOutboundMessage.getProtocol());
        return result;
    }

    private MessageResult.MessageResultIdentifier mapEnumValue(SendToListenerResult.Result result) {
        switch (result) {
            case MSG_SUCCESSFULLY_SENT: {
                return MessageResult.MSG_SUCCESSFULLY_SEND;
            }
            case COULD_NOT_PACKAGE_MESSAGE: {
                return MessageResult.COULD_NOT_PACKAGE_MESSAGE;
            }
            case ENCRYPTION_FAILED: {
                return MessageResult.ENCRYPTION_FAILED;
            }
            case SIGNING_FAILED: {
                return MessageResult.SIGNING_FAILED;
            }
            case VALIDATION_FAILED: {
                return MessageResult.VALIDATION_FAILED;
            }
            case COMPRESSION_FAILED: {
                return MessageResult.COMPRESSION_FAILED;
            }
            case PARTNER_IS_NOT_KNOWN: {
                return MessageResult.PARTNER_IS_NOT_KNOWN;
            }
            case PARTNER_IS_DISABLED: {
                return MessageResult.PARTNER_IS_DISABLED;
            }
            case NO_AGREEMENT_FOUND: {
                return MessageResult.NO_AGREEMENT_FOUND;
            }
            case DUPLICATE_MESSAGE_ID: {
                return MessageResult.DUPLICATE_MESSAGE_ID;
            }
            case PENDING_MESSAGE_ID: {
                return MessageResult.PENDING_MESSAGE_ID;
            }
            case SENDER_IS_NOT_A_LOCAL_PARTNER: {
                return MessageResult.SENDER_IS_NOT_A_LOCAL_PARTNER;
            }
            case RECEIVER_IS_NOT_A_REMOTE_PARTNER: {
                return MessageResult.RECEIVER_IS_NOT_A_REMOTE_PARTNER;
            }
            case COULD_NOT_SAVE_MESSAGE_PAYLOAD: {
                return MessageResult.COULD_NOT_SAVE_MESSAGE_PAYLOAD;
            }
            case PARTNER_STORE_COULD_NOT_BE_ACCESSED: {
                return MessageResult.PARTNER_STORE_COULD_NOT_BE_ACCESSED;
            }
            case TRANSPORT_PROVIDER_NOT_FOUND: {
                return MessageResult.TRANSPORT_PROVIDER_NOT_FOUND;
            }
            case COULD_NOT_INITIALIZE_PIPELINE: {
                return MessageResult.COULD_NOT_INITIALIZE_PIPELINE;
            }
            case DUPLICATE_SEQUENCE_NUMBER: {
                return MessageResult.DUPLICATE_SEQUENCE_NUMBER;
            }
            case COULD_NOT_PROCESS_MESSAGE: {
                return MessageResult.COULD_NOT_PROCESS_MESSAGE;
            }
        }
        throw new RuntimeException("illegal enum value " + String.valueOf((Object)result));
    }

    public MessageResult registerAdapter(ISpecificAdapter adapterInstance) {
        AdapterInfo existing = this._adapterRegistry.getAdapter(adapterInstance.getID());
        if (existing != null) {
            this.unregisterAdapter(adapterInstance.getID());
        }
        this._adapterRegistry.addAdapter(new AdapterInfo(adapterInstance));
        return new MessageResult(MessageResult.ADAPTER_SUCCESSFULLY_REGISTERED);
    }

    public MessageResult unregisterAdapter(String adapterId) {
        this._adapterRegistry.removeAdapter(adapterId);
        return new MessageResult(MessageResult.ADAPTER_SUCCESSFULLY_UNREGISTERED);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageResult archiveDocument(BackEndMessage beMessage, String adapterId) throws AdapterException {
        if (_log.isInfoEnabled()) {
            _log.info("Received archive document request from adapter: {} msg-id:{}", (Object)adapterId, (Object)beMessage.getTransferIDText());
        }
        XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(adapterId);
        if (!this._activation.isActive()) {
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger license not activated. sending blocked.");
            _log.error("Messenger license not activated. archiving blocked.");
            ExtendedMessageResult result = new ExtendedMessageResult(MessageResult.MESSENGER_DOES_NOT_ACCEPT_REQUESTS);
            this.setMessageResult(result, beMessage);
            return result;
        }
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger is in maintenance mode. sending blocked.");
            _log.error("Messenger is blocking new outbound messages.");
            ExtendedMessageResult result = new ExtendedMessageResult(MessageResult.MAINTENANCE_MODE);
            this.setMessageResult(result, beMessage);
            return result;
        }
        try {
            this.duplicateInProcessGuardian.startProcess(beMessage.getTransferIDText());
        }
        catch (DuplicateInProcessException e) {
            this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenge with same message id (" + beMessage.getTransferIDText() + ") is currently being processed.");
            ExtendedMessageResult result = new ExtendedMessageResult(MessageResult.PENDING_MESSAGE_ID);
            this.setMessageResult(result, beMessage);
            return result;
        }
        Object lockObject = new Object();
        File outboundMessageFolder = null;
        try {
            this._maintenanceManager.putLock(lockObject);
            outboundMessageFolder = this.getNewTempFolder();
            XpMessage xpMessage = this.storeMessage(beMessage, adapterId, outboundMessageFolder);
            xpMessage.setDatabaseId(tempMessage.getDatabaseId());
            ExtendedMessageResult extendedMessageResult = this._sendToArchiveOnly.handleMessage(xpMessage);
            this.cleanupTempFolder(outboundMessageFolder);
            this._maintenanceManager.removeLock(lockObject);
            this.duplicateInProcessGuardian.endProcess(beMessage.getTransferIDText());
            return extendedMessageResult;
        }
        catch (BackEndMessageException bme) {
            try {
                _log.error("Could not internalize the message: {}", (Object)bme.getMessage());
                this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, bme.getMessage());
                throw new AdapterException("Could not internalize the message.", (Throwable)bme);
                catch (IOException io) {
                    _log.error("Attachment access problem: {}", (Object)io.getMessage());
                    this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, io.getMessage());
                    throw new AdapterException("Attachment access problem", (Throwable)io);
                }
            }
            catch (Throwable throwable) {
                this.cleanupTempFolder(outboundMessageFolder);
                this._maintenanceManager.removeLock(lockObject);
                this.duplicateInProcessGuardian.endProcess(beMessage.getTransferIDText());
                throw throwable;
            }
        }
    }

    public void writeXmlDocumentTo(String messageId, OutputStream out) throws AdapterException {
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        try {
            this._messages.writeXmlDocumentTo(messageId, out);
        }
        catch (Exception e) {
            throw new AdapterException(e.getMessage(), (Throwable)e);
        }
    }

    public void writeHtmlDocumentTo(String messageId, OutputStream out) throws AdapterException {
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        try {
            this._messages.writeHtmlDocumentTo(messageId, out);
        }
        catch (Exception e) {
            throw new AdapterException(e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return "DirectCommunication";
    }

    public boolean isConnected() {
        return true;
    }

    public String[] getSchemaSets(String localPartner, String remotePartner) throws AdapterException {
        if (this._maintenanceManager.isRejectOutboundMSGs()) {
            _log.error("Messenger is blocking new outbound messages.");
            throw new MaintenanceModeException("Messenger is blocking new outbound messages.");
        }
        try {
            CppPartner local = this._profiles.getProfileForInternalId(localPartner, true);
            CppPartner remote = this._profiles.getProfileForInternalId(remotePartner, true);
            Agreement agreement = this._agreements.getAgreement(local.getLocalId(), remote.getLocalId(), true);
            return agreement.getSchemaSets().keySet().toArray(new String[0]);
        }
        catch (Exception e) {
            _log.error("No Agreement found for " + localPartner + " and " + remotePartner);
            throw new AdapterException("No Agreement found for " + localPartner + " and " + remotePartner);
        }
    }

    public StatusResult sendLocalStatusRequest(String messageId, String id) {
        if (this.duplicateInProcessGuardian.contains(messageId)) {
            return new StatusResult(4);
        }
        return this._sendToArchiveOnly.checkStatusOfMessage(messageId);
    }

    private void copyAttachmentsToFolder(XpMessage xpMessage, BackEndMessage beMessage, File folder, boolean delete) throws IOException {
        xpMessage.removeAllAttachments();
        String[] attachments = beMessage.listAttachments();
        for (int i = 0; i < attachments.length; ++i) {
            File temp = beMessage.getAttachment(attachments[i]);
            File attachmentFolder = temp.getParentFile();
            File destinationFolder = folder;
            if (!"attachments".equals(destinationFolder.getName())) {
                destinationFolder = new File(destinationFolder, "attachments");
                destinationFolder.mkdir();
            }
            File destination = new File(destinationFolder, temp.getName());
            if (delete) {
                Files.move(temp.toPath(), destination.toPath(), new CopyOption[0]);
            } else {
                Files.copy(temp.toPath(), destination.toPath(), new CopyOption[0]);
            }
            xpMessage.addAttachment(new XpMessageAttachment(destination));
            if (attachmentFolder.list().length != 0) continue;
            attachmentFolder.delete();
        }
    }

    public void writePayloadToFile(XpMessage xpMessage, BackEndMessage beMessage, File contentReference) throws BackEndMessageException {
        beMessage.writeMessageDocumentTo(contentReference);
        xpMessage.setCurrentContentReference(contentReference);
        if (beMessage.isXml()) {
            xpMessage.setCurrentContentType("text/xml");
        } else {
            xpMessage.setCurrentContentType(MimeTypeMapper.getMimeType(contentReference.getName()));
        }
    }
}

