/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XpMessageSerializer {
    public static final Logger _log = LogManager.getLogger((String)"Messenger.XpMessageSerializer");
    public static final String MESSAGE_BACKUP_FILE = "xp-backup.dat";

    public Optional<XpMessage> deserialize(InputStream xpInputStream) {
        Optional<XpMessage> optional;
        ObjectInputStream ois = new ObjectInputStream(xpInputStream);
        try {
            optional = Optional.of((XpMessage)ois.readObject());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                _log.error("{} while deserializing XpMessage from InputStream: {}", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
                return Optional.empty();
            }
        }
        ois.close();
        return optional;
    }

    @Deprecated
    public void serialize(XpMessage xpMessage, OutputStream outputStream) {
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(xpMessage);
        }
        catch (IOException ex) {
            _log.error("{} while serializing XpMessage to outputstream: {}", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        }
    }
}

