/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class Pipeline {
    private final Logger _log;
    private final String _name;
    private final ArrayList<BaseFilter<IFilterPlugin>> _filters = new ArrayList();
    private final ApplicationContext _applicationContext;
    private final FileRefDAO _fileRefDAO;
    private final MessageDAO messageDAO;
    private String[] _filterNames;

    public Pipeline(String name, ApplicationContext applicationContext, String[] filterNames, FileRefDAO fileRefDAO, MessageDAO messageDAO) {
        this._name = name;
        this._log = LogManager.getLogger((String)("Messenger." + name + "_Pipeline"));
        this._applicationContext = applicationContext;
        this._fileRefDAO = fileRefDAO;
        this.messageDAO = messageDAO;
        this._filterNames = filterNames;
    }

    @PostConstruct
    protected void init() {
        if (this._log.isDebugEnabled()) {
            this._log.debug("[{}] Start initialing Pipeline: {}", (Object)this._name, (Object)this._name);
        }
        for (int i = 0; i < this._filterNames.length; ++i) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("[{}] init of {}", (Object)this._name, (Object)this._filterNames[i]);
            }
            try {
                BaseFilter someFilter = (BaseFilter)this._applicationContext.getBean(this._filterNames[i], BaseFilter.class);
                this._filters.add(someFilter);
                continue;
            }
            catch (BeansException e) {
                this._log.warn("plugin {} could not be created: ", (Object)this._filterNames[i], (Object)e);
            }
        }
    }

    protected ArrayList<BaseFilter<IFilterPlugin>> getFilters() {
        return this._filters;
    }

    public void process(XpMessage xpMessage) throws BaseFilterException {
        String processedOriginalFilename = xpMessage.getProcessingDirective("ProcessedOriginalFilename");
        if (StringUtils.isEmpty((CharSequence)processedOriginalFilename) && xpMessage.getCurrentContentReference() != null) {
            xpMessage.setProcessingDirective("ProcessedOriginalFilename", xpMessage.getCurrentContentReference().getName());
        }
        try {
            for (int i = 0; i < this._filters.size(); ++i) {
                BaseFilter<IFilterPlugin> tempFilter = this._filters.get(i);
                tempFilter.doFilter(xpMessage);
            }
        }
        catch (BaseFilterException e) {
            if (xpMessage.recognizePayload().isValid()) {
                try {
                    this.messageDAO.updateMessage(xpMessage);
                }
                catch (DbException ex) {
                    this._log.error("[{}] Cannot update Message. {}", (Object)xpMessage.getDatabaseId(), (Object)ex);
                }
            }
            File file = xpMessage.getCurrentContentReference();
            File folder = xpMessage.getCurrentContentReferenceFolder();
            if (file != null && folder != null) {
                this._fileRefDAO.insertMessageFileReference(xpMessage.getDatabaseId(), folder, file.getName(), xpMessage.getCurrentContentType());
            }
            throw e;
        }
    }
}

