/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupFailed;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class Messenger
implements IServiceProvider {
    private static final String PROPERTY_SCHEMASET_VALIDATION_EFET = "ponton.messenger.schemaset.validation.efet";
    private static final String DEFAULT_SCHEMASET_VALIDATION_EFET = "false";
    public static final String DEFAULT_DOMAIN = "ponton.xp";
    public static final String DEFAULT_DOMAIN2 = "myown";
    private static final Pattern FILENAME_FIX_PATTERN = Pattern.compile("[^a-z0-9A-Z@\\-_.]");
    public static final String PAYLOAD_FILE_NAME_PREFIX = "payload";
    public static final String ORIGINAL_FILENAME_HEADER = "X-Original-Filename";
    public static final String DEFAULT_PIPELINE_ID = "NONE";
    public static final String DEFAULT_PACKAGING_ID = "EbXml20";
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.Messenger");
    private static boolean _developerMode = false;
    private static boolean _schemasetValidationEFET = false;
    private static long _startTime;
    private final MessengerConfig _messengerConfig;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ActivationControl _activationControl;
    private final EventLog _EventLog;
    private final IMessengerProperties _messengerProperties;

    public Messenger(MessengerConfig messengerConfig, ApplicationEventPublisher applicationEventPublisher, ActivationControl activationControl, EventLog EventLog2, IMessengerProperties messengerProperties) {
        this._messengerConfig = messengerConfig;
        this.applicationEventPublisher = applicationEventPublisher;
        this._activationControl = activationControl;
        this._EventLog = EventLog2;
        this._messengerProperties = messengerProperties;
    }

    private void start() throws Exception {
        try {
            this.initDevelopmentMode();
            this.checkForDefaultMsgIdDomain();
            this.loadSchemataConfig();
            _startTime = System.currentTimeMillis();
            _log.info((Object)"Messenger initialization is completed");
            this._activationControl.updateActivationState();
        }
        catch (Exception e) {
            this.printAndLogError(e);
            _log.error((Object)"*********************************************************************");
            _log.error((Object)"error in init", (Throwable)e);
            throw e;
        }
    }

    private void checkForDefaultMsgIdDomain() throws JAXBException {
        if (DEFAULT_DOMAIN.equals(this._messengerConfig.getMessageIdDomain()) || DEFAULT_DOMAIN2.equals(this._messengerConfig.getMessageIdDomain())) {
            try {
                this._EventLog.writeWarning("messenger.config_check.msgdomainproblem", "messenger.config_check.component", "messenger.config_check.desciptionKey", "", new String[]{this._messengerConfig.getMessageIdDomain()}, "/private/communication/serverTab.jsp?tabName=common");
            }
            catch (Exception exception) {}
        } else {
            try {
                this._EventLog.deleteEvent("messenger.config_check.msgdomainproblem");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void printAndLogError(Exception se) {
        try {
            this._EventLog.writeError("messenger.startup.problem", "messenger.startup_error.component", "messenger.startup_error.descriptionKey", "", new String[]{se.getMessage()}, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("*********************************************************************\n");
        System.out.println("    ERROR while initializing Messenger V" + Constants.getXP_VERSION() + "\n");
        System.out.println("    please check the messenger logfile for further details.\n");
        try {
            _log.error((Object)("    it is located at " + System.getProperty("pontonlog.file.logfolder", "$PONTONXP_HOME/log") + "/messenger.log\n"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        _log.error((Object)"*********************************************************************");
    }

    private void initDevelopmentMode() {
        try {
            _developerMode = this._messengerProperties.isDeveloperMode();
            if (_developerMode) {
                _log.info((Object)"DevelopmentMode active");
                File mergedPropertiesFile = new File(System.getProperty("java.io.tmpdir"), "ponton-messenger-merged.properties");
                _log.info((Object)("Storing merged messenger properties file: " + mergedPropertiesFile.getAbsolutePath()));
                try {
                    this._messengerProperties.storeMergedProperties(mergedPropertiesFile);
                    _log.info((Object)("Stored merged messenger properties file: " + mergedPropertiesFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    _log.error((Object)("Could not store merged messenger properties file: " + String.valueOf(e)));
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void loadSchemataConfig() {
        try {
            String schemasetValidationEFET = this._messengerProperties.getProperty(PROPERTY_SCHEMASET_VALIDATION_EFET, DEFAULT_SCHEMASET_VALIDATION_EFET);
            _schemasetValidationEFET = Boolean.parseBoolean(schemasetValidationEFET);
            if (_schemasetValidationEFET) {
                _log.info((Object)"Special EFET schemaset validation activated.");
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static boolean isDevelopmentMode() {
        return _developerMode;
    }

    public static boolean isEFETSchemaSetValidation() {
        return _schemasetValidationEFET;
    }

    public static long getUsedMemory() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
    }

    public static long getUptime() {
        return System.currentTimeMillis() - _startTime;
    }

    public MessengerConfig getMessengerConfig() {
        return this._messengerConfig;
    }

    private void shutdown() {
        _log.info((Object)"Stopping Messenger");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
    }

    public static String getFixedFilename(String name) {
        if (name != null) {
            Matcher m = FILENAME_FIX_PATTERN.matcher(name);
            return m.replaceAll("_");
        }
        return null;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StartupService) {
            StartupService startupEvent = (StartupService)event;
            if (this.getServiceLevel() == startupEvent.getServiceLevel()) {
                try {
                    this.start();
                }
                catch (Exception e) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new StartupFailed(this, "Could not start the Messenger service.", e));
                }
            }
        } else if (event instanceof ShutdownService) {
            ShutdownService shutdownEvent = (ShutdownService)event;
            if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                this.shutdown();
            }
        }
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    @Override
    public String getServiceName() {
        return "Messenger";
    }
}

