/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.messenger.DuplicateInProcessException;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DuplicateInProcessGuardian {
    public static final Logger LOG = LogManager.getLogger((String)"Messenger.DuplicateInProcessGuardian");
    private final HashSet<String> inProcess = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startProcess(String messageId) throws DuplicateInProcessException {
        if (this.isNotBlank(messageId) && !"OverwriteMessageId".equalsIgnoreCase(messageId)) {
            HashSet<String> hashSet = this.inProcess;
            synchronized (hashSet) {
                if (this.inProcess.contains(messageId)) {
                    LOG.error("Message with same message id is currently being processed. msgId:{}", (Object)messageId);
                    throw new DuplicateInProcessException();
                }
                this.inProcess.add(messageId);
            }
        }
    }

    public synchronized void endProcess(String messageId) {
        if (this.isNotBlank(messageId)) {
            this.inProcess.remove(messageId);
        }
    }

    public synchronized boolean contains(String messageId) {
        return this.isNotBlank(messageId) && this.inProcess.contains(messageId);
    }

    private boolean isNotBlank(String messageId) {
        return messageId != null && !messageId.isBlank();
    }
}

