/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.status.ObjectFactory;
import de.pontonconsulting.xmlpipe.message.status.XpStatusResponse;
import de.pontonconsulting.xmlpipe.soap.ebxml.DateTime;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;

public class XpStatusResponse {
    private static final String XP_STATUS_CLASSES = "de.pontonconsulting.xmlpipe.message.status";
    private static final String ENCODING = "UTF-8";
    private static final String STATUS_RESPONSE_FILE = "xpStatusResponse.xml";
    public static final String STATUS_RESPONSE = "StatusResponse";
    private static ObjectFactory _factory = new ObjectFactory();
    private final de.pontonconsulting.xmlpipe.message.status.XpStatusResponse _statusResponse;
    private final JAXBContext _jc = JAXBContext.newInstance((String)"de.pontonconsulting.xmlpipe.message.status");

    public XpStatusResponse(byte[] statusResponseBytes) throws JAXBException {
        Unmarshaller u = this._jc.createUnmarshaller();
        ByteArrayInputStream statusResponseStream = new ByteArrayInputStream(statusResponseBytes);
        this._statusResponse = (de.pontonconsulting.xmlpipe.message.status.XpStatusResponse)u.unmarshal((InputStream)statusResponseStream);
    }

    public XpStatusResponse(File ackFile) throws JAXBException {
        Unmarshaller u = this._jc.createUnmarshaller();
        this._statusResponse = (de.pontonconsulting.xmlpipe.message.status.XpStatusResponse)u.unmarshal(ackFile);
    }

    public XpStatusResponse(XpMessage message, String statusRequestId, Date requestReceptionTimestamp) throws JAXBException {
        this(message.getMessageId(), statusRequestId, requestReceptionTimestamp);
        this.setResponseReceptionTimestamp(message.getMessageTimestamp());
    }

    public void setRequestReceptionTimestamp(Date requestReceptionTimestamp) {
        String time = null;
        if (requestReceptionTimestamp != null) {
            time = DateTime.formatDate(requestReceptionTimestamp);
        }
        this._statusResponse.setMessageTime(time);
    }

    public XpStatusResponse(String statusResponseId, String statusRequestId, Date responseReceptionTimestamp) throws JAXBException {
        this._statusResponse = _factory.createXpStatusResponse();
        this.setStatusResponseId(statusResponseId);
        this.setStatusRequestId(statusRequestId);
        this.setResponseReceptionTimestamp(responseReceptionTimestamp);
    }

    public void setResponseReceptionTimestamp(Date responseReceptionTimestamp) {
        String time = null;
        if (responseReceptionTimestamp != null) {
            time = DateTime.formatDate(responseReceptionTimestamp);
        }
        this._statusResponse.setMessageTime(time);
    }

    public void setStatusRequestId(String statusResponseId) {
        this._statusResponse.setReferenceId(statusResponseId);
    }

    public void setStatusResponseId(String statusResponseId) {
        this._statusResponse.setMessageId(statusResponseId);
    }

    public File saveToDisk(File destinationFolder, String name) throws JAXBException {
        destinationFolder.mkdirs();
        File destination = new File(destinationFolder, name);
        Marshaller m = this._jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)ENCODING);
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new BufferedOutputStream(Files.newOutputStream(destination.toPath(), new OpenOption[0])));
            m.marshal((Object)this._statusResponse, (OutputStream)bos);
        }
        catch (IOException e) {
            throw new JAXBException("Status Response file '" + String.valueOf(destination) + "' could not be opened for writing: " + e.getMessage());
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return destination;
    }

    public File saveToDisk(File destinationFolder) throws JAXBException {
        destinationFolder.mkdirs();
        return this.saveToDisk(destinationFolder, STATUS_RESPONSE_FILE);
    }

    public void setStatusResponse(String refMessageId, String status, Date statusResponseMSGTimestamp) {
        XpStatusResponse.StatusResponse statusResponse = _factory.createXpStatusResponseStatusResponse();
        statusResponse.setStatus(status);
        statusResponse.setMessageReferenceId(refMessageId);
        String time = null;
        if (statusResponseMSGTimestamp != null) {
            time = DateTime.formatDate(statusResponseMSGTimestamp);
        }
        statusResponse.setMessageReceptionTime(time);
        this._statusResponse.setStatusResponse(statusResponse);
    }
}

